/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.jkeygen.keystore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.jkeygen.keypair.CertificationResult;
import org.adorsys.jkeygen.keypair.SelfSignedKeyPairData;
import org.adorsys.jkeygen.keystore.KeyEntry;
import org.adorsys.jkeygen.keystore.KeyPairData;
import org.adorsys.jkeygen.keystore.KeyPairEntry;
import org.adorsys.jkeygen.keystore.PasswordCallbackUtils;
import org.adorsys.jkeygen.keystore.SecretKeyData;
import org.adorsys.jkeygen.keystore.SecretKeyEntry;
import org.adorsys.jkeygen.keystore.TrustedCertData;
import org.adorsys.jkeygen.keystore.TrustedCertEntry;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;
import org.adorsys.jkeygen.utils.V3CertificateUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;

public class KeyStoreService {
    private KeyStoreService() {
        throw new IllegalStateException("Not supported");
    }

    public static KeyStore newKeyStore(String storeType) throws IOException {
        if (StringUtils.isBlank(storeType)) {
            storeType = "UBER";
        }
        try {
            KeyStore ks = KeyStore.getInstance(storeType);
            ks.load(null, null);
            return ks;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] toByteArray(KeyStore keystore, String storeId, CallbackHandler storePassSrc) throws NoSuchAlgorithmException, CertificateException, IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            keystore.store(stream, PasswordCallbackUtils.getPassword(storePassSrc, storeId));
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Keystore not initialized.", e);
        }
        return stream.toByteArray();
    }

    public static KeyStore loadKeyStore(InputStream in, String storeId, String storeType, CallbackHandler storePassSrc) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, IOException {
        if (StringUtils.isBlank(storeType)) {
            storeType = "UBER";
        }
        KeyStore ks = KeyStore.getInstance(storeType);
        try {
            ks.load(in, PasswordCallbackUtils.getPassword(storePassSrc, storeId));
        }
        catch (IOException e) {
            if (e.getCause() != null && e.getCause() instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof BadPaddingException) {
                throw new UnrecoverableKeyException(e.getMessage());
            }
            throw e;
        }
        return ks;
    }

    public static KeyStore loadKeyStore(String storeType, KeyStore.LoadStoreParameter loadStoreParameter) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, IOException {
        if (StringUtils.isBlank(storeType)) {
            storeType = "UBER";
        }
        KeyStore ks = KeyStore.getInstance(storeType);
        try {
            ks.load(loadStoreParameter);
        }
        catch (IOException e) {
            if (e.getCause() != null && e.getCause() instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof BadPaddingException) {
                throw new UnrecoverableKeyException(e.getMessage());
            }
            throw e;
        }
        return ks;
    }

    public static KeyStore loadKeyStore(byte[] data, String storeId, String storeType, CallbackHandler storePassSrc) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return KeyStoreService.loadKeyStore(new ByteArrayInputStream(data), storeId, storeType, storePassSrc);
    }

    public static void fillKeyStore(KeyStore ks, Collection<KeyEntry> keyEntries) {
        try {
            for (KeyEntry keyEntry : keyEntries) {
                KeyStoreService.addToKeyStore(ks, keyEntry);
            }
        }
        catch (KeyStoreException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public static void addToKeyStore(KeyStore ks, KeyEntry keyEntry) throws KeyStoreException {
        if (keyEntry instanceof KeyPairEntry) {
            KeyStoreService.addToKeyStore(ks, (KeyPairEntry)keyEntry);
        } else if (keyEntry instanceof SecretKeyEntry) {
            KeyStoreService.addToKeyStore(ks, (SecretKeyEntry)keyEntry);
        } else if (keyEntry instanceof TrustedCertEntry) {
            KeyStoreService.addToKeyStore(ks, (TrustedCertEntry)keyEntry);
        }
    }

    private static void addToKeyStore(KeyStore ks, KeyPairEntry keyPairHolder) throws KeyStoreException {
        ArrayList<X509Certificate> chainList = new ArrayList<X509Certificate>();
        CertificationResult certification = keyPairHolder.getCertification();
        X509CertificateHolder subjectCert = certification != null ? certification.getSubjectCert() : keyPairHolder.getKeyPair().getSubjectCert();
        chainList.add(V3CertificateUtils.getX509JavaCertificate(subjectCert));
        if (certification != null) {
            List<X509CertificateHolder> issuerChain = certification.getIssuerChain();
            for (X509CertificateHolder x509CertificateHolder : issuerChain) {
                chainList.add(V3CertificateUtils.getX509JavaCertificate(x509CertificateHolder));
            }
        }
        java.security.cert.Certificate[] chain = chainList.toArray(new java.security.cert.Certificate[chainList.size()]);
        ks.setKeyEntry(keyPairHolder.getAlias(), keyPairHolder.getKeyPair().getKeyPair().getPrivate(), PasswordCallbackUtils.getPassword(keyPairHolder.getPasswordSource(), keyPairHolder.getAlias()), chain);
    }

    public static void addToKeyStore(KeyStore ks, SecretKeyEntry secretKeyData) {
        KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(secretKeyData.getSecretKey());
        KeyStore.ProtectionParameter protParam = KeyStoreService.getPasswordProtectionParameter(secretKeyData.getPasswordSource(), secretKeyData.getAlias());
        try {
            ks.setEntry(secretKeyData.getAlias(), entry, protParam);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    private static KeyStore.ProtectionParameter getPasswordProtectionParameter(CallbackHandler passwordSource, String alias) {
        return new KeyStore.PasswordProtection(PasswordCallbackUtils.getPassword(passwordSource, alias));
    }

    private static void addToKeyStore(KeyStore ks, TrustedCertEntry trustedCertHolder) throws KeyStoreException {
        ks.setCertificateEntry(trustedCertHolder.getAlias(), V3CertificateUtils.getX509JavaCertificate(trustedCertHolder.getCertificate()));
    }

    public static List<KeyEntry> loadEntries(KeyStore keyStore, PasswordProvider passwordProvider) {
        Enumeration<String> aliases;
        ArrayList<KeyEntry> keyEntries = new ArrayList<KeyEntry>();
        try {
            aliases = keyStore.aliases();
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        for (String alias : Collections.list(aliases)) {
            try {
                CallbackHandler passwordSource = passwordProvider.providePasswordCallbackHandler(alias);
                KeyStore.Entry entry = keyStore.getEntry(alias, KeyStoreService.getPasswordProtectionParameter(passwordSource, alias));
                KeyEntry keyEntry = KeyStoreService.createFromKeyStoreEntry(alias, entry, passwordSource);
                keyEntries.add(keyEntry);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
                throw new RuntimeException(e);
            }
        }
        return keyEntries;
    }

    public static Map<String, KeyEntry> loadEntryMap(KeyStore keyStore, PasswordProvider passwordProvider) {
        Enumeration<String> aliases;
        HashMap<String, KeyEntry> keyEntries = new HashMap<String, KeyEntry>();
        try {
            aliases = keyStore.aliases();
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        for (String alias : Collections.list(aliases)) {
            try {
                CallbackHandler passwordSource = passwordProvider.providePasswordCallbackHandler(alias);
                KeyStore.Entry entry = keyStore.getEntry(alias, KeyStoreService.getPasswordProtectionParameter(passwordSource, alias));
                KeyEntry keyEntry = KeyStoreService.createFromKeyStoreEntry(alias, entry, passwordSource);
                keyEntries.put(alias, keyEntry);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
                throw new RuntimeException(e);
            }
        }
        return keyEntries;
    }

    private static KeyEntry createFromKeyStoreEntry(String alias, KeyStore.Entry entry, CallbackHandler passwordSource) {
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
            return KeyStoreService.fromPrivateKeyEntry(alias, passwordSource, privateKeyEntry);
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
            SecretKey secretKey = secretKeyEntry.getSecretKey();
            return SecretKeyData.builder().alias(alias).passwordSource(passwordSource).secretKey(secretKey).keyAlgo(secretKey.getAlgorithm()).build();
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trustedCertificateEntry = (KeyStore.TrustedCertificateEntry)entry;
            return TrustedCertData.builder().alias(alias).passwordSource(passwordSource).certificate(KeyStoreService.toX509CertificateHolder(trustedCertificateEntry.getTrustedCertificate())).build();
        }
        throw new RuntimeException("Unknown type: " + entry.getClass());
    }

    private static KeyPairEntry fromPrivateKeyEntry(String alias, CallbackHandler passwordSource, KeyStore.PrivateKeyEntry privateKeyEntry) {
        KeyPair keyPair = new KeyPair(privateKeyEntry.getCertificate().getPublicKey(), privateKeyEntry.getPrivateKey());
        X509CertificateHolder subjectCert = KeyStoreService.toX509CertificateHolder(privateKeyEntry.getCertificate());
        SelfSignedKeyPairData keyPairData = new SelfSignedKeyPairData(keyPair, subjectCert);
        CertificationResult certification = new CertificationResult(subjectCert, KeyStoreService.toX509CertificateHolders(privateKeyEntry.getCertificateChain()));
        return KeyPairData.builder().alias(alias).keyPair(keyPairData).certification(certification).passwordSource(passwordSource).build();
    }

    private static List<X509CertificateHolder> toX509CertificateHolders(java.security.cert.Certificate[] certificates) {
        return Arrays.stream(certificates).map(KeyStoreService::toX509CertificateHolder).collect(Collectors.toList());
    }

    private static X509CertificateHolder toX509CertificateHolder(java.security.cert.Certificate certificate) {
        Certificate bouncyCastleAsn1Certificate = null;
        try {
            bouncyCastleAsn1Certificate = Certificate.getInstance(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
        return new X509CertificateHolder(bouncyCastleAsn1Certificate);
    }

    public static class SimplePasswordProvider
    implements PasswordProvider {
        private final CallbackHandler callbackHandler;

        public SimplePasswordProvider(char[] password) {
            this.callbackHandler = new PasswordCallbackHandler(password);
        }

        public SimplePasswordProvider(CallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
        }

        @Override
        public CallbackHandler providePasswordCallbackHandler(String keyAlias) {
            return this.callbackHandler;
        }
    }

    public static class PasswordProviderMap
    implements PasswordProvider {
        private final Map<String, char[]> passwordsForAlias;

        public PasswordProviderMap(Map<String, char[]> passwordsForAlias) {
            this.passwordsForAlias = passwordsForAlias;
        }

        @Override
        public CallbackHandler providePasswordCallbackHandler(String keyAlias) {
            char[] password = this.passwordsForAlias.get(keyAlias);
            if (password == null) {
                throw new RuntimeException("Password for alias '" + keyAlias + "' not found");
            }
            return new PasswordCallbackHandler(password);
        }
    }

    public static interface PasswordProvider {
        public CallbackHandler providePasswordCallbackHandler(String var1);
    }
}

