/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.jjwk.serverkey;

import com.nimbusds.jose.jwk.JWKSet;
import java.security.Key;
import org.adorsys.jjwk.serverkey.KeyAndJwk;
import org.adorsys.jjwk.serverkey.ServerKeyMap;
import org.adorsys.jjwk.serverkey.ServerKeyMapProvider;
import org.adorsys.jjwk.serverkey.ServerKeysHolder;

public class ServerKeyManager
implements ServerKeyMapProvider {
    private final ServerKeysHolder serverKeysHolder;
    private final ServerKeyMap keyMap;

    public ServerKeyManager(ServerKeysHolder serverKeysHolder) {
        this.serverKeysHolder = serverKeysHolder;
        this.keyMap = new ServerKeyMap(serverKeysHolder.getPrivateKeySet());
    }

    @Override
    public ServerKeysHolder getServerKeysHolder() {
        return this.serverKeysHolder;
    }

    @Override
    public JWKSet getPublicKeys() {
        return this.serverKeysHolder.getPublicKeySet();
    }

    @Override
    public KeyAndJwk randomSecretKey() {
        return this.keyMap.randomSecretKey();
    }

    @Override
    public KeyAndJwk randomSignKey() {
        return this.keyMap.randomSignKey();
    }

    @Override
    public Key getKey(String keyId) {
        return this.keyMap.getKey(keyId);
    }

    @Override
    public ServerKeyMap getKeyMap() {
        return this.keyMap;
    }
}

