/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.jjwk.serverkey;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.BadPaddingException;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.jkeygen.keystore.PasswordCallbackUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KeyStoreUtils {
    public static KeyStore loadKeyStore(InputStream in, String storeId, String storeType, CallbackHandler storePassSrc) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, IOException {
        if (StringUtils.isBlank(storeType)) {
            throw new IllegalArgumentException("Missing keystore type");
        }
        KeyStore ks = null;
        ks = StringUtils.equalsIgnoreCase("JKS", storeType) ? KeyStore.getInstance(storeType) : KeyStore.getInstance(storeType, new BouncyCastleProvider());
        try {
            ks.load(in, PasswordCallbackUtils.getPassword(storePassSrc, storeId));
        }
        catch (IOException e) {
            if (e.getCause() != null && e.getCause() instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof BadPaddingException) {
                throw new UnrecoverableKeyException(e.getMessage());
            }
            throw e;
        }
        return ks;
    }
}

