/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.jkeygen.utils;

import java.util.Arrays;
import org.adorsys.jkeygen.utils.CertVerifier;
import org.adorsys.jkeygen.utils.KeyIdUtils;
import org.adorsys.jkeygen.utils.KeyUsageUtils;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CertificateHolder;

public class CheckCaCertificate {
    public static boolean isSigingCertificate(X509CertificateHolder signed, X509CertificateHolder signer) {
        if (!signed.getIssuer().equals(signer.getSubject())) {
            return false;
        }
        AuthorityKeyIdentifier authorityKeyIdentifier = KeyIdUtils.readAuthorityKeyIdentifier(signed);
        if (authorityKeyIdentifier == null) {
            return false;
        }
        SubjectKeyIdentifier subjectKeyIdentifier = KeyIdUtils.readSubjectKeyIdentifier(signer);
        if (!Arrays.equals(subjectKeyIdentifier.getKeyIdentifier(), authorityKeyIdentifier.getKeyIdentifier())) {
            return false;
        }
        if (!signer.getSerialNumber().equals(authorityKeyIdentifier.getAuthorityCertSerialNumber())) {
            return false;
        }
        return CertVerifier.verify(signed, signer);
    }

    public static boolean isCaCertificate(X509CertificateHolder issuerCertificate) {
        Extension basicConstraintsExtension = issuerCertificate.getExtension(X509Extension.basicConstraints);
        BasicConstraints issuerBasicConstraints = BasicConstraints.getInstance(basicConstraintsExtension.getParsedValue());
        if (!issuerBasicConstraints.isCA()) {
            return false;
        }
        int ku = KeyUsageUtils.getKeyUsage(issuerCertificate);
        return (4 & ku) > 0;
    }
}

