/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.jkeygen.keystore;

import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.jkeygen.keystore.KeyEntryData;
import org.adorsys.jkeygen.keystore.KeyStoreService;

public class KeystoreBuilder {
    private String storeType;
    private String storeId;
    private Map<String, KeyEntryData> keyEntries = new HashMap<String, KeyEntryData>();

    public KeystoreBuilder withStoreType(String storeType) {
        this.storeType = storeType;
        return this;
    }

    public KeystoreBuilder withStoreId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    public KeystoreBuilder withKeyEntry(KeyEntryData keyEntry) {
        this.keyEntries.put(keyEntry.getAlias(), keyEntry);
        return this;
    }

    public byte[] build(CallbackHandler storePassSrc) throws IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStoreService.newKeyStore(this.storeType);
        KeyStoreService.fillKeyStore(ks, this.keyEntries.values());
        return KeyStoreService.toByteArray(ks, this.storeId, storePassSrc);
    }
}

