/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keycloak.mapper;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.nimbusds.jose.crypto.DirectEncrypter;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.adorsys.envutils.EnvProperties;
import org.adorsys.jjwk.selector.JWEEncryptedSelector;
import org.adorsys.jjwk.selector.KeyExtractionException;
import org.adorsys.jjwk.selector.UnsupportedEncAlgorithmException;
import org.adorsys.jjwk.selector.UnsupportedKeyLengthException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessToken;

public class SecretTokenMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "secret-token-mapper";
    private byte[] secretEncryptionPassword;
    private static final String CREDENTIAL_TYPE = "custom_secret";

    public void postInit(KeycloakSessionFactory factory) {
        String prop = EnvProperties.getEnvOrSysProp("SECRET_ENCRYPTION_PASSWORD", false);
        try {
            this.secretEncryptionPassword = prop.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        super.postInit(factory);
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getDisplayType() {
        return "User Attribute";
    }

    public String getHelpText() {
        return "Map a db user sercret attribute to token.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public AccessToken transformAccessToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        List attribute = userSession.getUser().getAttribute(CREDENTIAL_TYPE);
        String customSecretAttr = attribute == null || attribute.isEmpty() ? this.generateUserSecret(userSession) : (String)attribute.iterator().next();
        String serializedSecret = this.wrapSecretForResourceServer(customSecretAttr, userSession, session);
        if (serializedSecret != null) {
            token.getOtherClaims().put(CREDENTIAL_TYPE, serializedSecret);
        }
        return token;
    }

    private String wrapSecretForResourceServer(String customSecretAttr, UserSessionModel userSession, KeycloakSession session) {
        try {
            JWEObject jweObject = JWEObject.parse(customSecretAttr);
            DirectDecrypter decrypter = new DirectDecrypter(this.secretEncryptionPassword);
            jweObject.decrypt(decrypter);
            Payload payload = jweObject.getPayload();
            String url = EnvProperties.getEnvOrSysProp(userSession.getRealm().getName().toUpperCase() + "_PUBLIC_KEY_URL", true);
            if (url == null) {
                return null;
            }
            JWKSet jwkSet = JWKSet.parse(this.getPublicKey(url));
            JWK jwk = jwkSet.getKeys().iterator().next();
            JWEEncrypter jweEncrypter = JWEEncryptedSelector.geEncrypter(jwk, null, null);
            JWEObject jweObj = new JWEObject(this.getHeader(jwk), payload);
            jweObj.encrypt(jweEncrypter);
            return jweObj.serialize();
        }
        catch (JOSEException | ParseException | KeyExtractionException | UnsupportedEncAlgorithmException | UnsupportedKeyLengthException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getPublicKey(String url) {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpGet get = new HttpGet(url);
            try {
                HttpResponse response = client.execute((HttpUriRequest)get);
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new RuntimeException("invalid public key response: " + url);
                }
                HttpEntity entity = response.getEntity();
                InputStream is = entity.getContent();
                String string = IOUtils.toString(is, "UTF-8");
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private JWEHeader getHeader(JWK jwk) throws JOSEException {
        JWEHeader header;
        if (jwk instanceof RSAKey) {
            header = new JWEHeader(JWEAlgorithm.RSA_OAEP, EncryptionMethod.A128GCM);
        } else if (jwk instanceof ECKey) {
            header = new JWEHeader(JWEAlgorithm.ECDH_ES_A128KW, EncryptionMethod.A192GCM);
        } else {
            return null;
        }
        return new JWEHeader.Builder(header).keyID(jwk.getKeyID()).build();
    }

    private String generateUserSecret(UserSessionModel userSession) {
        String randomGraph = RandomStringUtils.randomGraph(16);
        JWEHeader.Builder headerBuilder = new JWEHeader.Builder(JWEAlgorithm.DIR, EncryptionMethod.A128GCM);
        JWEObject jweObj = new JWEObject(headerBuilder.build(), new Payload(randomGraph));
        try {
            DirectEncrypter encrypter = new DirectEncrypter(this.secretEncryptionPassword);
            jweObj.encrypt(encrypter);
        }
        catch (JOSEException e) {
            throw new IllegalStateException(e);
        }
        String customSecretAttr = jweObj.serialize();
        userSession.getUser().setAttribute(CREDENTIAL_TYPE, Arrays.asList(customSecretAttr));
        return customSecretAttr;
    }
}

