/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.jkeygen.keystore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.jkeygen.keypair.CertificationResult;
import org.adorsys.jkeygen.keystore.KeyEntryData;
import org.adorsys.jkeygen.keystore.KeyPairData;
import org.adorsys.jkeygen.keystore.PasswordCallbackUtils;
import org.adorsys.jkeygen.keystore.SecretKeyData;
import org.adorsys.jkeygen.keystore.TrustedCertData;
import org.adorsys.jkeygen.utils.V3CertificateUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.cert.X509CertificateHolder;

public class KeyStoreService {
    public static KeyStore newKeyStore(String storeType) throws IOException {
        if (StringUtils.isBlank(storeType)) {
            storeType = "UBER";
        }
        try {
            KeyStore ks = KeyStore.getInstance(storeType);
            ks.load(null, null);
            return ks;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] toByteArray(KeyStore keystore, String storeId, CallbackHandler storePassSrc) throws NoSuchAlgorithmException, CertificateException, IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            keystore.store(stream, PasswordCallbackUtils.getPassword(storePassSrc, storeId));
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Keystore not initialized.", e);
        }
        return stream.toByteArray();
    }

    public static KeyStore loadKeyStore(InputStream in, String storeId, String storeType, CallbackHandler storePassSrc) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, IOException {
        if (StringUtils.isBlank(storeType)) {
            storeType = "UBER";
        }
        KeyStore ks = KeyStore.getInstance(storeType);
        try {
            ks.load(in, PasswordCallbackUtils.getPassword(storePassSrc, storeId));
        }
        catch (IOException e) {
            if (e.getCause() != null && e.getCause() instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof BadPaddingException) {
                throw new UnrecoverableKeyException(e.getMessage());
            }
            throw e;
        }
        return ks;
    }

    public static KeyStore loadKeyStore(byte[] data, String storeId, String storeType, CallbackHandler storePassSrc) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return KeyStoreService.loadKeyStore(new ByteArrayInputStream(data), storeId, storeType, storePassSrc);
    }

    public static void fillKeyStore(KeyStore ks, Collection<KeyEntryData> keyEntries) {
        try {
            for (KeyEntryData keyEntryData : keyEntries) {
                if (keyEntryData instanceof KeyPairData) {
                    KeyStoreService.addToKeyStore(ks, (KeyPairData)keyEntryData);
                    continue;
                }
                if (keyEntryData instanceof SecretKeyData) {
                    KeyStoreService.addToKeyStore(ks, (SecretKeyData)keyEntryData);
                    continue;
                }
                if (!(keyEntryData instanceof TrustedCertData)) continue;
                KeyStoreService.addToKeyStore(ks, (TrustedCertData)keyEntryData);
            }
        }
        catch (KeyStoreException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    private static void addToKeyStore(KeyStore ks, KeyPairData keyPairHolder) throws KeyStoreException {
        ArrayList<X509Certificate> chainList = new ArrayList<X509Certificate>();
        CertificationResult certification = keyPairHolder.getCertification();
        X509CertificateHolder subjectCert = certification != null ? certification.getSubjectCert() : keyPairHolder.getKeyPairs().getSubjectCert();
        chainList.add(V3CertificateUtils.getX509JavaCertificate(subjectCert));
        if (certification != null) {
            List<X509CertificateHolder> issuerChain = certification.getIssuerChain();
            for (X509CertificateHolder x509CertificateHolder : issuerChain) {
                chainList.add(V3CertificateUtils.getX509JavaCertificate(x509CertificateHolder));
            }
        }
        Certificate[] chain = chainList.toArray(new Certificate[chainList.size()]);
        ks.setKeyEntry(keyPairHolder.getAlias(), keyPairHolder.getKeyPairs().getKeyPair().getPrivate(), PasswordCallbackUtils.getPassword(keyPairHolder.getPasswordSource(), keyPairHolder.getAlias()), chain);
    }

    public static void addToKeyStore(KeyStore ks, SecretKeyData secretKeyData) {
        KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(secretKeyData.getSecretKey());
        KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(PasswordCallbackUtils.getPassword(secretKeyData.getPasswordSource(), secretKeyData.getAlias()));
        try {
            ks.setEntry(secretKeyData.getAlias(), entry, protParam);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void addToKeyStore(KeyStore ks, TrustedCertData trustedCertHolder) throws KeyStoreException {
        ks.setCertificateEntry(trustedCertHolder.getAlias(), V3CertificateUtils.getX509JavaCertificate(trustedCertHolder.getCertificate()));
    }
}

