/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.jjwk.kid;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.util.Base64URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.jjwk.keystore.JwkExport;
import org.adorsys.jkeygen.keystore.PasswordCallbackUtils;
import org.apache.commons.lang3.StringUtils;

public class FixKeyId {
    public static boolean fixKeyId(KeyStore ks, CallbackHandler callbackHandler) {
        try {
            JWKSet exportPrivateKeys = JwkExport.exportKeys(ks, callbackHandler);
            List<JWK> keys = exportPrivateKeys.getKeys();
            boolean change = false;
            for (JWK jwk : keys) {
                Base64URL thumbprint;
                String expectedKeyId;
                String keyID = jwk.getKeyID();
                if (StringUtils.equals(keyID, expectedKeyId = (thumbprint = jwk.computeThumbprint()).toString().toLowerCase())) continue;
                char[] keypass = PasswordCallbackUtils.getPassword(callbackHandler, keyID);
                Key key = ks.getKey(keyID, keypass);
                Certificate certificate = ks.getCertificate(keyID);
                Certificate[] chain = new Certificate[]{certificate};
                ks.setKeyEntry(expectedKeyId, key, keypass, chain);
                ks.deleteEntry(keyID);
                change = true;
            }
            return change;
        }
        catch (JOSEException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalStateException(e);
        }
    }
}

