/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import com.nimbusds.jose.util.Base64;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class X509CertUtils {
    private static final String PEM_BEGIN_MARKER = "-----BEGIN CERTIFICATE-----";
    private static final String PEM_END_MARKER = "-----END CERTIFICATE-----";

    public static X509Certificate parse(byte[] derEncodedCert) {
        Certificate cert;
        if (derEncodedCert == null || derEncodedCert.length == 0) {
            return null;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = cf.generateCertificate(new ByteArrayInputStream(derEncodedCert));
        }
        catch (CertificateException certificateException) {
            return null;
        }
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        return (X509Certificate)cert;
    }

    public static X509Certificate parse(String pemEncodedCert) {
        if (pemEncodedCert == null || pemEncodedCert.isEmpty()) {
            return null;
        }
        int markerStart = pemEncodedCert.indexOf(PEM_BEGIN_MARKER);
        if (markerStart < 0) {
            return null;
        }
        String buf = pemEncodedCert.substring(markerStart + PEM_BEGIN_MARKER.length());
        int markerEnd = buf.indexOf(PEM_END_MARKER);
        if (markerEnd < 0) {
            return null;
        }
        buf = buf.substring(0, markerEnd);
        buf = buf.replaceAll("\\s", "");
        return X509CertUtils.parse(new Base64(buf).decode());
    }
}

