/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Two-step-procedure for a communication with a bank server, e.g. for doing a money transfer")
public class TwoStepProcedure {
    @SerializedName(value="procedureId")
    private String procedureId = null;
    @SerializedName(value="procedureName")
    private String procedureName = null;
    @SerializedName(value="procedureChallengeType")
    private String procedureChallengeType = null;
    @SerializedName(value="implicitExecute")
    private Boolean implicitExecute = false;

    public TwoStepProcedure procedureId(String procedureId) {
        this.procedureId = procedureId;
        return this;
    }

    @ApiModelProperty(required=true, value="Bank-given ID of the procedure")
    public String getProcedureId() {
        return this.procedureId;
    }

    public void setProcedureId(String procedureId) {
        this.procedureId = procedureId;
    }

    public TwoStepProcedure procedureName(String procedureName) {
        this.procedureName = procedureName;
        return this;
    }

    @ApiModelProperty(required=true, value="Bank-given name of the procedure")
    public String getProcedureName() {
        return this.procedureName;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    public TwoStepProcedure procedureChallengeType(String procedureChallengeType) {
        this.procedureChallengeType = procedureChallengeType;
        return this;
    }

    @ApiModelProperty(value="The challenge type of the procedure. Possible values are:<br/><br/>&bull; <code>TEXT</code> - the challenge will be a text that contains instructions for the user on how to retrieve the TAN.<br/>&bull; <code>PHOTO</code> - the challenge will contain a BASE-64 string depicting a photo (or any kind of QR-code-like data) that must be shown to the user.<br/>&bull; <code>FLICKER_CODE</code> - the challenge will contain a BASE-64 string depicting a flicker code animation that must be shown to the user.<br/><br/>Note that this challenge type information does not originate from the bank server, but is determined by finAPI internally. There is no guarantee that the determined challenge type is correct. Note also that this field may not be set, meaning that finAPI could not determine the challenge type of the procedure.<br/><br/>For further information on how to deal with the challenges, please see <a href='https://finapi.zendesk.com/hc/en-us/articles/219117247-SEPA-Money-Transfer'>this article</a> on our Dev Portal.")
    public String getProcedureChallengeType() {
        return this.procedureChallengeType;
    }

    public void setProcedureChallengeType(String procedureChallengeType) {
        this.procedureChallengeType = procedureChallengeType;
    }

    public TwoStepProcedure implicitExecute(Boolean implicitExecute) {
        this.implicitExecute = implicitExecute;
        return this;
    }

    @ApiModelProperty(required=true, value="If 'true', then requesting a SEPA order with this procedure will implicitly trigger the execution of the order. For example, if you do a money transfer with this procedure, then calling the /requestSepaMoneyTransfer service will immediately execute the order (a call to /executeSepaMoneyTransfer will not be necessary). On the other hand, if this flag is 'false', then doing a money transfer with this procedure will require you to first call /requestSepaMoneyTransfer, and then call /executeSepaMoneyTransfer.")
    public Boolean isImplicitExecute() {
        return this.implicitExecute;
    }

    public void setImplicitExecute(Boolean implicitExecute) {
        this.implicitExecute = implicitExecute;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwoStepProcedure twoStepProcedure = (TwoStepProcedure)o;
        return Objects.equals(this.procedureId, twoStepProcedure.procedureId) && Objects.equals(this.procedureName, twoStepProcedure.procedureName) && Objects.equals(this.procedureChallengeType, twoStepProcedure.procedureChallengeType) && Objects.equals(this.implicitExecute, twoStepProcedure.implicitExecute);
    }

    public int hashCode() {
        return Objects.hash(this.procedureId, this.procedureName, this.procedureChallengeType, this.implicitExecute);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TwoStepProcedure {\n");
        sb.append("    procedureId: ").append(this.toIndentedString(this.procedureId)).append("\n");
        sb.append("    procedureName: ").append(this.toIndentedString(this.procedureName)).append("\n");
        sb.append("    procedureChallengeType: ").append(this.toIndentedString(this.procedureChallengeType)).append("\n");
        sb.append("    implicitExecute: ").append(this.toIndentedString(this.implicitExecute)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

