/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Data of transaction for categorization")
public class TransactionDataWithIdentifier {
    @SerializedName(value="accountTypeId")
    private Long accountTypeId = null;
    @SerializedName(value="amount")
    private BigDecimal amount = null;
    @SerializedName(value="purpose")
    private String purpose = null;
    @SerializedName(value="counterpart")
    private String counterpart = null;
    @SerializedName(value="counterpartIban")
    private String counterpartIban = null;
    @SerializedName(value="counterpartAccountNumber")
    private String counterpartAccountNumber = null;
    @SerializedName(value="counterpartBlz")
    private String counterpartBlz = null;
    @SerializedName(value="counterpartBic")
    private String counterpartBic = null;
    @SerializedName(value="mcCode")
    private String mcCode = null;
    @SerializedName(value="transactionId")
    private String transactionId = null;

    public TransactionDataWithIdentifier accountTypeId(Long accountTypeId) {
        this.accountTypeId = accountTypeId;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier of account type.<br/><br/>1 = Checking,<br/>2 = Savings,<br/>3 = CreditCard,<br/>4 = Security,<br/>5 = Loan,<br/>6 = Pocket (DEPRECATED; will not be returned for any account unless this type has explicitly been set via PATCH),<br/>7 = Membership,<br/>8 = Bausparen<br/><br/>")
    public Long getAccountTypeId() {
        return this.accountTypeId;
    }

    public void setAccountTypeId(Long accountTypeId) {
        this.accountTypeId = accountTypeId;
    }

    public TransactionDataWithIdentifier amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="Amount")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public TransactionDataWithIdentifier purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(value="Purpose. Any symbols are allowed. Maximum length is 2000. Default value: null.")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public TransactionDataWithIdentifier counterpart(String counterpart) {
        this.counterpart = counterpart;
        return this;
    }

    @ApiModelProperty(value="Counterpart. Any symbols are allowed. Maximum length is 80. Default value: null.")
    public String getCounterpart() {
        return this.counterpart;
    }

    public void setCounterpart(String counterpart) {
        this.counterpart = counterpart;
    }

    public TransactionDataWithIdentifier counterpartIban(String counterpartIban) {
        this.counterpartIban = counterpartIban;
        return this;
    }

    @ApiModelProperty(value="Counterpart IBAN. Default value: null.")
    public String getCounterpartIban() {
        return this.counterpartIban;
    }

    public void setCounterpartIban(String counterpartIban) {
        this.counterpartIban = counterpartIban;
    }

    public TransactionDataWithIdentifier counterpartAccountNumber(String counterpartAccountNumber) {
        this.counterpartAccountNumber = counterpartAccountNumber;
        return this;
    }

    @ApiModelProperty(value="Counterpart account number. Default value: null.")
    public String getCounterpartAccountNumber() {
        return this.counterpartAccountNumber;
    }

    public void setCounterpartAccountNumber(String counterpartAccountNumber) {
        this.counterpartAccountNumber = counterpartAccountNumber;
    }

    public TransactionDataWithIdentifier counterpartBlz(String counterpartBlz) {
        this.counterpartBlz = counterpartBlz;
        return this;
    }

    @ApiModelProperty(value="Counterpart BLZ. Default value: null.")
    public String getCounterpartBlz() {
        return this.counterpartBlz;
    }

    public void setCounterpartBlz(String counterpartBlz) {
        this.counterpartBlz = counterpartBlz;
    }

    public TransactionDataWithIdentifier counterpartBic(String counterpartBic) {
        this.counterpartBic = counterpartBic;
        return this;
    }

    @ApiModelProperty(value="Counterpart BIC. Default value: null.")
    public String getCounterpartBic() {
        return this.counterpartBic;
    }

    public void setCounterpartBic(String counterpartBic) {
        this.counterpartBic = counterpartBic;
    }

    public TransactionDataWithIdentifier mcCode(String mcCode) {
        this.mcCode = mcCode;
        return this;
    }

    @ApiModelProperty(value="Merchant category code (for credit card transactions only). Default value: null. NOTE: This field is currently not regarded.")
    public String getMcCode() {
        return this.mcCode;
    }

    public void setMcCode(String mcCode) {
        this.mcCode = mcCode;
    }

    public TransactionDataWithIdentifier transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier of transaction. This can be any arbitrary string that will be passed back in the response so that you can map the results to the given transactions. Note that the identifier must be unique within the given list of transactions.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionDataWithIdentifier transactionDataWithIdentifier = (TransactionDataWithIdentifier)o;
        return Objects.equals(this.accountTypeId, transactionDataWithIdentifier.accountTypeId) && Objects.equals(this.amount, transactionDataWithIdentifier.amount) && Objects.equals(this.purpose, transactionDataWithIdentifier.purpose) && Objects.equals(this.counterpart, transactionDataWithIdentifier.counterpart) && Objects.equals(this.counterpartIban, transactionDataWithIdentifier.counterpartIban) && Objects.equals(this.counterpartAccountNumber, transactionDataWithIdentifier.counterpartAccountNumber) && Objects.equals(this.counterpartBlz, transactionDataWithIdentifier.counterpartBlz) && Objects.equals(this.counterpartBic, transactionDataWithIdentifier.counterpartBic) && Objects.equals(this.mcCode, transactionDataWithIdentifier.mcCode) && Objects.equals(this.transactionId, transactionDataWithIdentifier.transactionId);
    }

    public int hashCode() {
        return Objects.hash(this.accountTypeId, this.amount, this.purpose, this.counterpart, this.counterpartIban, this.counterpartAccountNumber, this.counterpartBlz, this.counterpartBic, this.mcCode, this.transactionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionDataWithIdentifier {\n");
        sb.append("    accountTypeId: ").append(this.toIndentedString(this.accountTypeId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    counterpart: ").append(this.toIndentedString(this.counterpart)).append("\n");
        sb.append("    counterpartIban: ").append(this.toIndentedString(this.counterpartIban)).append("\n");
        sb.append("    counterpartAccountNumber: ").append(this.toIndentedString(this.counterpartAccountNumber)).append("\n");
        sb.append("    counterpartBlz: ").append(this.toIndentedString(this.counterpartBlz)).append("\n");
        sb.append("    counterpartBic: ").append(this.toIndentedString(this.counterpartBic)).append("\n");
        sb.append("    mcCode: ").append(this.toIndentedString(this.mcCode)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

