/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Transaction data")
public class TransactionData {
    @SerializedName(value="accountTypeId")
    private Long accountTypeId = null;
    @SerializedName(value="amount")
    private BigDecimal amount = null;
    @SerializedName(value="purpose")
    private String purpose = null;
    @SerializedName(value="counterpart")
    private String counterpart = null;
    @SerializedName(value="counterpartIban")
    private String counterpartIban = null;
    @SerializedName(value="counterpartAccountNumber")
    private String counterpartAccountNumber = null;
    @SerializedName(value="counterpartBlz")
    private String counterpartBlz = null;
    @SerializedName(value="counterpartBic")
    private String counterpartBic = null;
    @SerializedName(value="mcCode")
    private String mcCode = null;

    public TransactionData accountTypeId(Long accountTypeId) {
        this.accountTypeId = accountTypeId;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier of account type.<br/><br/>1 = Checking,<br/>2 = Savings,<br/>3 = CreditCard,<br/>4 = Security,<br/>5 = Loan,<br/>6 = Pocket (DEPRECATED; will not be returned for any account unless this type has explicitly been set via PATCH),<br/>7 = Membership,<br/>8 = Bausparen<br/><br/>")
    public Long getAccountTypeId() {
        return this.accountTypeId;
    }

    public void setAccountTypeId(Long accountTypeId) {
        this.accountTypeId = accountTypeId;
    }

    public TransactionData amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="Amount")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public TransactionData purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(value="Purpose. Any symbols are allowed. Maximum length is 2000. Default value: null.")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public TransactionData counterpart(String counterpart) {
        this.counterpart = counterpart;
        return this;
    }

    @ApiModelProperty(value="Counterpart. Any symbols are allowed. Maximum length is 80. Default value: null.")
    public String getCounterpart() {
        return this.counterpart;
    }

    public void setCounterpart(String counterpart) {
        this.counterpart = counterpart;
    }

    public TransactionData counterpartIban(String counterpartIban) {
        this.counterpartIban = counterpartIban;
        return this;
    }

    @ApiModelProperty(value="Counterpart IBAN. Default value: null.")
    public String getCounterpartIban() {
        return this.counterpartIban;
    }

    public void setCounterpartIban(String counterpartIban) {
        this.counterpartIban = counterpartIban;
    }

    public TransactionData counterpartAccountNumber(String counterpartAccountNumber) {
        this.counterpartAccountNumber = counterpartAccountNumber;
        return this;
    }

    @ApiModelProperty(value="Counterpart account number. Default value: null.")
    public String getCounterpartAccountNumber() {
        return this.counterpartAccountNumber;
    }

    public void setCounterpartAccountNumber(String counterpartAccountNumber) {
        this.counterpartAccountNumber = counterpartAccountNumber;
    }

    public TransactionData counterpartBlz(String counterpartBlz) {
        this.counterpartBlz = counterpartBlz;
        return this;
    }

    @ApiModelProperty(value="Counterpart BLZ. Default value: null.")
    public String getCounterpartBlz() {
        return this.counterpartBlz;
    }

    public void setCounterpartBlz(String counterpartBlz) {
        this.counterpartBlz = counterpartBlz;
    }

    public TransactionData counterpartBic(String counterpartBic) {
        this.counterpartBic = counterpartBic;
        return this;
    }

    @ApiModelProperty(value="Counterpart BIC. Default value: null.")
    public String getCounterpartBic() {
        return this.counterpartBic;
    }

    public void setCounterpartBic(String counterpartBic) {
        this.counterpartBic = counterpartBic;
    }

    public TransactionData mcCode(String mcCode) {
        this.mcCode = mcCode;
        return this;
    }

    @ApiModelProperty(value="Merchant category code (for credit card transactions only). Default value: null. NOTE: This field is currently not regarded.")
    public String getMcCode() {
        return this.mcCode;
    }

    public void setMcCode(String mcCode) {
        this.mcCode = mcCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionData transactionData = (TransactionData)o;
        return Objects.equals(this.accountTypeId, transactionData.accountTypeId) && Objects.equals(this.amount, transactionData.amount) && Objects.equals(this.purpose, transactionData.purpose) && Objects.equals(this.counterpart, transactionData.counterpart) && Objects.equals(this.counterpartIban, transactionData.counterpartIban) && Objects.equals(this.counterpartAccountNumber, transactionData.counterpartAccountNumber) && Objects.equals(this.counterpartBlz, transactionData.counterpartBlz) && Objects.equals(this.counterpartBic, transactionData.counterpartBic) && Objects.equals(this.mcCode, transactionData.mcCode);
    }

    public int hashCode() {
        return Objects.hash(this.accountTypeId, this.amount, this.purpose, this.counterpart, this.counterpartIban, this.counterpartAccountNumber, this.counterpartBlz, this.counterpartBic, this.mcCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionData {\n");
        sb.append("    accountTypeId: ").append(this.toIndentedString(this.accountTypeId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    counterpart: ").append(this.toIndentedString(this.counterpart)).append("\n");
        sb.append("    counterpartIban: ").append(this.toIndentedString(this.counterpartIban)).append("\n");
        sb.append("    counterpartAccountNumber: ").append(this.toIndentedString(this.counterpartAccountNumber)).append("\n");
        sb.append("    counterpartBlz: ").append(this.toIndentedString(this.counterpartBlz)).append("\n");
        sb.append("    counterpartBic: ").append(this.toIndentedString(this.counterpartBic)).append("\n");
        sb.append("    mcCode: ").append(this.toIndentedString(this.mcCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

