/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Recipient data for a single money transfer order")
public class SingleMoneyTransferRecipientData {
    @SerializedName(value="recipientName")
    private String recipientName = null;
    @SerializedName(value="recipientIban")
    private String recipientIban = null;
    @SerializedName(value="recipientBic")
    private String recipientBic = null;
    @SerializedName(value="clearingAccountId")
    private String clearingAccountId = null;
    @SerializedName(value="amount")
    private BigDecimal amount = null;
    @SerializedName(value="purpose")
    private String purpose = null;

    public SingleMoneyTransferRecipientData recipientName(String recipientName) {
        this.recipientName = recipientName;
        return this;
    }

    @ApiModelProperty(value="Name of the recipient. Note: Neither finAPI nor the involved bank servers are guaranteed to validate the recipient name. Even if the recipient name does not depict the actual registered account holder of the specified recipient account, the money transfer request might still be successful. This field is optional only when you pass a clearing account as the recipient. Otherwise, this field is required.")
    public String getRecipientName() {
        return this.recipientName;
    }

    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
    }

    public SingleMoneyTransferRecipientData recipientIban(String recipientIban) {
        this.recipientIban = recipientIban;
        return this;
    }

    @ApiModelProperty(value="IBAN of the recipient's account. This field is optional only when you pass a clearing account as the recipient. Otherwise, this field is required.")
    public String getRecipientIban() {
        return this.recipientIban;
    }

    public void setRecipientIban(String recipientIban) {
        this.recipientIban = recipientIban;
    }

    public SingleMoneyTransferRecipientData recipientBic(String recipientBic) {
        this.recipientBic = recipientBic;
        return this;
    }

    @ApiModelProperty(value="BIC of the recipient's account. Note: This field is optional when you pass a clearing account as the recipient or if the bank connection of the account that you want to transfer money from supports the IBAN-Only money transfer. You can find this out via GET /bankConnections/<id>. Also note that when a BIC is given, then this BIC will be used for the money transfer request independent of whether it is required or not (unless you pass a clearing account, in which case this field will always be ignored).")
    public String getRecipientBic() {
        return this.recipientBic;
    }

    public void setRecipientBic(String recipientBic) {
        this.recipientBic = recipientBic;
    }

    public SingleMoneyTransferRecipientData clearingAccountId(String clearingAccountId) {
        this.clearingAccountId = clearingAccountId;
        return this;
    }

    @ApiModelProperty(value="Identifier of a clearing account. If this field is set, then the fields 'recipientName', 'recipientIban' and 'recipientBic' will be ignored and the recipient account will be the specified clearing account.")
    public String getClearingAccountId() {
        return this.clearingAccountId;
    }

    public void setClearingAccountId(String clearingAccountId) {
        this.clearingAccountId = clearingAccountId;
    }

    public SingleMoneyTransferRecipientData amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount to transfer. Must be a positive decimal number with at most two decimal places (e.g. 99.90)")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public SingleMoneyTransferRecipientData purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(value="The purpose of the transfer transaction")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleMoneyTransferRecipientData singleMoneyTransferRecipientData = (SingleMoneyTransferRecipientData)o;
        return Objects.equals(this.recipientName, singleMoneyTransferRecipientData.recipientName) && Objects.equals(this.recipientIban, singleMoneyTransferRecipientData.recipientIban) && Objects.equals(this.recipientBic, singleMoneyTransferRecipientData.recipientBic) && Objects.equals(this.clearingAccountId, singleMoneyTransferRecipientData.clearingAccountId) && Objects.equals(this.amount, singleMoneyTransferRecipientData.amount) && Objects.equals(this.purpose, singleMoneyTransferRecipientData.purpose);
    }

    public int hashCode() {
        return Objects.hash(this.recipientName, this.recipientIban, this.recipientBic, this.clearingAccountId, this.amount, this.purpose);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SingleMoneyTransferRecipientData {\n");
        sb.append("    recipientName: ").append(this.toIndentedString(this.recipientName)).append("\n");
        sb.append("    recipientIban: ").append(this.toIndentedString(this.recipientIban)).append("\n");
        sb.append("    recipientBic: ").append(this.toIndentedString(this.recipientBic)).append("\n");
        sb.append("    clearingAccountId: ").append(this.toIndentedString(this.clearingAccountId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

