/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Data for a single direct debit")
public class SingleDirectDebitData {
    @SerializedName(value="debitorName")
    private String debitorName = null;
    @SerializedName(value="debitorIban")
    private String debitorIban = null;
    @SerializedName(value="debitorBic")
    private String debitorBic = null;
    @SerializedName(value="amount")
    private BigDecimal amount = null;
    @SerializedName(value="purpose")
    private String purpose = null;
    @SerializedName(value="mandateId")
    private String mandateId = null;
    @SerializedName(value="mandateDate")
    private String mandateDate = null;
    @SerializedName(value="creditorId")
    private String creditorId = null;
    @SerializedName(value="endToEndId")
    private String endToEndId = null;

    public SingleDirectDebitData debitorName(String debitorName) {
        this.debitorName = debitorName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the debitor. Note: Neither finAPI nor the involved bank servers are guaranteed to validate the debitor name. Even if the debitor name does not depict the actual registered account holder of the specified debitor account, the direct debit request might still be successful.")
    public String getDebitorName() {
        return this.debitorName;
    }

    public void setDebitorName(String debitorName) {
        this.debitorName = debitorName;
    }

    public SingleDirectDebitData debitorIban(String debitorIban) {
        this.debitorIban = debitorIban;
        return this;
    }

    @ApiModelProperty(required=true, value="IBAN of the debitor's account")
    public String getDebitorIban() {
        return this.debitorIban;
    }

    public void setDebitorIban(String debitorIban) {
        this.debitorIban = debitorIban;
    }

    public SingleDirectDebitData debitorBic(String debitorBic) {
        this.debitorBic = debitorBic;
        return this;
    }

    @ApiModelProperty(value="BIC of the debitor's account. Note: This field is optional if - and only if - the bank connection of the account that you want to transfer money to supports the IBAN-Only direct debit. You can find this out via GET /bankConnections/<id>. Also note that when a BIC is given, then this BIC will be used for the direct debit request independent of whether it is required or not.")
    public String getDebitorBic() {
        return this.debitorBic;
    }

    public void setDebitorBic(String debitorBic) {
        this.debitorBic = debitorBic;
    }

    public SingleDirectDebitData amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount to transfer. Must be a positive decimal number with at most two decimal places (e.g. 99.90)")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public SingleDirectDebitData purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(value="The purpose of the transfer transaction")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public SingleDirectDebitData mandateId(String mandateId) {
        this.mandateId = mandateId;
        return this;
    }

    @ApiModelProperty(required=true, value="Mandate ID that this direct debit order is based on.")
    public String getMandateId() {
        return this.mandateId;
    }

    public void setMandateId(String mandateId) {
        this.mandateId = mandateId;
    }

    public SingleDirectDebitData mandateDate(String mandateDate) {
        this.mandateDate = mandateDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Date of the mandate that this direct debit order is based on, in the format 'yyyy-MM-dd'")
    public String getMandateDate() {
        return this.mandateDate;
    }

    public void setMandateDate(String mandateDate) {
        this.mandateDate = mandateDate;
    }

    public SingleDirectDebitData creditorId(String creditorId) {
        this.creditorId = creditorId;
        return this;
    }

    @ApiModelProperty(value="Creditor ID of the source account's holder")
    public String getCreditorId() {
        return this.creditorId;
    }

    public void setCreditorId(String creditorId) {
        this.creditorId = creditorId;
    }

    public SingleDirectDebitData endToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
        return this;
    }

    @ApiModelProperty(value="End-To-End ID for the transfer transaction")
    public String getEndToEndId() {
        return this.endToEndId;
    }

    public void setEndToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleDirectDebitData singleDirectDebitData = (SingleDirectDebitData)o;
        return Objects.equals(this.debitorName, singleDirectDebitData.debitorName) && Objects.equals(this.debitorIban, singleDirectDebitData.debitorIban) && Objects.equals(this.debitorBic, singleDirectDebitData.debitorBic) && Objects.equals(this.amount, singleDirectDebitData.amount) && Objects.equals(this.purpose, singleDirectDebitData.purpose) && Objects.equals(this.mandateId, singleDirectDebitData.mandateId) && Objects.equals(this.mandateDate, singleDirectDebitData.mandateDate) && Objects.equals(this.creditorId, singleDirectDebitData.creditorId) && Objects.equals(this.endToEndId, singleDirectDebitData.endToEndId);
    }

    public int hashCode() {
        return Objects.hash(this.debitorName, this.debitorIban, this.debitorBic, this.amount, this.purpose, this.mandateId, this.mandateDate, this.creditorId, this.endToEndId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SingleDirectDebitData {\n");
        sb.append("    debitorName: ").append(this.toIndentedString(this.debitorName)).append("\n");
        sb.append("    debitorIban: ").append(this.toIndentedString(this.debitorIban)).append("\n");
        sb.append("    debitorBic: ").append(this.toIndentedString(this.debitorBic)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    mandateId: ").append(this.toIndentedString(this.mandateId)).append("\n");
        sb.append("    mandateDate: ").append(this.toIndentedString(this.mandateDate)).append("\n");
        sb.append("    creditorId: ").append(this.toIndentedString(this.creditorId)).append("\n");
        sb.append("    endToEndId: ").append(this.toIndentedString(this.endToEndId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

