/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.SingleMoneyTransferRecipientData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Parameters for a single or collective SEPA money transfer order request")
public class RequestSepaMoneyTransferParams {
    @SerializedName(value="recipientName")
    private String recipientName = null;
    @SerializedName(value="recipientIban")
    private String recipientIban = null;
    @SerializedName(value="recipientBic")
    private String recipientBic = null;
    @SerializedName(value="clearingAccountId")
    private String clearingAccountId = null;
    @SerializedName(value="amount")
    private BigDecimal amount = null;
    @SerializedName(value="purpose")
    private String purpose = null;
    @SerializedName(value="accountId")
    private Long accountId = null;
    @SerializedName(value="bankingPin")
    private String bankingPin = null;
    @SerializedName(value="twoStepProcedureId")
    private String twoStepProcedureId = null;
    @SerializedName(value="challengeResponse")
    private String challengeResponse = null;
    @SerializedName(value="additionalMoneyTransfers")
    private List<SingleMoneyTransferRecipientData> additionalMoneyTransfers = null;

    public RequestSepaMoneyTransferParams recipientName(String recipientName) {
        this.recipientName = recipientName;
        return this;
    }

    @ApiModelProperty(value="Name of the recipient. Note: Neither finAPI nor the involved bank servers are guaranteed to validate the recipient name. Even if the recipient name does not depict the actual registered account holder of the specified recipient account, the money transfer request might still be successful. This field is optional only when you pass a clearing account as the recipient. Otherwise, this field is required.")
    public String getRecipientName() {
        return this.recipientName;
    }

    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
    }

    public RequestSepaMoneyTransferParams recipientIban(String recipientIban) {
        this.recipientIban = recipientIban;
        return this;
    }

    @ApiModelProperty(value="IBAN of the recipient's account. This field is optional only when you pass a clearing account as the recipient. Otherwise, this field is required.")
    public String getRecipientIban() {
        return this.recipientIban;
    }

    public void setRecipientIban(String recipientIban) {
        this.recipientIban = recipientIban;
    }

    public RequestSepaMoneyTransferParams recipientBic(String recipientBic) {
        this.recipientBic = recipientBic;
        return this;
    }

    @ApiModelProperty(value="BIC of the recipient's account. Note: This field is optional when you pass a clearing account as the recipient or if the bank connection of the account that you want to transfer money from supports the IBAN-Only money transfer. You can find this out via GET /bankConnections/<id>. Also note that when a BIC is given, then this BIC will be used for the money transfer request independent of whether it is required or not (unless you pass a clearing account, in which case this field will always be ignored).")
    public String getRecipientBic() {
        return this.recipientBic;
    }

    public void setRecipientBic(String recipientBic) {
        this.recipientBic = recipientBic;
    }

    public RequestSepaMoneyTransferParams clearingAccountId(String clearingAccountId) {
        this.clearingAccountId = clearingAccountId;
        return this;
    }

    @ApiModelProperty(value="Identifier of a clearing account. If this field is set, then the fields 'recipientName', 'recipientIban' and 'recipientBic' will be ignored and the recipient account will be the specified clearing account.")
    public String getClearingAccountId() {
        return this.clearingAccountId;
    }

    public void setClearingAccountId(String clearingAccountId) {
        this.clearingAccountId = clearingAccountId;
    }

    public RequestSepaMoneyTransferParams amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount to transfer. Must be a positive decimal number with at most two decimal places (e.g. 99.90)")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public RequestSepaMoneyTransferParams purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(value="The purpose of the transfer transaction")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public RequestSepaMoneyTransferParams accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier of the bank account that you want to transfer money from")
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public RequestSepaMoneyTransferParams bankingPin(String bankingPin) {
        this.bankingPin = bankingPin;
        return this;
    }

    @ApiModelProperty(value="Online banking PIN. If a PIN is stored in the account's bank connection, then this field may remain unset. If the field is set though then it will always be used (even if there is some other PIN stored in the bank connection).")
    public String getBankingPin() {
        return this.bankingPin;
    }

    public void setBankingPin(String bankingPin) {
        this.bankingPin = bankingPin;
    }

    public RequestSepaMoneyTransferParams twoStepProcedureId(String twoStepProcedureId) {
        this.twoStepProcedureId = twoStepProcedureId;
        return this;
    }

    @ApiModelProperty(value="The bank-given ID of the two-step-procedure that should be used for the money transfer. For a list of available two-step-procedures, see the corresponding bank connection (GET /bankConnections). If this field is not set, then the bank connection's default two-step procedure will be used. Note that in this case, when the bank connection has no default two-step procedure set, then the service will return an error (see response messages for details).")
    public String getTwoStepProcedureId() {
        return this.twoStepProcedureId;
    }

    public void setTwoStepProcedureId(String twoStepProcedureId) {
        this.twoStepProcedureId = twoStepProcedureId;
    }

    public RequestSepaMoneyTransferParams challengeResponse(String challengeResponse) {
        this.challengeResponse = challengeResponse;
        return this;
    }

    @ApiModelProperty(value="Challenge response. This field should be set only when the previous attempt to request a SEPA money transfer failed with HTTP code 510, i.e. the bank sent a challenge for the user for an additional authentication. In this case, this field must contain the response to the bank's challenge.")
    public String getChallengeResponse() {
        return this.challengeResponse;
    }

    public void setChallengeResponse(String challengeResponse) {
        this.challengeResponse = challengeResponse;
    }

    public RequestSepaMoneyTransferParams additionalMoneyTransfers(List<SingleMoneyTransferRecipientData> additionalMoneyTransfers) {
        this.additionalMoneyTransfers = additionalMoneyTransfers;
        return this;
    }

    public RequestSepaMoneyTransferParams addAdditionalMoneyTransfersItem(SingleMoneyTransferRecipientData additionalMoneyTransfersItem) {
        if (this.additionalMoneyTransfers == null) {
            this.additionalMoneyTransfers = new ArrayList<SingleMoneyTransferRecipientData>();
        }
        this.additionalMoneyTransfers.add(additionalMoneyTransfersItem);
        return this;
    }

    @ApiModelProperty(value="In case that you want to submit not just a single money transfer, but do a collective money transfer, use this field to pass a list of additional money transfer orders. The service will then pass a collective money transfer request to the bank, including both the money transfer specified on the top-level, as well as all money transfers specified in this list. Note that you should check the account's 'supportedOrders' field to find out whether or not it is supporting collective money transfers.")
    public List<SingleMoneyTransferRecipientData> getAdditionalMoneyTransfers() {
        return this.additionalMoneyTransfers;
    }

    public void setAdditionalMoneyTransfers(List<SingleMoneyTransferRecipientData> additionalMoneyTransfers) {
        this.additionalMoneyTransfers = additionalMoneyTransfers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestSepaMoneyTransferParams requestSepaMoneyTransferParams = (RequestSepaMoneyTransferParams)o;
        return Objects.equals(this.recipientName, requestSepaMoneyTransferParams.recipientName) && Objects.equals(this.recipientIban, requestSepaMoneyTransferParams.recipientIban) && Objects.equals(this.recipientBic, requestSepaMoneyTransferParams.recipientBic) && Objects.equals(this.clearingAccountId, requestSepaMoneyTransferParams.clearingAccountId) && Objects.equals(this.amount, requestSepaMoneyTransferParams.amount) && Objects.equals(this.purpose, requestSepaMoneyTransferParams.purpose) && Objects.equals(this.accountId, requestSepaMoneyTransferParams.accountId) && Objects.equals(this.bankingPin, requestSepaMoneyTransferParams.bankingPin) && Objects.equals(this.twoStepProcedureId, requestSepaMoneyTransferParams.twoStepProcedureId) && Objects.equals(this.challengeResponse, requestSepaMoneyTransferParams.challengeResponse) && Objects.equals(this.additionalMoneyTransfers, requestSepaMoneyTransferParams.additionalMoneyTransfers);
    }

    public int hashCode() {
        return Objects.hash(this.recipientName, this.recipientIban, this.recipientBic, this.clearingAccountId, this.amount, this.purpose, this.accountId, this.bankingPin, this.twoStepProcedureId, this.challengeResponse, this.additionalMoneyTransfers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestSepaMoneyTransferParams {\n");
        sb.append("    recipientName: ").append(this.toIndentedString(this.recipientName)).append("\n");
        sb.append("    recipientIban: ").append(this.toIndentedString(this.recipientIban)).append("\n");
        sb.append("    recipientBic: ").append(this.toIndentedString(this.recipientBic)).append("\n");
        sb.append("    clearingAccountId: ").append(this.toIndentedString(this.clearingAccountId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    bankingPin: ").append(this.toIndentedString(this.bankingPin)).append("\n");
        sb.append("    twoStepProcedureId: ").append(this.toIndentedString(this.twoStepProcedureId)).append("\n");
        sb.append("    challengeResponse: ").append(this.toIndentedString(this.challengeResponse)).append("\n");
        sb.append("    additionalMoneyTransfers: ").append(this.toIndentedString(this.additionalMoneyTransfers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

