/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.SingleDirectDebitData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Parameters for a single or collective SEPA direct debit order request")
public class RequestSepaDirectDebitParams {
    @SerializedName(value="accountId")
    private Long accountId = null;
    @SerializedName(value="bankingPin")
    private String bankingPin = null;
    @SerializedName(value="twoStepProcedureId")
    private String twoStepProcedureId = null;
    @SerializedName(value="directDebitType")
    private DirectDebitTypeEnum directDebitType = null;
    @SerializedName(value="sequenceType")
    private SequenceTypeEnum sequenceType = null;
    @SerializedName(value="executionDate")
    private String executionDate = null;
    @SerializedName(value="directDebits")
    private List<SingleDirectDebitData> directDebits = new ArrayList<SingleDirectDebitData>();

    public RequestSepaDirectDebitParams accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier of the bank account to which you want to transfer the money.")
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public RequestSepaDirectDebitParams bankingPin(String bankingPin) {
        this.bankingPin = bankingPin;
        return this;
    }

    @ApiModelProperty(value="Online banking PIN. If a PIN is stored in the account's bank connection, then this field may remain unset. If the field is set though then it will always be used (even if there is some other PIN stored in the bank connection).")
    public String getBankingPin() {
        return this.bankingPin;
    }

    public void setBankingPin(String bankingPin) {
        this.bankingPin = bankingPin;
    }

    public RequestSepaDirectDebitParams twoStepProcedureId(String twoStepProcedureId) {
        this.twoStepProcedureId = twoStepProcedureId;
        return this;
    }

    @ApiModelProperty(value="The bank-given ID of the two-step-procedure that should be used for the direct debit order. For a list of available two-step-procedures, see the corresponding bank connection (GET /bankConnections). If this field is not set, then the bank connection's default two-step procedure will be used. Note that in this case, when the bank connection has no default two-step procedure set, then the service will return an error (see response messages for details).")
    public String getTwoStepProcedureId() {
        return this.twoStepProcedureId;
    }

    public void setTwoStepProcedureId(String twoStepProcedureId) {
        this.twoStepProcedureId = twoStepProcedureId;
    }

    public RequestSepaDirectDebitParams directDebitType(DirectDebitTypeEnum directDebitType) {
        this.directDebitType = directDebitType;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of the direct debit; either <code>BASIC</code> or <code>B2B</code> (Business-To-Business). Please note that an account which supports the basic type must not necessarily support B2B (or vice versa). Check the source account's 'supportedOrders' field to find out which types of direct debit it supports.<br/><br/>")
    public DirectDebitTypeEnum getDirectDebitType() {
        return this.directDebitType;
    }

    public void setDirectDebitType(DirectDebitTypeEnum directDebitType) {
        this.directDebitType = directDebitType;
    }

    public RequestSepaDirectDebitParams sequenceType(SequenceTypeEnum sequenceType) {
        this.sequenceType = sequenceType;
        return this;
    }

    @ApiModelProperty(required=true, value="Sequence type of the direct debit. Possible values:<br/><br/>&bull; <code>OOFF</code> - means that this is a one-time direct debit order<br/>&bull; <code>FRST</code> - means that this is the first in a row of multiple direct debit orders<br/>&bull; <code>RCUR</code> - means that this is one (but not the first or final) within a row of multiple direct debit orders<br/>&bull; <code>FNAL</code> - means that this is the final in a row of multiple direct debit orders<br/><br/>")
    public SequenceTypeEnum getSequenceType() {
        return this.sequenceType;
    }

    public void setSequenceType(SequenceTypeEnum sequenceType) {
        this.sequenceType = sequenceType;
    }

    public RequestSepaDirectDebitParams executionDate(String executionDate) {
        this.executionDate = executionDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Execution date for the direct debit(s), in the format 'yyyy-MM-dd'.")
    public String getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(String executionDate) {
        this.executionDate = executionDate;
    }

    public RequestSepaDirectDebitParams directDebits(List<SingleDirectDebitData> directDebits) {
        this.directDebits = directDebits;
        return this;
    }

    public RequestSepaDirectDebitParams addDirectDebitsItem(SingleDirectDebitData directDebitsItem) {
        this.directDebits.add(directDebitsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of the direct debits that you want to execute. Please check the account's 'supportedOrders' field to find out whether you can pass multiple direct debits or just one.")
    public List<SingleDirectDebitData> getDirectDebits() {
        return this.directDebits;
    }

    public void setDirectDebits(List<SingleDirectDebitData> directDebits) {
        this.directDebits = directDebits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestSepaDirectDebitParams requestSepaDirectDebitParams = (RequestSepaDirectDebitParams)o;
        return Objects.equals(this.accountId, requestSepaDirectDebitParams.accountId) && Objects.equals(this.bankingPin, requestSepaDirectDebitParams.bankingPin) && Objects.equals(this.twoStepProcedureId, requestSepaDirectDebitParams.twoStepProcedureId) && Objects.equals((Object)this.directDebitType, (Object)requestSepaDirectDebitParams.directDebitType) && Objects.equals((Object)this.sequenceType, (Object)requestSepaDirectDebitParams.sequenceType) && Objects.equals(this.executionDate, requestSepaDirectDebitParams.executionDate) && Objects.equals(this.directDebits, requestSepaDirectDebitParams.directDebits);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.bankingPin, this.twoStepProcedureId, this.directDebitType, this.sequenceType, this.executionDate, this.directDebits});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestSepaDirectDebitParams {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    bankingPin: ").append(this.toIndentedString(this.bankingPin)).append("\n");
        sb.append("    twoStepProcedureId: ").append(this.toIndentedString(this.twoStepProcedureId)).append("\n");
        sb.append("    directDebitType: ").append(this.toIndentedString((Object)this.directDebitType)).append("\n");
        sb.append("    sequenceType: ").append(this.toIndentedString((Object)this.sequenceType)).append("\n");
        sb.append("    executionDate: ").append(this.toIndentedString(this.executionDate)).append("\n");
        sb.append("    directDebits: ").append(this.toIndentedString(this.directDebits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SequenceTypeEnum {
        OOFF("OOFF"),
        FRST("FRST"),
        RCUR("RCUR"),
        FNAL("FNAL");

        private String value;

        private SequenceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SequenceTypeEnum fromValue(String text) {
            for (SequenceTypeEnum b : SequenceTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SequenceTypeEnum> {
            public void write(JsonWriter jsonWriter, SequenceTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SequenceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SequenceTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectDebitTypeEnum {
        B2B("B2B"),
        BASIC("BASIC");

        private String value;

        private DirectDebitTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectDebitTypeEnum fromValue(String text) {
            for (DirectDebitTypeEnum b : DirectDebitTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DirectDebitTypeEnum> {
            public void write(JsonWriter jsonWriter, DirectDebitTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DirectDebitTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectDebitTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

