/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.Paging;
import io.swagger.client.model.UserInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container for users information with paging info")
public class PageableUserInfoList {
    @SerializedName(value="users")
    private List<UserInfo> users = new ArrayList<UserInfo>();
    @SerializedName(value="paging")
    private Paging paging = null;

    public PageableUserInfoList users(List<UserInfo> users) {
        this.users = users;
        return this;
    }

    public PageableUserInfoList addUsersItem(UserInfo usersItem) {
        this.users.add(usersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of users information")
    public List<UserInfo> getUsers() {
        return this.users;
    }

    public void setUsers(List<UserInfo> users) {
        this.users = users;
    }

    public PageableUserInfoList paging(Paging paging) {
        this.paging = paging;
        return this;
    }

    @ApiModelProperty(required=true, value="Information for pagination")
    public Paging getPaging() {
        return this.paging;
    }

    public void setPaging(Paging paging) {
        this.paging = paging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageableUserInfoList pageableUserInfoList = (PageableUserInfoList)o;
        return Objects.equals(this.users, pageableUserInfoList.users) && Objects.equals(this.paging, pageableUserInfoList.paging);
    }

    public int hashCode() {
        return Objects.hash(this.users, this.paging);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageableUserInfoList {\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    paging: ").append(this.toIndentedString(this.paging)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

