/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.Category;
import io.swagger.client.model.Paging;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container for categories with paging info")
public class PageableCategoryList {
    @SerializedName(value="categories")
    private List<Category> categories = new ArrayList<Category>();
    @SerializedName(value="paging")
    private Paging paging = null;

    public PageableCategoryList categories(List<Category> categories) {
        this.categories = categories;
        return this;
    }

    public PageableCategoryList addCategoriesItem(Category categoriesItem) {
        this.categories.add(categoriesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Categories")
    public List<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public PageableCategoryList paging(Paging paging) {
        this.paging = paging;
        return this;
    }

    @ApiModelProperty(required=true, value="Information for pagination")
    public Paging getPaging() {
        return this.paging;
    }

    public void setPaging(Paging paging) {
        this.paging = paging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageableCategoryList pageableCategoryList = (PageableCategoryList)o;
        return Objects.equals(this.categories, pageableCategoryList.categories) && Objects.equals(this.paging, pageableCategoryList.paging);
    }

    public int hashCode() {
        return Objects.hash(this.categories, this.paging);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageableCategoryList {\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    paging: ").append(this.toIndentedString(this.paging)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

