/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Data of notification rule")
public class NotificationRule {
    @SerializedName(value="id")
    private Long id = null;
    @SerializedName(value="triggerEvent")
    private TriggerEventEnum triggerEvent = null;
    @SerializedName(value="params")
    private Map<String, String> params = null;
    @SerializedName(value="callbackHandle")
    private String callbackHandle = null;
    @SerializedName(value="includeDetails")
    private Boolean includeDetails = false;

    public NotificationRule id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Notification rule identifier")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public NotificationRule triggerEvent(TriggerEventEnum triggerEvent) {
        this.triggerEvent = triggerEvent;
        return this;
    }

    @ApiModelProperty(required=true, value="Trigger event type")
    public TriggerEventEnum getTriggerEvent() {
        return this.triggerEvent;
    }

    public void setTriggerEvent(TriggerEventEnum triggerEvent) {
        this.triggerEvent = triggerEvent;
    }

    public NotificationRule params(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public NotificationRule putParamsItem(String key, String paramsItem) {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        this.params.put(key, paramsItem);
        return this;
    }

    @ApiModelProperty(value="Additional parameters that are specific to the trigger event type. Please refer to the documentation for details.")
    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public NotificationRule callbackHandle(String callbackHandle) {
        this.callbackHandle = callbackHandle;
        return this;
    }

    @ApiModelProperty(value="The string that finAPI includes into the notifications that it sends based on this rule.")
    public String getCallbackHandle() {
        return this.callbackHandle;
    }

    public void setCallbackHandle(String callbackHandle) {
        this.callbackHandle = callbackHandle;
    }

    public NotificationRule includeDetails(Boolean includeDetails) {
        this.includeDetails = includeDetails;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the notification messages that will be sent based on this rule contain encrypted detailed data or not")
    public Boolean isIncludeDetails() {
        return this.includeDetails;
    }

    public void setIncludeDetails(Boolean includeDetails) {
        this.includeDetails = includeDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationRule notificationRule = (NotificationRule)o;
        return Objects.equals(this.id, notificationRule.id) && Objects.equals((Object)this.triggerEvent, (Object)notificationRule.triggerEvent) && Objects.equals(this.params, notificationRule.params) && Objects.equals(this.callbackHandle, notificationRule.callbackHandle) && Objects.equals(this.includeDetails, notificationRule.includeDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.triggerEvent, this.params, this.callbackHandle, this.includeDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationRule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    triggerEvent: ").append(this.toIndentedString((Object)this.triggerEvent)).append("\n");
        sb.append("    params: ").append(this.toIndentedString(this.params)).append("\n");
        sb.append("    callbackHandle: ").append(this.toIndentedString(this.callbackHandle)).append("\n");
        sb.append("    includeDetails: ").append(this.toIndentedString(this.includeDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TriggerEventEnum {
        NEW_ACCOUNT_BALANCE("NEW_ACCOUNT_BALANCE"),
        NEW_TRANSACTIONS("NEW_TRANSACTIONS"),
        BANK_LOGIN_ERROR("BANK_LOGIN_ERROR"),
        FOREIGN_MONEY_TRANSFER("FOREIGN_MONEY_TRANSFER"),
        LOW_ACCOUNT_BALANCE("LOW_ACCOUNT_BALANCE"),
        HIGH_TRANSACTION_AMOUNT("HIGH_TRANSACTION_AMOUNT"),
        CATEGORY_CASH_FLOW("CATEGORY_CASH_FLOW");

        private String value;

        private TriggerEventEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TriggerEventEnum fromValue(String text) {
            for (TriggerEventEnum b : TriggerEventEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TriggerEventEnum> {
            public void write(JsonWriter jsonWriter, TriggerEventEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TriggerEventEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TriggerEventEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

