/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Mock transaction data")
public class NewTransaction {
    @SerializedName(value="amount")
    private BigDecimal amount = null;
    @SerializedName(value="purpose")
    private String purpose = null;
    @SerializedName(value="counterpart")
    private String counterpart = null;
    @SerializedName(value="counterpartIban")
    private String counterpartIban = null;
    @SerializedName(value="counterpartBlz")
    private String counterpartBlz = null;
    @SerializedName(value="counterpartBic")
    private String counterpartBic = null;
    @SerializedName(value="bookingDate")
    private String bookingDate = null;
    @SerializedName(value="valueDate")
    private String valueDate = null;

    public NewTransaction amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="Amount. Required.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public NewTransaction purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(value="Purpose. Any symbols are allowed. Maximum length is 2000. Optional. Default value: null.")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public NewTransaction counterpart(String counterpart) {
        this.counterpart = counterpart;
        return this;
    }

    @ApiModelProperty(value="Counterpart. Any symbols are allowed. Maximum length is 80. Optional. Default value: null.")
    public String getCounterpart() {
        return this.counterpart;
    }

    public void setCounterpart(String counterpart) {
        this.counterpart = counterpart;
    }

    public NewTransaction counterpartIban(String counterpartIban) {
        this.counterpartIban = counterpartIban;
        return this;
    }

    @ApiModelProperty(value="Counterpart IBAN. Optional. Default value: null.")
    public String getCounterpartIban() {
        return this.counterpartIban;
    }

    public void setCounterpartIban(String counterpartIban) {
        this.counterpartIban = counterpartIban;
    }

    public NewTransaction counterpartBlz(String counterpartBlz) {
        this.counterpartBlz = counterpartBlz;
        return this;
    }

    @ApiModelProperty(value="Counterpart BLZ. Optional. Default value: null.")
    public String getCounterpartBlz() {
        return this.counterpartBlz;
    }

    public void setCounterpartBlz(String counterpartBlz) {
        this.counterpartBlz = counterpartBlz;
    }

    public NewTransaction counterpartBic(String counterpartBic) {
        this.counterpartBic = counterpartBic;
        return this;
    }

    @ApiModelProperty(value="Counterpart BIC. Optional. Default value: null.")
    public String getCounterpartBic() {
        return this.counterpartBic;
    }

    public void setCounterpartBic(String counterpartBic) {
        this.counterpartBic = counterpartBic;
    }

    public NewTransaction bookingDate(String bookingDate) {
        this.bookingDate = bookingDate;
        return this;
    }

    @ApiModelProperty(value="Booking date in the format 'yyyy-MM-dd'.<br/><br/>If the date lies back more than 10 days from the booking date of the latest transaction that currently exists in the account, then this transaction will be ignored and not imported. If the date depicts a date in the future, then finAPI will deal with it the same way as it does with real transactions during a real update (see fields 'bankBookingDate' and 'finapiBookingDate' in the Transaction Resource for explanation).<br/><br/>This field is optional, default value is the current date.")
    public String getBookingDate() {
        return this.bookingDate;
    }

    public void setBookingDate(String bookingDate) {
        this.bookingDate = bookingDate;
    }

    public NewTransaction valueDate(String valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    @ApiModelProperty(value="Value date in the format 'yyyy-MM-dd'. Optional. Default value: Same as the booking date.")
    public String getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(String valueDate) {
        this.valueDate = valueDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewTransaction newTransaction = (NewTransaction)o;
        return Objects.equals(this.amount, newTransaction.amount) && Objects.equals(this.purpose, newTransaction.purpose) && Objects.equals(this.counterpart, newTransaction.counterpart) && Objects.equals(this.counterpartIban, newTransaction.counterpartIban) && Objects.equals(this.counterpartBlz, newTransaction.counterpartBlz) && Objects.equals(this.counterpartBic, newTransaction.counterpartBic) && Objects.equals(this.bookingDate, newTransaction.bookingDate) && Objects.equals(this.valueDate, newTransaction.valueDate);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.purpose, this.counterpart, this.counterpartIban, this.counterpartBlz, this.counterpartBic, this.bookingDate, this.valueDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NewTransaction {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    counterpart: ").append(this.toIndentedString(this.counterpart)).append("\n");
        sb.append("    counterpartIban: ").append(this.toIndentedString(this.counterpartIban)).append("\n");
        sb.append("    counterpartBlz: ").append(this.toIndentedString(this.counterpartBlz)).append("\n");
        sb.append("    counterpartBic: ").append(this.toIndentedString(this.counterpartBic)).append("\n");
        sb.append("    bookingDate: ").append(this.toIndentedString(this.bookingDate)).append("\n");
        sb.append("    valueDate: ").append(this.toIndentedString(this.valueDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

