/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.MockAccountData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Data for a mock bank connection update")
public class MockBankConnectionUpdate {
    @SerializedName(value="bankConnectionId")
    private Long bankConnectionId = null;
    @SerializedName(value="simulateBankLoginError")
    private Boolean simulateBankLoginError = false;
    @SerializedName(value="mockAccountsData")
    private List<MockAccountData> mockAccountsData = null;

    public MockBankConnectionUpdate bankConnectionId(Long bankConnectionId) {
        this.bankConnectionId = bankConnectionId;
        return this;
    }

    @ApiModelProperty(required=true, value="Bank connection identifier")
    public Long getBankConnectionId() {
        return this.bankConnectionId;
    }

    public void setBankConnectionId(Long bankConnectionId) {
        this.bankConnectionId = bankConnectionId;
    }

    public MockBankConnectionUpdate simulateBankLoginError(Boolean simulateBankLoginError) {
        this.simulateBankLoginError = simulateBankLoginError;
        return this;
    }

    @ApiModelProperty(value="Whether to simulate the case that the update fails due to incorrect banking credentials. Note that there is no real communication to any bank server involved, so you won't lock your accounts when enabling this flag. Default value is 'false'.")
    public Boolean isSimulateBankLoginError() {
        return this.simulateBankLoginError;
    }

    public void setSimulateBankLoginError(Boolean simulateBankLoginError) {
        this.simulateBankLoginError = simulateBankLoginError;
    }

    public MockBankConnectionUpdate mockAccountsData(List<MockAccountData> mockAccountsData) {
        this.mockAccountsData = mockAccountsData;
        return this;
    }

    public MockBankConnectionUpdate addMockAccountsDataItem(MockAccountData mockAccountsDataItem) {
        if (this.mockAccountsData == null) {
            this.mockAccountsData = new ArrayList<MockAccountData>();
        }
        this.mockAccountsData.add(mockAccountsDataItem);
        return this;
    }

    @ApiModelProperty(value="Mock accounts data. Note that for accounts that exist in a bank connection but that you do not specify in this list, the service will act like those accounts are not received by the bank servers. This means that any accounts that you do not specify here will be marked as deprecated. If you do not specify this list at all, all accounts in the bank connection will be marked as deprecated.")
    public List<MockAccountData> getMockAccountsData() {
        return this.mockAccountsData;
    }

    public void setMockAccountsData(List<MockAccountData> mockAccountsData) {
        this.mockAccountsData = mockAccountsData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockBankConnectionUpdate mockBankConnectionUpdate = (MockBankConnectionUpdate)o;
        return Objects.equals(this.bankConnectionId, mockBankConnectionUpdate.bankConnectionId) && Objects.equals(this.simulateBankLoginError, mockBankConnectionUpdate.simulateBankLoginError) && Objects.equals(this.mockAccountsData, mockBankConnectionUpdate.mockAccountsData);
    }

    public int hashCode() {
        return Objects.hash(this.bankConnectionId, this.simulateBankLoginError, this.mockAccountsData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MockBankConnectionUpdate {\n");
        sb.append("    bankConnectionId: ").append(this.toIndentedString(this.bankConnectionId)).append("\n");
        sb.append("    simulateBankLoginError: ").append(this.toIndentedString(this.simulateBankLoginError)).append("\n");
        sb.append("    mockAccountsData: ").append(this.toIndentedString(this.mockAccountsData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

