/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Container for parameters for the execution of a submitted SEPA money transfer order")
public class ExecuteSepaMoneyTransferParams {
    @SerializedName(value="accountId")
    private Long accountId = null;
    @SerializedName(value="bankingTan")
    private String bankingTan = null;

    public ExecuteSepaMoneyTransferParams accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier of the bank account that you want to transfer money from")
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public ExecuteSepaMoneyTransferParams bankingTan(String bankingTan) {
        this.bankingTan = bankingTan;
        return this;
    }

    @ApiModelProperty(required=true, value="Banking TAN that the user received from the bank for executing the money transfer order")
    public String getBankingTan() {
        return this.bankingTan;
    }

    public void setBankingTan(String bankingTan) {
        this.bankingTan = bankingTan;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecuteSepaMoneyTransferParams executeSepaMoneyTransferParams = (ExecuteSepaMoneyTransferParams)o;
        return Objects.equals(this.accountId, executeSepaMoneyTransferParams.accountId) && Objects.equals(this.bankingTan, executeSepaMoneyTransferParams.bankingTan);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.bankingTan);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExecuteSepaMoneyTransferParams {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    bankingTan: ").append(this.toIndentedString(this.bankingTan)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

