/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.DailyBalance;
import io.swagger.client.model.Paging;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains a list of daily balances")
public class DailyBalanceList {
    @SerializedName(value="latestCommonBalanceTimestamp")
    private String latestCommonBalanceTimestamp = null;
    @SerializedName(value="dailyBalances")
    private List<DailyBalance> dailyBalances = new ArrayList<DailyBalance>();
    @SerializedName(value="paging")
    private Paging paging = null;

    public DailyBalanceList latestCommonBalanceTimestamp(String latestCommonBalanceTimestamp) {
        this.latestCommonBalanceTimestamp = latestCommonBalanceTimestamp;
        return this;
    }

    @ApiModelProperty(value="The latestCommonBalanceTimestamp is the latest timestamp at which all given accounts have been up to date. Only balances with their date being smaller than the latestCommonBalanceTimestamp are reliable. Example: A user has two accounts: A (last update today, so balance from today) and B (last update yesterday, so balance from yesterday). The service /accounts/dailyBalances will return a balance for yesterday and for today, with the info latestCommonBalanceTimestamp=yesterday. Since account B might have received transactions this morning, today's balance might be wrong. So either make sure that all selected accounts are up to date before calling this service, or use the results carefully in combination with the latestCommonBalanceTimestamp. The format is 'yyyy-MM-dd HH:mm:ss.SSS' (german time).")
    public String getLatestCommonBalanceTimestamp() {
        return this.latestCommonBalanceTimestamp;
    }

    public void setLatestCommonBalanceTimestamp(String latestCommonBalanceTimestamp) {
        this.latestCommonBalanceTimestamp = latestCommonBalanceTimestamp;
    }

    public DailyBalanceList dailyBalances(List<DailyBalance> dailyBalances) {
        this.dailyBalances = dailyBalances;
        return this;
    }

    public DailyBalanceList addDailyBalancesItem(DailyBalance dailyBalancesItem) {
        this.dailyBalances.add(dailyBalancesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of daily balances for specified accounts and dates range")
    public List<DailyBalance> getDailyBalances() {
        return this.dailyBalances;
    }

    public void setDailyBalances(List<DailyBalance> dailyBalances) {
        this.dailyBalances = dailyBalances;
    }

    public DailyBalanceList paging(Paging paging) {
        this.paging = paging;
        return this;
    }

    @ApiModelProperty(required=true, value="Information for pagination")
    public Paging getPaging() {
        return this.paging;
    }

    public void setPaging(Paging paging) {
        this.paging = paging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DailyBalanceList dailyBalanceList = (DailyBalanceList)o;
        return Objects.equals(this.latestCommonBalanceTimestamp, dailyBalanceList.latestCommonBalanceTimestamp) && Objects.equals(this.dailyBalances, dailyBalanceList.dailyBalances) && Objects.equals(this.paging, dailyBalanceList.paging);
    }

    public int hashCode() {
        return Objects.hash(this.latestCommonBalanceTimestamp, this.dailyBalances, this.paging);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DailyBalanceList {\n");
        sb.append("    latestCommonBalanceTimestamp: ").append(this.toIndentedString(this.latestCommonBalanceTimestamp)).append("\n");
        sb.append("    dailyBalances: ").append(this.toIndentedString(this.dailyBalances)).append("\n");
        sb.append("    paging: ").append(this.toIndentedString(this.paging)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

