/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Category parameters")
public class CategoryParams {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="parentId")
    private Long parentId = null;

    public CategoryParams name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the category. Maximum length is 128.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CategoryParams parentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    @ApiModelProperty(value="Identifier of the parent category, if the new category should be created as a sub-category. Must point to a main category in this case. If the new category should be a main category itself, this field must remain unset.")
    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryParams categoryParams = (CategoryParams)o;
        return Objects.equals(this.name, categoryParams.name) && Objects.equals(this.parentId, categoryParams.parentId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CategoryParams {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

