/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Category data")
public class Category {
    @SerializedName(value="id")
    private Long id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="parentId")
    private Long parentId = null;
    @SerializedName(value="parentName")
    private String parentName = null;
    @SerializedName(value="isCustom")
    private Boolean isCustom = false;
    @SerializedName(value="children")
    private List<Long> children = null;

    public Category id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Category identifier.<br/><br/>NOTE: Do NOT assume that the identifiers of the global finAPI categories are the same across different finAPI environments. In fact, the identifiers may change whenever a new finAPI version is released, even within the same environment. The identifiers are meant to be used for references within the finAPI services only, but not for hard-coding them in your application. If you need to hard-code the usage of a certain global category within your application, please instead refer to the category name. Also, please make sure to check the 'isCustom' flag, which is false for all global categories (if you are not regarding this flag, you might end up referring to a user-specific category, and not the global category).")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Category name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Category name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Category parentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    @ApiModelProperty(value="Identifier of the parent category (if a parent category exists)")
    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Category parentName(String parentName) {
        this.parentName = parentName;
        return this;
    }

    @ApiModelProperty(value="Name of the parent category (if a parent category exists)")
    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public Category isCustom(Boolean isCustom) {
        this.isCustom = isCustom;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the category is a finAPI global category (in which case this field will be false), or the category was created by a user (in which case this field will be true)")
    public Boolean isIsCustom() {
        return this.isCustom;
    }

    public void setIsCustom(Boolean isCustom) {
        this.isCustom = isCustom;
    }

    public Category children(List<Long> children) {
        this.children = children;
        return this;
    }

    public Category addChildrenItem(Long childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<Long>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @ApiModelProperty(value="List of sub-categories identifiers (if any exist)")
    public List<Long> getChildren() {
        return this.children;
    }

    public void setChildren(List<Long> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Category category = (Category)o;
        return Objects.equals(this.id, category.id) && Objects.equals(this.name, category.name) && Objects.equals(this.parentId, category.parentId) && Objects.equals(this.parentName, category.parentName) && Objects.equals(this.isCustom, category.isCustom) && Objects.equals(this.children, category.children);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.parentId, this.parentName, this.isCustom, this.children);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Category {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    parentName: ").append(this.toIndentedString(this.parentName)).append("\n");
        sb.append("    isCustom: ").append(this.toIndentedString(this.isCustom)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

