/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.IdentifierList;
import io.swagger.client.model.PageableTransactionList;
import io.swagger.client.model.SplitTransactionsParams;
import io.swagger.client.model.Transaction;
import io.swagger.client.model.TransactionList;
import io.swagger.client.model.TriggerCategorizationParams;
import io.swagger.client.model.UpdateMultipleTransactionsParams;
import io.swagger.client.model.UpdateTransactionsParams;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TransactionsApi {
    private ApiClient apiClient;

    public TransactionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteAllTransactionsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/transactions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAllTransactionsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.deleteAllTransactionsCall(progressListener, progressRequestListener);
        return call;
    }

    public IdentifierList deleteAllTransactions() throws ApiException {
        ApiResponse<IdentifierList> resp = this.deleteAllTransactionsWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<IdentifierList> deleteAllTransactionsWithHttpInfo() throws ApiException {
        Call call = this.deleteAllTransactionsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAllTransactionsAsync(final ApiCallback<IdentifierList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAllTransactionsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteTransactionCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/transactions/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTransactionValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteTransaction(Async)");
        }
        Call call = this.deleteTransactionCall(id, progressListener, progressRequestListener);
        return call;
    }

    public void deleteTransaction(Long id) throws ApiException {
        this.deleteTransactionWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteTransactionWithHttpInfo(Long id) throws ApiException {
        Call call = this.deleteTransactionValidateBeforeCall(id, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteTransactionAsync(Long id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTransactionValidateBeforeCall(id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call editMultipleTransactionsCall(UpdateMultipleTransactionsParams body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateMultipleTransactionsParams localVarPostBody = body;
        String localVarPath = "/api/v1/transactions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call editMultipleTransactionsValidateBeforeCall(UpdateMultipleTransactionsParams body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling editMultipleTransactions(Async)");
        }
        Call call = this.editMultipleTransactionsCall(body, progressListener, progressRequestListener);
        return call;
    }

    public IdentifierList editMultipleTransactions(UpdateMultipleTransactionsParams body) throws ApiException {
        ApiResponse<IdentifierList> resp = this.editMultipleTransactionsWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<IdentifierList> editMultipleTransactionsWithHttpInfo(UpdateMultipleTransactionsParams body) throws ApiException {
        Call call = this.editMultipleTransactionsValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call editMultipleTransactionsAsync(UpdateMultipleTransactionsParams body, final ApiCallback<IdentifierList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.editMultipleTransactionsValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    @Deprecated
    public Call editMultipleTransactionsDeprecatedCall(List<Long> ids, UpdateTransactionsParams body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateTransactionsParams localVarPostBody = body;
        String localVarPath = "/api/v1/transactions/{ids}".replaceAll("\\{ids\\}", this.apiClient.escapeString(ids.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    private Call editMultipleTransactionsDeprecatedValidateBeforeCall(List<Long> ids, UpdateTransactionsParams body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling editMultipleTransactionsDeprecated(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling editMultipleTransactionsDeprecated(Async)");
        }
        Call call = this.editMultipleTransactionsDeprecatedCall(ids, body, progressListener, progressRequestListener);
        return call;
    }

    @Deprecated
    public IdentifierList editMultipleTransactionsDeprecated(List<Long> ids, UpdateTransactionsParams body) throws ApiException {
        ApiResponse<IdentifierList> resp = this.editMultipleTransactionsDeprecatedWithHttpInfo(ids, body);
        return resp.getData();
    }

    @Deprecated
    public ApiResponse<IdentifierList> editMultipleTransactionsDeprecatedWithHttpInfo(List<Long> ids, UpdateTransactionsParams body) throws ApiException {
        Call call = this.editMultipleTransactionsDeprecatedValidateBeforeCall(ids, body, null, null);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    @Deprecated
    public Call editMultipleTransactionsDeprecatedAsync(List<Long> ids, UpdateTransactionsParams body, final ApiCallback<IdentifierList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.editMultipleTransactionsDeprecatedValidateBeforeCall(ids, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call editTransactionCall(Long id, UpdateTransactionsParams body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateTransactionsParams localVarPostBody = body;
        String localVarPath = "/api/v1/transactions/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call editTransactionValidateBeforeCall(Long id, UpdateTransactionsParams body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling editTransaction(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling editTransaction(Async)");
        }
        Call call = this.editTransactionCall(id, body, progressListener, progressRequestListener);
        return call;
    }

    public Transaction editTransaction(Long id, UpdateTransactionsParams body) throws ApiException {
        ApiResponse<Transaction> resp = this.editTransactionWithHttpInfo(id, body);
        return resp.getData();
    }

    public ApiResponse<Transaction> editTransactionWithHttpInfo(Long id, UpdateTransactionsParams body) throws ApiException {
        Call call = this.editTransactionValidateBeforeCall(id, body, null, null);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call editTransactionAsync(Long id, UpdateTransactionsParams body, final ApiCallback<Transaction> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.editTransactionValidateBeforeCall(id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAndSearchAllTransactionsCall(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, Boolean isAdjustingEntry, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/transactions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ids != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "ids", ids));
        }
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("view", view));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search", search));
        }
        if (counterpart != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("counterpart", counterpart));
        }
        if (accountIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "accountIds", accountIds));
        }
        if (minBankBookingDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("minBankBookingDate", minBankBookingDate));
        }
        if (maxBankBookingDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxBankBookingDate", maxBankBookingDate));
        }
        if (minFinapiBookingDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("minFinapiBookingDate", minFinapiBookingDate));
        }
        if (maxFinapiBookingDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxFinapiBookingDate", maxFinapiBookingDate));
        }
        if (minAmount != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("minAmount", minAmount));
        }
        if (maxAmount != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxAmount", maxAmount));
        }
        if (direction != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("direction", direction));
        }
        if (labelIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "labelIds", labelIds));
        }
        if (categoryIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "categoryIds", categoryIds));
        }
        if (includeChildCategories != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("includeChildCategories", includeChildCategories));
        }
        if (isNew != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("isNew", isNew));
        }
        if (isPotentialDuplicate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("isPotentialDuplicate", isPotentialDuplicate));
        }
        if (isAdjustingEntry != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("isAdjustingEntry", isAdjustingEntry));
        }
        if (minImportDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("minImportDate", minImportDate));
        }
        if (maxImportDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxImportDate", maxImportDate));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("perPage", perPage));
        }
        if (order != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "order", order));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAndSearchAllTransactionsValidateBeforeCall(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, Boolean isAdjustingEntry, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (view == null) {
            throw new ApiException("Missing the required parameter 'view' when calling getAndSearchAllTransactions(Async)");
        }
        Call call = this.getAndSearchAllTransactionsCall(view, ids, search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, includeChildCategories, isNew, isPotentialDuplicate, isAdjustingEntry, minImportDate, maxImportDate, page, perPage, order, progressListener, progressRequestListener);
        return call;
    }

    public PageableTransactionList getAndSearchAllTransactions(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, Boolean isAdjustingEntry, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order) throws ApiException {
        ApiResponse<PageableTransactionList> resp = this.getAndSearchAllTransactionsWithHttpInfo(view, ids, search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, includeChildCategories, isNew, isPotentialDuplicate, isAdjustingEntry, minImportDate, maxImportDate, page, perPage, order);
        return resp.getData();
    }

    public ApiResponse<PageableTransactionList> getAndSearchAllTransactionsWithHttpInfo(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, Boolean isAdjustingEntry, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order) throws ApiException {
        Call call = this.getAndSearchAllTransactionsValidateBeforeCall(view, ids, search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, includeChildCategories, isNew, isPotentialDuplicate, isAdjustingEntry, minImportDate, maxImportDate, page, perPage, order, null, null);
        Type localVarReturnType = new TypeToken<PageableTransactionList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAndSearchAllTransactionsAsync(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, Boolean isAdjustingEntry, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order, final ApiCallback<PageableTransactionList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAndSearchAllTransactionsValidateBeforeCall(view, ids, search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, includeChildCategories, isNew, isPotentialDuplicate, isAdjustingEntry, minImportDate, maxImportDate, page, perPage, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PageableTransactionList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    @Deprecated
    public Call getMultipleTransactionsCall(List<Long> ids, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/transactions/{ids}".replaceAll("\\{ids\\}", this.apiClient.escapeString(ids.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    private Call getMultipleTransactionsValidateBeforeCall(List<Long> ids, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling getMultipleTransactions(Async)");
        }
        Call call = this.getMultipleTransactionsCall(ids, progressListener, progressRequestListener);
        return call;
    }

    @Deprecated
    public TransactionList getMultipleTransactions(List<Long> ids) throws ApiException {
        ApiResponse<TransactionList> resp = this.getMultipleTransactionsWithHttpInfo(ids);
        return resp.getData();
    }

    @Deprecated
    public ApiResponse<TransactionList> getMultipleTransactionsWithHttpInfo(List<Long> ids) throws ApiException {
        Call call = this.getMultipleTransactionsValidateBeforeCall(ids, null, null);
        Type localVarReturnType = new TypeToken<TransactionList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    @Deprecated
    public Call getMultipleTransactionsAsync(List<Long> ids, final ApiCallback<TransactionList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMultipleTransactionsValidateBeforeCall(ids, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TransactionList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTransactionCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/transactions/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTransactionValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTransaction(Async)");
        }
        Call call = this.getTransactionCall(id, progressListener, progressRequestListener);
        return call;
    }

    public Transaction getTransaction(Long id) throws ApiException {
        ApiResponse<Transaction> resp = this.getTransactionWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<Transaction> getTransactionWithHttpInfo(Long id) throws ApiException {
        Call call = this.getTransactionValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTransactionAsync(Long id, final ApiCallback<Transaction> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTransactionValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call restoreTransactionCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/transactions/{id}/restore".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call restoreTransactionValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling restoreTransaction(Async)");
        }
        Call call = this.restoreTransactionCall(id, progressListener, progressRequestListener);
        return call;
    }

    public Transaction restoreTransaction(Long id) throws ApiException {
        ApiResponse<Transaction> resp = this.restoreTransactionWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<Transaction> restoreTransactionWithHttpInfo(Long id) throws ApiException {
        Call call = this.restoreTransactionValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call restoreTransactionAsync(Long id, final ApiCallback<Transaction> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.restoreTransactionValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call splitTransactionCall(Long id, SplitTransactionsParams body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SplitTransactionsParams localVarPostBody = body;
        String localVarPath = "/api/v1/transactions/{id}/split".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call splitTransactionValidateBeforeCall(Long id, SplitTransactionsParams body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling splitTransaction(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling splitTransaction(Async)");
        }
        Call call = this.splitTransactionCall(id, body, progressListener, progressRequestListener);
        return call;
    }

    public Transaction splitTransaction(Long id, SplitTransactionsParams body) throws ApiException {
        ApiResponse<Transaction> resp = this.splitTransactionWithHttpInfo(id, body);
        return resp.getData();
    }

    public ApiResponse<Transaction> splitTransactionWithHttpInfo(Long id, SplitTransactionsParams body) throws ApiException {
        Call call = this.splitTransactionValidateBeforeCall(id, body, null, null);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call splitTransactionAsync(Long id, SplitTransactionsParams body, final ApiCallback<Transaction> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.splitTransactionValidateBeforeCall(id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call triggerCategorizationCall(TriggerCategorizationParams body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TriggerCategorizationParams localVarPostBody = body;
        String localVarPath = "/api/v1/transactions/triggerCategorization";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call triggerCategorizationValidateBeforeCall(TriggerCategorizationParams body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling triggerCategorization(Async)");
        }
        Call call = this.triggerCategorizationCall(body, progressListener, progressRequestListener);
        return call;
    }

    public void triggerCategorization(TriggerCategorizationParams body) throws ApiException {
        this.triggerCategorizationWithHttpInfo(body);
    }

    public ApiResponse<Void> triggerCategorizationWithHttpInfo(TriggerCategorizationParams body) throws ApiException {
        Call call = this.triggerCategorizationValidateBeforeCall(body, null, null);
        return this.apiClient.execute(call);
    }

    public Call triggerCategorizationAsync(TriggerCategorizationParams body, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.triggerCategorizationValidateBeforeCall(body, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

