/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.PageableSecurityList;
import io.swagger.client.model.Security;
import io.swagger.client.model.SecurityList;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SecuritiesApi {
    private ApiClient apiClient;

    public SecuritiesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SecuritiesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getAndSearchAllSecuritiesCall(List<Long> ids, String search, List<Long> accountIds, Integer page, Integer perPage, List<String> order, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/securities";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ids != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "ids", ids));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search", search));
        }
        if (accountIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "accountIds", accountIds));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("perPage", perPage));
        }
        if (order != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "order", order));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAndSearchAllSecuritiesValidateBeforeCall(List<Long> ids, String search, List<Long> accountIds, Integer page, Integer perPage, List<String> order, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAndSearchAllSecuritiesCall(ids, search, accountIds, page, perPage, order, progressListener, progressRequestListener);
        return call;
    }

    public PageableSecurityList getAndSearchAllSecurities(List<Long> ids, String search, List<Long> accountIds, Integer page, Integer perPage, List<String> order) throws ApiException {
        ApiResponse<PageableSecurityList> resp = this.getAndSearchAllSecuritiesWithHttpInfo(ids, search, accountIds, page, perPage, order);
        return resp.getData();
    }

    public ApiResponse<PageableSecurityList> getAndSearchAllSecuritiesWithHttpInfo(List<Long> ids, String search, List<Long> accountIds, Integer page, Integer perPage, List<String> order) throws ApiException {
        Call call = this.getAndSearchAllSecuritiesValidateBeforeCall(ids, search, accountIds, page, perPage, order, null, null);
        Type localVarReturnType = new TypeToken<PageableSecurityList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAndSearchAllSecuritiesAsync(List<Long> ids, String search, List<Long> accountIds, Integer page, Integer perPage, List<String> order, final ApiCallback<PageableSecurityList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAndSearchAllSecuritiesValidateBeforeCall(ids, search, accountIds, page, perPage, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PageableSecurityList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    @Deprecated
    public Call getMultipleSecuritiesCall(List<Long> ids, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/securities/{ids}".replaceAll("\\{ids\\}", this.apiClient.escapeString(ids.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    private Call getMultipleSecuritiesValidateBeforeCall(List<Long> ids, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling getMultipleSecurities(Async)");
        }
        Call call = this.getMultipleSecuritiesCall(ids, progressListener, progressRequestListener);
        return call;
    }

    @Deprecated
    public SecurityList getMultipleSecurities(List<Long> ids) throws ApiException {
        ApiResponse<SecurityList> resp = this.getMultipleSecuritiesWithHttpInfo(ids);
        return resp.getData();
    }

    @Deprecated
    public ApiResponse<SecurityList> getMultipleSecuritiesWithHttpInfo(List<Long> ids) throws ApiException {
        Call call = this.getMultipleSecuritiesValidateBeforeCall(ids, null, null);
        Type localVarReturnType = new TypeToken<SecurityList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    @Deprecated
    public Call getMultipleSecuritiesAsync(List<Long> ids, final ApiCallback<SecurityList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMultipleSecuritiesValidateBeforeCall(ids, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SecurityList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSecurityCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/securities/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSecurityValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSecurity(Async)");
        }
        Call call = this.getSecurityCall(id, progressListener, progressRequestListener);
        return call;
    }

    public Security getSecurity(Long id) throws ApiException {
        ApiResponse<Security> resp = this.getSecurityWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<Security> getSecurityWithHttpInfo(Long id) throws ApiException {
        Call call = this.getSecurityValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<Security>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSecurityAsync(Long id, final ApiCallback<Security> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSecurityValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Security>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

