/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.ChangeClientCredentialsParams;
import io.swagger.client.model.PageableUserInfoList;
import io.swagger.client.model.UserIdentifiersList;
import io.swagger.client.model.UserIdentifiersParams;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MandatorAdministrationApi {
    private ApiClient apiClient;

    public MandatorAdministrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MandatorAdministrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call changeClientCredentialsCall(ChangeClientCredentialsParams body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ChangeClientCredentialsParams localVarPostBody = body;
        String localVarPath = "/api/v1/mandatorAdmin/changeClientCredentials";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call changeClientCredentialsValidateBeforeCall(ChangeClientCredentialsParams body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling changeClientCredentials(Async)");
        }
        Call call = this.changeClientCredentialsCall(body, progressListener, progressRequestListener);
        return call;
    }

    public void changeClientCredentials(ChangeClientCredentialsParams body) throws ApiException {
        this.changeClientCredentialsWithHttpInfo(body);
    }

    public ApiResponse<Void> changeClientCredentialsWithHttpInfo(ChangeClientCredentialsParams body) throws ApiException {
        Call call = this.changeClientCredentialsValidateBeforeCall(body, null, null);
        return this.apiClient.execute(call);
    }

    public Call changeClientCredentialsAsync(ChangeClientCredentialsParams body, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.changeClientCredentialsValidateBeforeCall(body, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteUsersCall(UserIdentifiersParams body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UserIdentifiersParams localVarPostBody = body;
        String localVarPath = "/api/v1/mandatorAdmin/deleteUsers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteUsersValidateBeforeCall(UserIdentifiersParams body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling deleteUsers(Async)");
        }
        Call call = this.deleteUsersCall(body, progressListener, progressRequestListener);
        return call;
    }

    public UserIdentifiersList deleteUsers(UserIdentifiersParams body) throws ApiException {
        ApiResponse<UserIdentifiersList> resp = this.deleteUsersWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<UserIdentifiersList> deleteUsersWithHttpInfo(UserIdentifiersParams body) throws ApiException {
        Call call = this.deleteUsersValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<UserIdentifiersList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteUsersAsync(UserIdentifiersParams body, final ApiCallback<UserIdentifiersList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteUsersValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserIdentifiersList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getUserListCall(String minRegistrationDate, String maxRegistrationDate, String minDeletionDate, String maxDeletionDate, String minLastActiveDate, String maxLastActiveDate, Boolean includeMonthlyStats, String monthlyStatsStartDate, String monthlyStatsEndDate, Boolean isDeleted, Integer page, Integer perPage, List<String> order, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/mandatorAdmin/getUserList";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (minRegistrationDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("minRegistrationDate", minRegistrationDate));
        }
        if (maxRegistrationDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxRegistrationDate", maxRegistrationDate));
        }
        if (minDeletionDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("minDeletionDate", minDeletionDate));
        }
        if (maxDeletionDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxDeletionDate", maxDeletionDate));
        }
        if (minLastActiveDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("minLastActiveDate", minLastActiveDate));
        }
        if (maxLastActiveDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxLastActiveDate", maxLastActiveDate));
        }
        if (includeMonthlyStats != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("includeMonthlyStats", includeMonthlyStats));
        }
        if (monthlyStatsStartDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("monthlyStatsStartDate", monthlyStatsStartDate));
        }
        if (monthlyStatsEndDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("monthlyStatsEndDate", monthlyStatsEndDate));
        }
        if (isDeleted != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("isDeleted", isDeleted));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("perPage", perPage));
        }
        if (order != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "order", order));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUserListValidateBeforeCall(String minRegistrationDate, String maxRegistrationDate, String minDeletionDate, String maxDeletionDate, String minLastActiveDate, String maxLastActiveDate, Boolean includeMonthlyStats, String monthlyStatsStartDate, String monthlyStatsEndDate, Boolean isDeleted, Integer page, Integer perPage, List<String> order, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getUserListCall(minRegistrationDate, maxRegistrationDate, minDeletionDate, maxDeletionDate, minLastActiveDate, maxLastActiveDate, includeMonthlyStats, monthlyStatsStartDate, monthlyStatsEndDate, isDeleted, page, perPage, order, progressListener, progressRequestListener);
        return call;
    }

    public PageableUserInfoList getUserList(String minRegistrationDate, String maxRegistrationDate, String minDeletionDate, String maxDeletionDate, String minLastActiveDate, String maxLastActiveDate, Boolean includeMonthlyStats, String monthlyStatsStartDate, String monthlyStatsEndDate, Boolean isDeleted, Integer page, Integer perPage, List<String> order) throws ApiException {
        ApiResponse<PageableUserInfoList> resp = this.getUserListWithHttpInfo(minRegistrationDate, maxRegistrationDate, minDeletionDate, maxDeletionDate, minLastActiveDate, maxLastActiveDate, includeMonthlyStats, monthlyStatsStartDate, monthlyStatsEndDate, isDeleted, page, perPage, order);
        return resp.getData();
    }

    public ApiResponse<PageableUserInfoList> getUserListWithHttpInfo(String minRegistrationDate, String maxRegistrationDate, String minDeletionDate, String maxDeletionDate, String minLastActiveDate, String maxLastActiveDate, Boolean includeMonthlyStats, String monthlyStatsStartDate, String monthlyStatsEndDate, Boolean isDeleted, Integer page, Integer perPage, List<String> order) throws ApiException {
        Call call = this.getUserListValidateBeforeCall(minRegistrationDate, maxRegistrationDate, minDeletionDate, maxDeletionDate, minLastActiveDate, maxLastActiveDate, includeMonthlyStats, monthlyStatsStartDate, monthlyStatsEndDate, isDeleted, page, perPage, order, null, null);
        Type localVarReturnType = new TypeToken<PageableUserInfoList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserListAsync(String minRegistrationDate, String maxRegistrationDate, String minDeletionDate, String maxDeletionDate, String minLastActiveDate, String maxLastActiveDate, Boolean includeMonthlyStats, String monthlyStatsStartDate, String monthlyStatsEndDate, Boolean isDeleted, Integer page, Integer perPage, List<String> order, final ApiCallback<PageableUserInfoList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUserListValidateBeforeCall(minRegistrationDate, maxRegistrationDate, minDeletionDate, maxDeletionDate, minLastActiveDate, maxLastActiveDate, includeMonthlyStats, monthlyStatsStartDate, monthlyStatsEndDate, isDeleted, page, perPage, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PageableUserInfoList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

