/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.Bank;
import io.swagger.client.model.BankList;
import io.swagger.client.model.PageableBankList;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BanksApi {
    private ApiClient apiClient;

    public BanksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BanksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getAndSearchAllBanksCall(List<Long> ids, String search, Boolean isSupported, Boolean pinsAreVolatile, List<String> supportedDataSources, List<String> location, Boolean isTestBank, Integer page, Integer perPage, List<String> order, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/banks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ids != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "ids", ids));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search", search));
        }
        if (isSupported != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("isSupported", isSupported));
        }
        if (pinsAreVolatile != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pinsAreVolatile", pinsAreVolatile));
        }
        if (supportedDataSources != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "supportedDataSources", supportedDataSources));
        }
        if (location != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "location", location));
        }
        if (isTestBank != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("isTestBank", isTestBank));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("perPage", perPage));
        }
        if (order != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "order", order));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAndSearchAllBanksValidateBeforeCall(List<Long> ids, String search, Boolean isSupported, Boolean pinsAreVolatile, List<String> supportedDataSources, List<String> location, Boolean isTestBank, Integer page, Integer perPage, List<String> order, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAndSearchAllBanksCall(ids, search, isSupported, pinsAreVolatile, supportedDataSources, location, isTestBank, page, perPage, order, progressListener, progressRequestListener);
        return call;
    }

    public PageableBankList getAndSearchAllBanks(List<Long> ids, String search, Boolean isSupported, Boolean pinsAreVolatile, List<String> supportedDataSources, List<String> location, Boolean isTestBank, Integer page, Integer perPage, List<String> order) throws ApiException {
        ApiResponse<PageableBankList> resp = this.getAndSearchAllBanksWithHttpInfo(ids, search, isSupported, pinsAreVolatile, supportedDataSources, location, isTestBank, page, perPage, order);
        return resp.getData();
    }

    public ApiResponse<PageableBankList> getAndSearchAllBanksWithHttpInfo(List<Long> ids, String search, Boolean isSupported, Boolean pinsAreVolatile, List<String> supportedDataSources, List<String> location, Boolean isTestBank, Integer page, Integer perPage, List<String> order) throws ApiException {
        Call call = this.getAndSearchAllBanksValidateBeforeCall(ids, search, isSupported, pinsAreVolatile, supportedDataSources, location, isTestBank, page, perPage, order, null, null);
        Type localVarReturnType = new TypeToken<PageableBankList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAndSearchAllBanksAsync(List<Long> ids, String search, Boolean isSupported, Boolean pinsAreVolatile, List<String> supportedDataSources, List<String> location, Boolean isTestBank, Integer page, Integer perPage, List<String> order, final ApiCallback<PageableBankList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAndSearchAllBanksValidateBeforeCall(ids, search, isSupported, pinsAreVolatile, supportedDataSources, location, isTestBank, page, perPage, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PageableBankList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getBankCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/banks/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getBankValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getBank(Async)");
        }
        Call call = this.getBankCall(id, progressListener, progressRequestListener);
        return call;
    }

    public Bank getBank(Long id) throws ApiException {
        ApiResponse<Bank> resp = this.getBankWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<Bank> getBankWithHttpInfo(Long id) throws ApiException {
        Call call = this.getBankValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<Bank>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getBankAsync(Long id, final ApiCallback<Bank> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getBankValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Bank>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    @Deprecated
    public Call getMultipleBanksCall(List<Long> ids, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/banks/{ids}".replaceAll("\\{ids\\}", this.apiClient.escapeString(ids.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    private Call getMultipleBanksValidateBeforeCall(List<Long> ids, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling getMultipleBanks(Async)");
        }
        Call call = this.getMultipleBanksCall(ids, progressListener, progressRequestListener);
        return call;
    }

    @Deprecated
    public BankList getMultipleBanks(List<Long> ids) throws ApiException {
        ApiResponse<BankList> resp = this.getMultipleBanksWithHttpInfo(ids);
        return resp.getData();
    }

    @Deprecated
    public ApiResponse<BankList> getMultipleBanksWithHttpInfo(List<Long> ids) throws ApiException {
        Call call = this.getMultipleBanksValidateBeforeCall(ids, null, null);
        Type localVarReturnType = new TypeToken<BankList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    @Deprecated
    public Call getMultipleBanksAsync(List<Long> ids, final ApiCallback<BankList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMultipleBanksValidateBeforeCall(ids, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BankList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

