/*
 * finAPI RESTful Services
 * finAPI RESTful Services
 *
 * OpenAPI spec version: v1.46.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Two-step-procedure for a communication with a bank server, e.g. for doing a money transfer
 */
@ApiModel(description = "Two-step-procedure for a communication with a bank server, e.g. for doing a money transfer")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-05-14T19:12:52.919Z")
public class TwoStepProcedure {
  @SerializedName("procedureId")
  private String procedureId = null;

  @SerializedName("procedureName")
  private String procedureName = null;

  @SerializedName("procedureChallengeType")
  private String procedureChallengeType = null;

  @SerializedName("implicitExecute")
  private Boolean implicitExecute = false;

  public TwoStepProcedure procedureId(String procedureId) {
    this.procedureId = procedureId;
    return this;
  }

   /**
   * Bank-given ID of the procedure
   * @return procedureId
  **/
  @ApiModelProperty(required = true, value = "Bank-given ID of the procedure")
  public String getProcedureId() {
    return procedureId;
  }

  public void setProcedureId(String procedureId) {
    this.procedureId = procedureId;
  }

  public TwoStepProcedure procedureName(String procedureName) {
    this.procedureName = procedureName;
    return this;
  }

   /**
   * Bank-given name of the procedure
   * @return procedureName
  **/
  @ApiModelProperty(required = true, value = "Bank-given name of the procedure")
  public String getProcedureName() {
    return procedureName;
  }

  public void setProcedureName(String procedureName) {
    this.procedureName = procedureName;
  }

  public TwoStepProcedure procedureChallengeType(String procedureChallengeType) {
    this.procedureChallengeType = procedureChallengeType;
    return this;
  }

   /**
   * The challenge type of the procedure. Possible values are:&lt;br/&gt;&lt;br/&gt;&amp;bull; &lt;code&gt;TEXT&lt;/code&gt; - the challenge will be a text that contains instructions for the user on how to retrieve the TAN.&lt;br/&gt;&amp;bull; &lt;code&gt;PHOTO&lt;/code&gt; - the challenge will contain a BASE-64 string depicting a photo (or any kind of QR-code-like data) that must be shown to the user.&lt;br/&gt;&amp;bull; &lt;code&gt;FLICKER_CODE&lt;/code&gt; - the challenge will contain a BASE-64 string depicting a flicker code animation that must be shown to the user.&lt;br/&gt;&lt;br/&gt;Note that this challenge type information does not originate from the bank server, but is determined by finAPI internally. There is no guarantee that the determined challenge type is correct. Note also that this field may not be set, meaning that finAPI could not determine the challenge type of the procedure.&lt;br/&gt;&lt;br/&gt;For further information on how to deal with the challenges, please see &lt;a href&#x3D;&#39;https://finapi.zendesk.com/hc/en-us/articles/219117247-SEPA-Money-Transfer&#39;&gt;this article&lt;/a&gt; on our Dev Portal.
   * @return procedureChallengeType
  **/
  @ApiModelProperty(value = "The challenge type of the procedure. Possible values are:<br/><br/>&bull; <code>TEXT</code> - the challenge will be a text that contains instructions for the user on how to retrieve the TAN.<br/>&bull; <code>PHOTO</code> - the challenge will contain a BASE-64 string depicting a photo (or any kind of QR-code-like data) that must be shown to the user.<br/>&bull; <code>FLICKER_CODE</code> - the challenge will contain a BASE-64 string depicting a flicker code animation that must be shown to the user.<br/><br/>Note that this challenge type information does not originate from the bank server, but is determined by finAPI internally. There is no guarantee that the determined challenge type is correct. Note also that this field may not be set, meaning that finAPI could not determine the challenge type of the procedure.<br/><br/>For further information on how to deal with the challenges, please see <a href='https://finapi.zendesk.com/hc/en-us/articles/219117247-SEPA-Money-Transfer'>this article</a> on our Dev Portal.")
  public String getProcedureChallengeType() {
    return procedureChallengeType;
  }

  public void setProcedureChallengeType(String procedureChallengeType) {
    this.procedureChallengeType = procedureChallengeType;
  }

  public TwoStepProcedure implicitExecute(Boolean implicitExecute) {
    this.implicitExecute = implicitExecute;
    return this;
  }

   /**
   * If &#39;true&#39;, then requesting a SEPA order with this procedure will implicitly trigger the execution of the order. For example, if you do a money transfer with this procedure, then calling the /requestSepaMoneyTransfer service will immediately execute the order (a call to /executeSepaMoneyTransfer will not be necessary). On the other hand, if this flag is &#39;false&#39;, then doing a money transfer with this procedure will require you to first call /requestSepaMoneyTransfer, and then call /executeSepaMoneyTransfer.
   * @return implicitExecute
  **/
  @ApiModelProperty(required = true, value = "If 'true', then requesting a SEPA order with this procedure will implicitly trigger the execution of the order. For example, if you do a money transfer with this procedure, then calling the /requestSepaMoneyTransfer service will immediately execute the order (a call to /executeSepaMoneyTransfer will not be necessary). On the other hand, if this flag is 'false', then doing a money transfer with this procedure will require you to first call /requestSepaMoneyTransfer, and then call /executeSepaMoneyTransfer.")
  public Boolean isImplicitExecute() {
    return implicitExecute;
  }

  public void setImplicitExecute(Boolean implicitExecute) {
    this.implicitExecute = implicitExecute;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TwoStepProcedure twoStepProcedure = (TwoStepProcedure) o;
    return Objects.equals(this.procedureId, twoStepProcedure.procedureId) &&
        Objects.equals(this.procedureName, twoStepProcedure.procedureName) &&
        Objects.equals(this.procedureChallengeType, twoStepProcedure.procedureChallengeType) &&
        Objects.equals(this.implicitExecute, twoStepProcedure.implicitExecute);
  }

  @Override
  public int hashCode() {
    return Objects.hash(procedureId, procedureName, procedureChallengeType, implicitExecute);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TwoStepProcedure {\n");
    
    sb.append("    procedureId: ").append(toIndentedString(procedureId)).append("\n");
    sb.append("    procedureName: ").append(toIndentedString(procedureName)).append("\n");
    sb.append("    procedureChallengeType: ").append(toIndentedString(procedureChallengeType)).append("\n");
    sb.append("    implicitExecute: ").append(toIndentedString(implicitExecute)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

