/*
 * finAPI RESTful Services
 * finAPI RESTful Services
 *
 * OpenAPI spec version: v1.46.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.SingleDirectDebitData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Parameters for a single or collective SEPA direct debit order request
 */
@ApiModel(description = "Parameters for a single or collective SEPA direct debit order request")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-05-14T19:12:52.919Z")
public class RequestSepaDirectDebitParams {
  @SerializedName("accountId")
  private Long accountId = null;

  @SerializedName("bankingPin")
  private String bankingPin = null;

  @SerializedName("twoStepProcedureId")
  private String twoStepProcedureId = null;

  /**
   * Type of the direct debit; either &lt;code&gt;BASIC&lt;/code&gt; or &lt;code&gt;B2B&lt;/code&gt; (Business-To-Business). Please note that an account which supports the basic type must not necessarily support B2B (or vice versa). Check the source account&#39;s &#39;supportedOrders&#39; field to find out which types of direct debit it supports.&lt;br/&gt;&lt;br/&gt;
   */
  @JsonAdapter(DirectDebitTypeEnum.Adapter.class)
  public enum DirectDebitTypeEnum {
    B2B("B2B"),
    
    BASIC("BASIC");

    private String value;

    DirectDebitTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DirectDebitTypeEnum fromValue(String text) {
      for (DirectDebitTypeEnum b : DirectDebitTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<DirectDebitTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DirectDebitTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DirectDebitTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return DirectDebitTypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("directDebitType")
  private DirectDebitTypeEnum directDebitType = null;

  /**
   * Sequence type of the direct debit. Possible values:&lt;br/&gt;&lt;br/&gt;&amp;bull; &lt;code&gt;OOFF&lt;/code&gt; - means that this is a one-time direct debit order&lt;br/&gt;&amp;bull; &lt;code&gt;FRST&lt;/code&gt; - means that this is the first in a row of multiple direct debit orders&lt;br/&gt;&amp;bull; &lt;code&gt;RCUR&lt;/code&gt; - means that this is one (but not the first or final) within a row of multiple direct debit orders&lt;br/&gt;&amp;bull; &lt;code&gt;FNAL&lt;/code&gt; - means that this is the final in a row of multiple direct debit orders&lt;br/&gt;&lt;br/&gt;
   */
  @JsonAdapter(SequenceTypeEnum.Adapter.class)
  public enum SequenceTypeEnum {
    OOFF("OOFF"),
    
    FRST("FRST"),
    
    RCUR("RCUR"),
    
    FNAL("FNAL");

    private String value;

    SequenceTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static SequenceTypeEnum fromValue(String text) {
      for (SequenceTypeEnum b : SequenceTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<SequenceTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SequenceTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public SequenceTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return SequenceTypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("sequenceType")
  private SequenceTypeEnum sequenceType = null;

  @SerializedName("executionDate")
  private String executionDate = null;

  @SerializedName("directDebits")
  private List<SingleDirectDebitData> directDebits = new ArrayList<SingleDirectDebitData>();

  public RequestSepaDirectDebitParams accountId(Long accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Identifier of the bank account to which you want to transfer the money.
   * @return accountId
  **/
  @ApiModelProperty(required = true, value = "Identifier of the bank account to which you want to transfer the money.")
  public Long getAccountId() {
    return accountId;
  }

  public void setAccountId(Long accountId) {
    this.accountId = accountId;
  }

  public RequestSepaDirectDebitParams bankingPin(String bankingPin) {
    this.bankingPin = bankingPin;
    return this;
  }

   /**
   * Online banking PIN. If a PIN is stored in the account&#39;s bank connection, then this field may remain unset. If the field is set though then it will always be used (even if there is some other PIN stored in the bank connection).
   * @return bankingPin
  **/
  @ApiModelProperty(value = "Online banking PIN. If a PIN is stored in the account's bank connection, then this field may remain unset. If the field is set though then it will always be used (even if there is some other PIN stored in the bank connection).")
  public String getBankingPin() {
    return bankingPin;
  }

  public void setBankingPin(String bankingPin) {
    this.bankingPin = bankingPin;
  }

  public RequestSepaDirectDebitParams twoStepProcedureId(String twoStepProcedureId) {
    this.twoStepProcedureId = twoStepProcedureId;
    return this;
  }

   /**
   * The bank-given ID of the two-step-procedure that should be used for the direct debit order. For a list of available two-step-procedures, see the corresponding bank connection (GET /bankConnections). If this field is not set, then the bank connection&#39;s default two-step procedure will be used. Note that in this case, when the bank connection has no default two-step procedure set, then the service will return an error (see response messages for details).
   * @return twoStepProcedureId
  **/
  @ApiModelProperty(value = "The bank-given ID of the two-step-procedure that should be used for the direct debit order. For a list of available two-step-procedures, see the corresponding bank connection (GET /bankConnections). If this field is not set, then the bank connection's default two-step procedure will be used. Note that in this case, when the bank connection has no default two-step procedure set, then the service will return an error (see response messages for details).")
  public String getTwoStepProcedureId() {
    return twoStepProcedureId;
  }

  public void setTwoStepProcedureId(String twoStepProcedureId) {
    this.twoStepProcedureId = twoStepProcedureId;
  }

  public RequestSepaDirectDebitParams directDebitType(DirectDebitTypeEnum directDebitType) {
    this.directDebitType = directDebitType;
    return this;
  }

   /**
   * Type of the direct debit; either &lt;code&gt;BASIC&lt;/code&gt; or &lt;code&gt;B2B&lt;/code&gt; (Business-To-Business). Please note that an account which supports the basic type must not necessarily support B2B (or vice versa). Check the source account&#39;s &#39;supportedOrders&#39; field to find out which types of direct debit it supports.&lt;br/&gt;&lt;br/&gt;
   * @return directDebitType
  **/
  @ApiModelProperty(required = true, value = "Type of the direct debit; either <code>BASIC</code> or <code>B2B</code> (Business-To-Business). Please note that an account which supports the basic type must not necessarily support B2B (or vice versa). Check the source account's 'supportedOrders' field to find out which types of direct debit it supports.<br/><br/>")
  public DirectDebitTypeEnum getDirectDebitType() {
    return directDebitType;
  }

  public void setDirectDebitType(DirectDebitTypeEnum directDebitType) {
    this.directDebitType = directDebitType;
  }

  public RequestSepaDirectDebitParams sequenceType(SequenceTypeEnum sequenceType) {
    this.sequenceType = sequenceType;
    return this;
  }

   /**
   * Sequence type of the direct debit. Possible values:&lt;br/&gt;&lt;br/&gt;&amp;bull; &lt;code&gt;OOFF&lt;/code&gt; - means that this is a one-time direct debit order&lt;br/&gt;&amp;bull; &lt;code&gt;FRST&lt;/code&gt; - means that this is the first in a row of multiple direct debit orders&lt;br/&gt;&amp;bull; &lt;code&gt;RCUR&lt;/code&gt; - means that this is one (but not the first or final) within a row of multiple direct debit orders&lt;br/&gt;&amp;bull; &lt;code&gt;FNAL&lt;/code&gt; - means that this is the final in a row of multiple direct debit orders&lt;br/&gt;&lt;br/&gt;
   * @return sequenceType
  **/
  @ApiModelProperty(required = true, value = "Sequence type of the direct debit. Possible values:<br/><br/>&bull; <code>OOFF</code> - means that this is a one-time direct debit order<br/>&bull; <code>FRST</code> - means that this is the first in a row of multiple direct debit orders<br/>&bull; <code>RCUR</code> - means that this is one (but not the first or final) within a row of multiple direct debit orders<br/>&bull; <code>FNAL</code> - means that this is the final in a row of multiple direct debit orders<br/><br/>")
  public SequenceTypeEnum getSequenceType() {
    return sequenceType;
  }

  public void setSequenceType(SequenceTypeEnum sequenceType) {
    this.sequenceType = sequenceType;
  }

  public RequestSepaDirectDebitParams executionDate(String executionDate) {
    this.executionDate = executionDate;
    return this;
  }

   /**
   * Execution date for the direct debit(s), in the format &#39;yyyy-MM-dd&#39;.
   * @return executionDate
  **/
  @ApiModelProperty(required = true, value = "Execution date for the direct debit(s), in the format 'yyyy-MM-dd'.")
  public String getExecutionDate() {
    return executionDate;
  }

  public void setExecutionDate(String executionDate) {
    this.executionDate = executionDate;
  }

  public RequestSepaDirectDebitParams directDebits(List<SingleDirectDebitData> directDebits) {
    this.directDebits = directDebits;
    return this;
  }

  public RequestSepaDirectDebitParams addDirectDebitsItem(SingleDirectDebitData directDebitsItem) {
    this.directDebits.add(directDebitsItem);
    return this;
  }

   /**
   * List of the direct debits that you want to execute. Please check the account&#39;s &#39;supportedOrders&#39; field to find out whether you can pass multiple direct debits or just one.
   * @return directDebits
  **/
  @ApiModelProperty(required = true, value = "List of the direct debits that you want to execute. Please check the account's 'supportedOrders' field to find out whether you can pass multiple direct debits or just one.")
  public List<SingleDirectDebitData> getDirectDebits() {
    return directDebits;
  }

  public void setDirectDebits(List<SingleDirectDebitData> directDebits) {
    this.directDebits = directDebits;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RequestSepaDirectDebitParams requestSepaDirectDebitParams = (RequestSepaDirectDebitParams) o;
    return Objects.equals(this.accountId, requestSepaDirectDebitParams.accountId) &&
        Objects.equals(this.bankingPin, requestSepaDirectDebitParams.bankingPin) &&
        Objects.equals(this.twoStepProcedureId, requestSepaDirectDebitParams.twoStepProcedureId) &&
        Objects.equals(this.directDebitType, requestSepaDirectDebitParams.directDebitType) &&
        Objects.equals(this.sequenceType, requestSepaDirectDebitParams.sequenceType) &&
        Objects.equals(this.executionDate, requestSepaDirectDebitParams.executionDate) &&
        Objects.equals(this.directDebits, requestSepaDirectDebitParams.directDebits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, bankingPin, twoStepProcedureId, directDebitType, sequenceType, executionDate, directDebits);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RequestSepaDirectDebitParams {\n");
    
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    bankingPin: ").append(toIndentedString(bankingPin)).append("\n");
    sb.append("    twoStepProcedureId: ").append(toIndentedString(twoStepProcedureId)).append("\n");
    sb.append("    directDebitType: ").append(toIndentedString(directDebitType)).append("\n");
    sb.append("    sequenceType: ").append(toIndentedString(sequenceType)).append("\n");
    sb.append("    executionDate: ").append(toIndentedString(executionDate)).append("\n");
    sb.append("    directDebits: ").append(toIndentedString(directDebits)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

