/*
 * finAPI RESTful Services
 * finAPI RESTful Services
 *
 * OpenAPI spec version: v1.46.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.ClearingAccountData;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * Container for a bank account&#39;s data
 */
@ApiModel(description = "Container for a bank account's data")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-05-14T19:12:52.919Z")
public class Account {
  @SerializedName("id")
  private Long id = null;

  @SerializedName("bankConnectionId")
  private Long bankConnectionId = null;

  @SerializedName("accountName")
  private String accountName = null;

  @SerializedName("accountNumber")
  private String accountNumber = null;

  @SerializedName("subAccountNumber")
  private String subAccountNumber = null;

  @SerializedName("iban")
  private String iban = null;

  @SerializedName("accountHolderName")
  private String accountHolderName = null;

  @SerializedName("accountHolderId")
  private String accountHolderId = null;

  @SerializedName("accountCurrency")
  private String accountCurrency = null;

  @SerializedName("accountTypeId")
  private Long accountTypeId = null;

  @SerializedName("accountTypeName")
  private String accountTypeName = null;

  @SerializedName("balance")
  private BigDecimal balance = null;

  @SerializedName("overdraft")
  private BigDecimal overdraft = null;

  @SerializedName("overdraftLimit")
  private BigDecimal overdraftLimit = null;

  @SerializedName("availableFunds")
  private BigDecimal availableFunds = null;

  @SerializedName("lastSuccessfulUpdate")
  private String lastSuccessfulUpdate = null;

  @SerializedName("lastUpdateAttempt")
  private String lastUpdateAttempt = null;

  @SerializedName("isNew")
  private Boolean isNew = false;

  /**
   * The current status of the account. Possible values are:&lt;br/&gt;&amp;bull; &lt;code&gt;UPDATED&lt;/code&gt; means that the account is up to date from finAPI&#39;s point of view. This means that no current import/update is running, and the previous import/update could successfully update the account&#39;s data (e.g. transactions and securities), and the bank given balance matched the transaction&#39;s calculated sum, meaning that no adjusting entry (&#39;Zwischensaldo&#39; transaction) was inserted.&lt;br/&gt;&amp;bull; &lt;code&gt;UPDATED_FIXED&lt;/code&gt; means that the account is up to date from finAPI&#39;s point of view (no current import/update is running, and the previous import/update could successfully update the account&#39;s data), BUT there was a deviation in the bank given balance which was fixed by adding an adjusting entry (&#39;Zwischensaldo&#39; transaction).&lt;br/&gt;&amp;bull; &lt;code&gt;DOWNLOAD_IN_PROGRESS&lt;/code&gt; means that the account&#39;s data is currently being imported/updated.&lt;br/&gt;&amp;bull; &lt;code&gt;DOWNLOAD_FAILED&lt;/code&gt; means that the account data could not get successfully imported or updated. Possible reasons: finAPI could not get the account&#39;s balance, or it could not parse all transactions/securities, or some internal error has occurred. Also, it could mean that finAPI could not even get to the point of receiving the account data from the bank server, for example because of incorrect login credentials or a network problem. Note however that when we get a balance and just an empty list of transactions or securities, then this is regarded as valid and successful download. The reason for this is that for some accounts that have little activity, we may actually get no recent transactions but only a balance.&lt;br/&gt;&amp;bull; &lt;code&gt;DEPRECATED&lt;/code&gt; means that the account could no longer get matched with any account from the bank server. This can mean either that the account was terminated by the user and is no longer sent by the bank server, or that finAPI could no longer match it because the account&#39;s data (name, type, iban, account number, etc.) has been changed by the bank.
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    UPDATED("UPDATED"),
    
    UPDATED_FIXED("UPDATED_FIXED"),
    
    DOWNLOAD_IN_PROGRESS("DOWNLOAD_IN_PROGRESS"),
    
    DOWNLOAD_FAILED("DOWNLOAD_FAILED"),
    
    DEPRECATED("DEPRECATED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return StatusEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("status")
  private StatusEnum status = null;

  /**
   * Gets or Sets supportedOrders
   */
  @JsonAdapter(SupportedOrdersEnum.Adapter.class)
  public enum SupportedOrdersEnum {
    MONEY_TRANSFER("SEPA_MONEY_TRANSFER"),
    
    COLLECTIVE_MONEY_TRANSFER("SEPA_COLLECTIVE_MONEY_TRANSFER"),
    
    BASIC_DIRECT_DEBIT("SEPA_BASIC_DIRECT_DEBIT"),
    
    BASIC_COLLECTIVE_DIRECT_DEBIT("SEPA_BASIC_COLLECTIVE_DIRECT_DEBIT"),
    
    B2B_DIRECT_DEBIT("SEPA_B2B_DIRECT_DEBIT"),
    
    B2B_COLLECTIVE_DIRECT_DEBIT("SEPA_B2B_COLLECTIVE_DIRECT_DEBIT");

    private String value;

    SupportedOrdersEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static SupportedOrdersEnum fromValue(String text) {
      for (SupportedOrdersEnum b : SupportedOrdersEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<SupportedOrdersEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SupportedOrdersEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public SupportedOrdersEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return SupportedOrdersEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("supportedOrders")
  private List<SupportedOrdersEnum> supportedOrders = new ArrayList<SupportedOrdersEnum>();

  @SerializedName("clearingAccounts")
  private List<ClearingAccountData> clearingAccounts = null;

  public Account id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * Account identifier
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Account identifier")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public Account bankConnectionId(Long bankConnectionId) {
    this.bankConnectionId = bankConnectionId;
    return this;
  }

   /**
   * Identifier of the bank connection that this account belongs to
   * @return bankConnectionId
  **/
  @ApiModelProperty(required = true, value = "Identifier of the bank connection that this account belongs to")
  public Long getBankConnectionId() {
    return bankConnectionId;
  }

  public void setBankConnectionId(Long bankConnectionId) {
    this.bankConnectionId = bankConnectionId;
  }

  public Account accountName(String accountName) {
    this.accountName = accountName;
    return this;
  }

   /**
   * Account name
   * @return accountName
  **/
  @ApiModelProperty(value = "Account name")
  public String getAccountName() {
    return accountName;
  }

  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }

  public Account accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * (National) account number. Note that this value might change whenever the account is updated (for example, leading zeros might be added or removed).
   * @return accountNumber
  **/
  @ApiModelProperty(required = true, value = "(National) account number. Note that this value might change whenever the account is updated (for example, leading zeros might be added or removed).")
  public String getAccountNumber() {
    return accountNumber;
  }

  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }

  public Account subAccountNumber(String subAccountNumber) {
    this.subAccountNumber = subAccountNumber;
    return this;
  }

   /**
   * Account&#39;s sub-account-number. Note that this field can change from &#39;null&#39; to a value - or vice versa - any time when the account is being updated. This is subject to changes within the bank&#39;s internal account management.
   * @return subAccountNumber
  **/
  @ApiModelProperty(value = "Account's sub-account-number. Note that this field can change from 'null' to a value - or vice versa - any time when the account is being updated. This is subject to changes within the bank's internal account management.")
  public String getSubAccountNumber() {
    return subAccountNumber;
  }

  public void setSubAccountNumber(String subAccountNumber) {
    this.subAccountNumber = subAccountNumber;
  }

  public Account iban(String iban) {
    this.iban = iban;
    return this;
  }

   /**
   * Account&#39;s IBAN. Note that this field can change from &#39;null&#39; to a value - or vice versa - any time when the account is being updated. This is subject to changes within the bank&#39;s internal account management.
   * @return iban
  **/
  @ApiModelProperty(value = "Account's IBAN. Note that this field can change from 'null' to a value - or vice versa - any time when the account is being updated. This is subject to changes within the bank's internal account management.")
  public String getIban() {
    return iban;
  }

  public void setIban(String iban) {
    this.iban = iban;
  }

  public Account accountHolderName(String accountHolderName) {
    this.accountHolderName = accountHolderName;
    return this;
  }

   /**
   * Name of the account holder
   * @return accountHolderName
  **/
  @ApiModelProperty(value = "Name of the account holder")
  public String getAccountHolderName() {
    return accountHolderName;
  }

  public void setAccountHolderName(String accountHolderName) {
    this.accountHolderName = accountHolderName;
  }

  public Account accountHolderId(String accountHolderId) {
    this.accountHolderId = accountHolderId;
    return this;
  }

   /**
   * Bank&#39;s internal identification of the account holder
   * @return accountHolderId
  **/
  @ApiModelProperty(value = "Bank's internal identification of the account holder")
  public String getAccountHolderId() {
    return accountHolderId;
  }

  public void setAccountHolderId(String accountHolderId) {
    this.accountHolderId = accountHolderId;
  }

  public Account accountCurrency(String accountCurrency) {
    this.accountCurrency = accountCurrency;
    return this;
  }

   /**
   * Account&#39;s currency
   * @return accountCurrency
  **/
  @ApiModelProperty(value = "Account's currency")
  public String getAccountCurrency() {
    return accountCurrency;
  }

  public void setAccountCurrency(String accountCurrency) {
    this.accountCurrency = accountCurrency;
  }

  public Account accountTypeId(Long accountTypeId) {
    this.accountTypeId = accountTypeId;
    return this;
  }

   /**
   * Identifier of the account&#39;s type. Note that, in general, the type of an account can change any time when the account is being updated. This is subject to changes within the bank&#39;s internal account management. However, if the account&#39;s type has previously been changed explicitly (via the PATCH method), then the explicitly set type will NOT be automatically changed anymore, even if the type has changed on the bank side. &lt;br/&gt;1 &#x3D; Checking,&lt;br/&gt;2 &#x3D; Savings,&lt;br/&gt;3 &#x3D; CreditCard,&lt;br/&gt;4 &#x3D; Security,&lt;br/&gt;5 &#x3D; Loan,&lt;br/&gt;6 &#x3D; Pocket (DEPRECATED; will not be returned for any account unless this type has explicitly been set via PATCH),&lt;br/&gt;7 &#x3D; Membership,&lt;br/&gt;8 &#x3D; Bausparen&lt;br/&gt;
   * @return accountTypeId
  **/
  @ApiModelProperty(required = true, value = "Identifier of the account's type. Note that, in general, the type of an account can change any time when the account is being updated. This is subject to changes within the bank's internal account management. However, if the account's type has previously been changed explicitly (via the PATCH method), then the explicitly set type will NOT be automatically changed anymore, even if the type has changed on the bank side. <br/>1 = Checking,<br/>2 = Savings,<br/>3 = CreditCard,<br/>4 = Security,<br/>5 = Loan,<br/>6 = Pocket (DEPRECATED; will not be returned for any account unless this type has explicitly been set via PATCH),<br/>7 = Membership,<br/>8 = Bausparen<br/>")
  public Long getAccountTypeId() {
    return accountTypeId;
  }

  public void setAccountTypeId(Long accountTypeId) {
    this.accountTypeId = accountTypeId;
  }

  public Account accountTypeName(String accountTypeName) {
    this.accountTypeName = accountTypeName;
    return this;
  }

   /**
   * Name of the account&#39;s type
   * @return accountTypeName
  **/
  @ApiModelProperty(required = true, value = "Name of the account's type")
  public String getAccountTypeName() {
    return accountTypeName;
  }

  public void setAccountTypeName(String accountTypeName) {
    this.accountTypeName = accountTypeName;
  }

  public Account balance(BigDecimal balance) {
    this.balance = balance;
    return this;
  }

   /**
   * Current account balance
   * @return balance
  **/
  @ApiModelProperty(value = "Current account balance")
  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public Account overdraft(BigDecimal overdraft) {
    this.overdraft = overdraft;
    return this;
  }

   /**
   * Current overdraft
   * @return overdraft
  **/
  @ApiModelProperty(value = "Current overdraft")
  public BigDecimal getOverdraft() {
    return overdraft;
  }

  public void setOverdraft(BigDecimal overdraft) {
    this.overdraft = overdraft;
  }

  public Account overdraftLimit(BigDecimal overdraftLimit) {
    this.overdraftLimit = overdraftLimit;
    return this;
  }

   /**
   * Overdraft limit
   * @return overdraftLimit
  **/
  @ApiModelProperty(value = "Overdraft limit")
  public BigDecimal getOverdraftLimit() {
    return overdraftLimit;
  }

  public void setOverdraftLimit(BigDecimal overdraftLimit) {
    this.overdraftLimit = overdraftLimit;
  }

  public Account availableFunds(BigDecimal availableFunds) {
    this.availableFunds = availableFunds;
    return this;
  }

   /**
   * Current available funds. Note that this field is only set if finAPI can make a definite statement about the current available funds. This might not always be the case, for example if there is not enough information available about the overdraft limit and current overdraft.
   * @return availableFunds
  **/
  @ApiModelProperty(value = "Current available funds. Note that this field is only set if finAPI can make a definite statement about the current available funds. This might not always be the case, for example if there is not enough information available about the overdraft limit and current overdraft.")
  public BigDecimal getAvailableFunds() {
    return availableFunds;
  }

  public void setAvailableFunds(BigDecimal availableFunds) {
    this.availableFunds = availableFunds;
  }

  public Account lastSuccessfulUpdate(String lastSuccessfulUpdate) {
    this.lastSuccessfulUpdate = lastSuccessfulUpdate;
    return this;
  }

   /**
   * Timestamp of when the account was last successfully updated (or initially imported); more precisely: time when the account data (balance and positions) has been stored into the finAPI databases. The value is returned in the format &#39;yyyy-MM-dd HH:mm:ss.SSS&#39; (german time).
   * @return lastSuccessfulUpdate
  **/
  @ApiModelProperty(value = "Timestamp of when the account was last successfully updated (or initially imported); more precisely: time when the account data (balance and positions) has been stored into the finAPI databases. The value is returned in the format 'yyyy-MM-dd HH:mm:ss.SSS' (german time).")
  public String getLastSuccessfulUpdate() {
    return lastSuccessfulUpdate;
  }

  public void setLastSuccessfulUpdate(String lastSuccessfulUpdate) {
    this.lastSuccessfulUpdate = lastSuccessfulUpdate;
  }

  public Account lastUpdateAttempt(String lastUpdateAttempt) {
    this.lastUpdateAttempt = lastUpdateAttempt;
    return this;
  }

   /**
   * Timestamp of when the account was last tried to be updated (or initially imported); more precisely: time when the update (or initial import) was triggered. The value is returned in the format &#39;yyyy-MM-dd HH:mm:ss.SSS&#39; (german time).
   * @return lastUpdateAttempt
  **/
  @ApiModelProperty(value = "Timestamp of when the account was last tried to be updated (or initially imported); more precisely: time when the update (or initial import) was triggered. The value is returned in the format 'yyyy-MM-dd HH:mm:ss.SSS' (german time).")
  public String getLastUpdateAttempt() {
    return lastUpdateAttempt;
  }

  public void setLastUpdateAttempt(String lastUpdateAttempt) {
    this.lastUpdateAttempt = lastUpdateAttempt;
  }

  public Account isNew(Boolean isNew) {
    this.isNew = isNew;
    return this;
  }

   /**
   * Indicating whether this account is &#39;new&#39; or not. Any newly imported account will have this flag initially set to true, and remain so until you set it to false (see PATCH /accounts/&lt;id&gt;). How you use this field is up to your interpretation, however it is recommended to set the flag to false for all accounts right after the initial import of the bank connection. This way, you will be able recognize accounts that get newly imported during a later update of the bank connection, by checking for any accounts with the flag set to true right after an update.
   * @return isNew
  **/
  @ApiModelProperty(required = true, value = "Indicating whether this account is 'new' or not. Any newly imported account will have this flag initially set to true, and remain so until you set it to false (see PATCH /accounts/<id>). How you use this field is up to your interpretation, however it is recommended to set the flag to false for all accounts right after the initial import of the bank connection. This way, you will be able recognize accounts that get newly imported during a later update of the bank connection, by checking for any accounts with the flag set to true right after an update.")
  public Boolean isIsNew() {
    return isNew;
  }

  public void setIsNew(Boolean isNew) {
    this.isNew = isNew;
  }

  public Account status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * The current status of the account. Possible values are:&lt;br/&gt;&amp;bull; &lt;code&gt;UPDATED&lt;/code&gt; means that the account is up to date from finAPI&#39;s point of view. This means that no current import/update is running, and the previous import/update could successfully update the account&#39;s data (e.g. transactions and securities), and the bank given balance matched the transaction&#39;s calculated sum, meaning that no adjusting entry (&#39;Zwischensaldo&#39; transaction) was inserted.&lt;br/&gt;&amp;bull; &lt;code&gt;UPDATED_FIXED&lt;/code&gt; means that the account is up to date from finAPI&#39;s point of view (no current import/update is running, and the previous import/update could successfully update the account&#39;s data), BUT there was a deviation in the bank given balance which was fixed by adding an adjusting entry (&#39;Zwischensaldo&#39; transaction).&lt;br/&gt;&amp;bull; &lt;code&gt;DOWNLOAD_IN_PROGRESS&lt;/code&gt; means that the account&#39;s data is currently being imported/updated.&lt;br/&gt;&amp;bull; &lt;code&gt;DOWNLOAD_FAILED&lt;/code&gt; means that the account data could not get successfully imported or updated. Possible reasons: finAPI could not get the account&#39;s balance, or it could not parse all transactions/securities, or some internal error has occurred. Also, it could mean that finAPI could not even get to the point of receiving the account data from the bank server, for example because of incorrect login credentials or a network problem. Note however that when we get a balance and just an empty list of transactions or securities, then this is regarded as valid and successful download. The reason for this is that for some accounts that have little activity, we may actually get no recent transactions but only a balance.&lt;br/&gt;&amp;bull; &lt;code&gt;DEPRECATED&lt;/code&gt; means that the account could no longer get matched with any account from the bank server. This can mean either that the account was terminated by the user and is no longer sent by the bank server, or that finAPI could no longer match it because the account&#39;s data (name, type, iban, account number, etc.) has been changed by the bank.
   * @return status
  **/
  @ApiModelProperty(required = true, value = "The current status of the account. Possible values are:<br/>&bull; <code>UPDATED</code> means that the account is up to date from finAPI's point of view. This means that no current import/update is running, and the previous import/update could successfully update the account's data (e.g. transactions and securities), and the bank given balance matched the transaction's calculated sum, meaning that no adjusting entry ('Zwischensaldo' transaction) was inserted.<br/>&bull; <code>UPDATED_FIXED</code> means that the account is up to date from finAPI's point of view (no current import/update is running, and the previous import/update could successfully update the account's data), BUT there was a deviation in the bank given balance which was fixed by adding an adjusting entry ('Zwischensaldo' transaction).<br/>&bull; <code>DOWNLOAD_IN_PROGRESS</code> means that the account's data is currently being imported/updated.<br/>&bull; <code>DOWNLOAD_FAILED</code> means that the account data could not get successfully imported or updated. Possible reasons: finAPI could not get the account's balance, or it could not parse all transactions/securities, or some internal error has occurred. Also, it could mean that finAPI could not even get to the point of receiving the account data from the bank server, for example because of incorrect login credentials or a network problem. Note however that when we get a balance and just an empty list of transactions or securities, then this is regarded as valid and successful download. The reason for this is that for some accounts that have little activity, we may actually get no recent transactions but only a balance.<br/>&bull; <code>DEPRECATED</code> means that the account could no longer get matched with any account from the bank server. This can mean either that the account was terminated by the user and is no longer sent by the bank server, or that finAPI could no longer match it because the account's data (name, type, iban, account number, etc.) has been changed by the bank.")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public Account supportedOrders(List<SupportedOrdersEnum> supportedOrders) {
    this.supportedOrders = supportedOrders;
    return this;
  }

  public Account addSupportedOrdersItem(SupportedOrdersEnum supportedOrdersItem) {
    this.supportedOrders.add(supportedOrdersItem);
    return this;
  }

   /**
   * List of orders that this account supports. Possible values are:&lt;br/&gt;&lt;br/&gt;&amp;bull; &lt;code&gt;SEPA_MONEY_TRANSFER&lt;/code&gt; - single money transfer&lt;br/&gt;&amp;bull; &lt;code&gt;SEPA_COLLECTIVE_MONEY_TRANSFER&lt;/code&gt; - collective money transfer&lt;br/&gt;&amp;bull; &lt;code&gt;SEPA_BASIC_DIRECT_DEBIT&lt;/code&gt; - single basic direct debit&lt;br/&gt;&amp;bull; &lt;code&gt;SEPA_BASIC_COLLECTIVE_DIRECT_DEBIT&lt;/code&gt; - collective basic direct debit&lt;br/&gt;&amp;bull; &lt;code&gt;SEPA_B2B_DIRECT_DEBIT&lt;/code&gt; - single Business-To-Business direct debit&lt;br/&gt;&amp;bull; &lt;code&gt;SEPA_B2B_COLLECTIVE_DIRECT_DEBIT&lt;/code&gt; - collective Business-To-Business direct debit&lt;br/&gt;&lt;br/&gt;Note that this list may be empty if the account is not supporting any of the above orders. Also note that the list is refreshed each time the account is being updated, so available orders may get added or removed in the course of an account update.&lt;br/&gt;&lt;br/&gt;
   * @return supportedOrders
  **/
  @ApiModelProperty(required = true, value = "List of orders that this account supports. Possible values are:<br/><br/>&bull; <code>SEPA_MONEY_TRANSFER</code> - single money transfer<br/>&bull; <code>SEPA_COLLECTIVE_MONEY_TRANSFER</code> - collective money transfer<br/>&bull; <code>SEPA_BASIC_DIRECT_DEBIT</code> - single basic direct debit<br/>&bull; <code>SEPA_BASIC_COLLECTIVE_DIRECT_DEBIT</code> - collective basic direct debit<br/>&bull; <code>SEPA_B2B_DIRECT_DEBIT</code> - single Business-To-Business direct debit<br/>&bull; <code>SEPA_B2B_COLLECTIVE_DIRECT_DEBIT</code> - collective Business-To-Business direct debit<br/><br/>Note that this list may be empty if the account is not supporting any of the above orders. Also note that the list is refreshed each time the account is being updated, so available orders may get added or removed in the course of an account update.<br/><br/>")
  public List<SupportedOrdersEnum> getSupportedOrders() {
    return supportedOrders;
  }

  public void setSupportedOrders(List<SupportedOrdersEnum> supportedOrders) {
    this.supportedOrders = supportedOrders;
  }

  public Account clearingAccounts(List<ClearingAccountData> clearingAccounts) {
    this.clearingAccounts = clearingAccounts;
    return this;
  }

  public Account addClearingAccountsItem(ClearingAccountData clearingAccountsItem) {
    if (this.clearingAccounts == null) {
      this.clearingAccounts = new ArrayList<ClearingAccountData>();
    }
    this.clearingAccounts.add(clearingAccountsItem);
    return this;
  }

   /**
   * List of clearing accounts that relate to this account. Clearing accounts can be used for money transfers (see field &#39;clearingAccountId&#39; of the &#39;Request SEPA Money Transfer&#39; service).
   * @return clearingAccounts
  **/
  @ApiModelProperty(value = "List of clearing accounts that relate to this account. Clearing accounts can be used for money transfers (see field 'clearingAccountId' of the 'Request SEPA Money Transfer' service).")
  public List<ClearingAccountData> getClearingAccounts() {
    return clearingAccounts;
  }

  public void setClearingAccounts(List<ClearingAccountData> clearingAccounts) {
    this.clearingAccounts = clearingAccounts;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Account account = (Account) o;
    return Objects.equals(this.id, account.id) &&
        Objects.equals(this.bankConnectionId, account.bankConnectionId) &&
        Objects.equals(this.accountName, account.accountName) &&
        Objects.equals(this.accountNumber, account.accountNumber) &&
        Objects.equals(this.subAccountNumber, account.subAccountNumber) &&
        Objects.equals(this.iban, account.iban) &&
        Objects.equals(this.accountHolderName, account.accountHolderName) &&
        Objects.equals(this.accountHolderId, account.accountHolderId) &&
        Objects.equals(this.accountCurrency, account.accountCurrency) &&
        Objects.equals(this.accountTypeId, account.accountTypeId) &&
        Objects.equals(this.accountTypeName, account.accountTypeName) &&
        Objects.equals(this.balance, account.balance) &&
        Objects.equals(this.overdraft, account.overdraft) &&
        Objects.equals(this.overdraftLimit, account.overdraftLimit) &&
        Objects.equals(this.availableFunds, account.availableFunds) &&
        Objects.equals(this.lastSuccessfulUpdate, account.lastSuccessfulUpdate) &&
        Objects.equals(this.lastUpdateAttempt, account.lastUpdateAttempt) &&
        Objects.equals(this.isNew, account.isNew) &&
        Objects.equals(this.status, account.status) &&
        Objects.equals(this.supportedOrders, account.supportedOrders) &&
        Objects.equals(this.clearingAccounts, account.clearingAccounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, bankConnectionId, accountName, accountNumber, subAccountNumber, iban, accountHolderName, accountHolderId, accountCurrency, accountTypeId, accountTypeName, balance, overdraft, overdraftLimit, availableFunds, lastSuccessfulUpdate, lastUpdateAttempt, isNew, status, supportedOrders, clearingAccounts);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Account {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    bankConnectionId: ").append(toIndentedString(bankConnectionId)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    subAccountNumber: ").append(toIndentedString(subAccountNumber)).append("\n");
    sb.append("    iban: ").append(toIndentedString(iban)).append("\n");
    sb.append("    accountHolderName: ").append(toIndentedString(accountHolderName)).append("\n");
    sb.append("    accountHolderId: ").append(toIndentedString(accountHolderId)).append("\n");
    sb.append("    accountCurrency: ").append(toIndentedString(accountCurrency)).append("\n");
    sb.append("    accountTypeId: ").append(toIndentedString(accountTypeId)).append("\n");
    sb.append("    accountTypeName: ").append(toIndentedString(accountTypeName)).append("\n");
    sb.append("    balance: ").append(toIndentedString(balance)).append("\n");
    sb.append("    overdraft: ").append(toIndentedString(overdraft)).append("\n");
    sb.append("    overdraftLimit: ").append(toIndentedString(overdraftLimit)).append("\n");
    sb.append("    availableFunds: ").append(toIndentedString(availableFunds)).append("\n");
    sb.append("    lastSuccessfulUpdate: ").append(toIndentedString(lastSuccessfulUpdate)).append("\n");
    sb.append("    lastUpdateAttempt: ").append(toIndentedString(lastUpdateAttempt)).append("\n");
    sb.append("    isNew: ").append(toIndentedString(isNew)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    supportedOrders: ").append(toIndentedString(supportedOrders)).append("\n");
    sb.append("    clearingAccounts: ").append(toIndentedString(clearingAccounts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

