/*
 * finAPI RESTful Services
 * finAPI RESTful Services
 *
 * OpenAPI spec version: v1.46.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.BadCredentialsError;
import java.math.BigDecimal;
import io.swagger.client.model.ErrorMessage;
import io.swagger.client.model.IdentifierList;
import io.swagger.client.model.PageableTransactionList;
import io.swagger.client.model.SplitTransactionsParams;
import io.swagger.client.model.Transaction;
import io.swagger.client.model.TransactionList;
import io.swagger.client.model.TriggerCategorizationParams;
import io.swagger.client.model.UpdateMultipleTransactionsParams;
import io.swagger.client.model.UpdateTransactionsParams;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionsApi {
    private ApiClient apiClient;

    public TransactionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deleteAllTransactions
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteAllTransactionsCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/transactions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteAllTransactionsValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = deleteAllTransactionsCall(progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete all transactions
     * Delete all deletable transactions of the currently authorized user. &lt;br/&gt;A transaction is deletable if at least one of the following holds true:&lt;br/&gt; &amp;bull; The transaction belongs to a demo account &lt;br/&gt; &amp;bull; The transaction&#39;s &#39;potentialDuplicate&#39; flag is set to TRUE&lt;br/&gt; &amp;bull; The transaction is an adjusting entry (&#39;Zwischensaldo&#39; transaction) that was added by finAPI
     * @return IdentifierList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public IdentifierList deleteAllTransactions() throws ApiException {
        ApiResponse<IdentifierList> resp = deleteAllTransactionsWithHttpInfo();
        return resp.getData();
    }

    /**
     * Delete all transactions
     * Delete all deletable transactions of the currently authorized user. &lt;br/&gt;A transaction is deletable if at least one of the following holds true:&lt;br/&gt; &amp;bull; The transaction belongs to a demo account &lt;br/&gt; &amp;bull; The transaction&#39;s &#39;potentialDuplicate&#39; flag is set to TRUE&lt;br/&gt; &amp;bull; The transaction is an adjusting entry (&#39;Zwischensaldo&#39; transaction) that was added by finAPI
     * @return ApiResponse&lt;IdentifierList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<IdentifierList> deleteAllTransactionsWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = deleteAllTransactionsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete all transactions (asynchronously)
     * Delete all deletable transactions of the currently authorized user. &lt;br/&gt;A transaction is deletable if at least one of the following holds true:&lt;br/&gt; &amp;bull; The transaction belongs to a demo account &lt;br/&gt; &amp;bull; The transaction&#39;s &#39;potentialDuplicate&#39; flag is set to TRUE&lt;br/&gt; &amp;bull; The transaction is an adjusting entry (&#39;Zwischensaldo&#39; transaction) that was added by finAPI
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteAllTransactionsAsync(final ApiCallback<IdentifierList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteAllTransactionsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteTransaction
     * @param id Identifier of transaction (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteTransactionCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/transactions/{id}"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteTransactionValidateBeforeCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteTransaction(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteTransactionCall(id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a transaction
     * Delete a single transaction of the user that is authorized by the access_token.  A transaction can only get deleted if at least one of the following holds true:&lt;br/&gt; &amp;bull; The transaction belongs to a demo account &lt;br/&gt; &amp;bull; The transaction&#39;s &#39;potentialDuplicate&#39; flag is set to TRUE&lt;br/&gt; &amp;bull; The transaction is an adjusting entry (&#39;Zwischensaldo&#39; transaction) that was added by finAPI
     * @param id Identifier of transaction (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteTransaction(Long id) throws ApiException {
        deleteTransactionWithHttpInfo(id);
    }

    /**
     * Delete a transaction
     * Delete a single transaction of the user that is authorized by the access_token.  A transaction can only get deleted if at least one of the following holds true:&lt;br/&gt; &amp;bull; The transaction belongs to a demo account &lt;br/&gt; &amp;bull; The transaction&#39;s &#39;potentialDuplicate&#39; flag is set to TRUE&lt;br/&gt; &amp;bull; The transaction is an adjusting entry (&#39;Zwischensaldo&#39; transaction) that was added by finAPI
     * @param id Identifier of transaction (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteTransactionWithHttpInfo(Long id) throws ApiException {
        com.squareup.okhttp.Call call = deleteTransactionValidateBeforeCall(id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a transaction (asynchronously)
     * Delete a single transaction of the user that is authorized by the access_token.  A transaction can only get deleted if at least one of the following holds true:&lt;br/&gt; &amp;bull; The transaction belongs to a demo account &lt;br/&gt; &amp;bull; The transaction&#39;s &#39;potentialDuplicate&#39; flag is set to TRUE&lt;br/&gt; &amp;bull; The transaction is an adjusting entry (&#39;Zwischensaldo&#39; transaction) that was added by finAPI
     * @param id Identifier of transaction (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteTransactionAsync(Long id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteTransactionValidateBeforeCall(id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for editMultipleTransactions
     * @param body Update transactions parameters (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call editMultipleTransactionsCall(UpdateMultipleTransactionsParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/api/v1/transactions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call editMultipleTransactionsValidateBeforeCall(UpdateMultipleTransactionsParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling editMultipleTransactions(Async)");
        }
        

        com.squareup.okhttp.Call call = editMultipleTransactionsCall(body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Edit multiple transactions
     * Edit one or multiple transactions. You can edit the following fields: &#39;isNew&#x3D;true|false&#39; and/or &#39;isPotentialDuplicate&#x3D;false&#39; and/or &#39;categoryId&#x3D;&lt;id&gt;&#39; and/or &#39;labelIds&#x3D;[&lt;ids&gt;]&#39;. To clear the category of the given transactions (so that they are no longer categorized), pass the value &#39;0&#39; as the categoryId. To clear the labels of the given transactions, pass an empty array of label identifiers: &#39;[]&#39;. The parameters &#39;categoryId&#39; and &#39;labelIds&#39; are forbidden if &#39;ids&#39; is NOT set (i.e. you cannot update the category or labels for ALL transactions). The result is a list of identifiers of only those transactions that have changed as a result of this service call.
     * @param body Update transactions parameters (required)
     * @return IdentifierList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public IdentifierList editMultipleTransactions(UpdateMultipleTransactionsParams body) throws ApiException {
        ApiResponse<IdentifierList> resp = editMultipleTransactionsWithHttpInfo(body);
        return resp.getData();
    }

    /**
     * Edit multiple transactions
     * Edit one or multiple transactions. You can edit the following fields: &#39;isNew&#x3D;true|false&#39; and/or &#39;isPotentialDuplicate&#x3D;false&#39; and/or &#39;categoryId&#x3D;&lt;id&gt;&#39; and/or &#39;labelIds&#x3D;[&lt;ids&gt;]&#39;. To clear the category of the given transactions (so that they are no longer categorized), pass the value &#39;0&#39; as the categoryId. To clear the labels of the given transactions, pass an empty array of label identifiers: &#39;[]&#39;. The parameters &#39;categoryId&#39; and &#39;labelIds&#39; are forbidden if &#39;ids&#39; is NOT set (i.e. you cannot update the category or labels for ALL transactions). The result is a list of identifiers of only those transactions that have changed as a result of this service call.
     * @param body Update transactions parameters (required)
     * @return ApiResponse&lt;IdentifierList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<IdentifierList> editMultipleTransactionsWithHttpInfo(UpdateMultipleTransactionsParams body) throws ApiException {
        com.squareup.okhttp.Call call = editMultipleTransactionsValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit multiple transactions (asynchronously)
     * Edit one or multiple transactions. You can edit the following fields: &#39;isNew&#x3D;true|false&#39; and/or &#39;isPotentialDuplicate&#x3D;false&#39; and/or &#39;categoryId&#x3D;&lt;id&gt;&#39; and/or &#39;labelIds&#x3D;[&lt;ids&gt;]&#39;. To clear the category of the given transactions (so that they are no longer categorized), pass the value &#39;0&#39; as the categoryId. To clear the labels of the given transactions, pass an empty array of label identifiers: &#39;[]&#39;. The parameters &#39;categoryId&#39; and &#39;labelIds&#39; are forbidden if &#39;ids&#39; is NOT set (i.e. you cannot update the category or labels for ALL transactions). The result is a list of identifiers of only those transactions that have changed as a result of this service call.
     * @param body Update transactions parameters (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call editMultipleTransactionsAsync(UpdateMultipleTransactionsParams body, final ApiCallback<IdentifierList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = editMultipleTransactionsValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for editMultipleTransactionsDeprecated
     * @param ids Comma-separated list of identifiers of updated transactions (required)
     * @param body Update transactions parameters (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call editMultipleTransactionsDeprecatedCall(List<Long> ids, UpdateTransactionsParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/api/v1/transactions/{ids}"
            .replaceAll("\\{" + "ids" + "\\}", apiClient.escapeString(ids.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call editMultipleTransactionsDeprecatedValidateBeforeCall(List<Long> ids, UpdateTransactionsParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'ids' is set
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling editMultipleTransactionsDeprecated(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling editMultipleTransactionsDeprecated(Async)");
        }
        

        com.squareup.okhttp.Call call = editMultipleTransactionsDeprecatedCall(ids, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Edit multiple transactions (DEPRECATED)
     * Change the fields of multiple transactions. You can change the following fields: &#39;isNew&#x3D;true|false&#39; and/or &#39;isPotentialDuplicate&#x3D;false&#39; and/or &#39;categoryId&#x3D;&lt;id&gt;&#39; and/or &#39;labelIds&#x3D;[&lt;ids&gt;]&#39;. The max number of input identifiers is limited to 100. To clear the category of the given transactions (so that they are no longer categorized), pass the value &#39;0&#39; as the categoryId. To clear the labels of the given transactions, pass an empty array of label identifiers: &#39;[]&#39;. The result is a list of identifiers of only those transactions that have changed as a result of this service call. WARNING: This service is deprecated and will be removed at some point. If you want to edit multiple transactions, please instead use the service &#39;Edit multiple transactions&#39;, where you can pass a comma-separated list of identifiers .
     * @param ids Comma-separated list of identifiers of updated transactions (required)
     * @param body Update transactions parameters (required)
     * @return IdentifierList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public IdentifierList editMultipleTransactionsDeprecated(List<Long> ids, UpdateTransactionsParams body) throws ApiException {
        ApiResponse<IdentifierList> resp = editMultipleTransactionsDeprecatedWithHttpInfo(ids, body);
        return resp.getData();
    }

    /**
     * Edit multiple transactions (DEPRECATED)
     * Change the fields of multiple transactions. You can change the following fields: &#39;isNew&#x3D;true|false&#39; and/or &#39;isPotentialDuplicate&#x3D;false&#39; and/or &#39;categoryId&#x3D;&lt;id&gt;&#39; and/or &#39;labelIds&#x3D;[&lt;ids&gt;]&#39;. The max number of input identifiers is limited to 100. To clear the category of the given transactions (so that they are no longer categorized), pass the value &#39;0&#39; as the categoryId. To clear the labels of the given transactions, pass an empty array of label identifiers: &#39;[]&#39;. The result is a list of identifiers of only those transactions that have changed as a result of this service call. WARNING: This service is deprecated and will be removed at some point. If you want to edit multiple transactions, please instead use the service &#39;Edit multiple transactions&#39;, where you can pass a comma-separated list of identifiers .
     * @param ids Comma-separated list of identifiers of updated transactions (required)
     * @param body Update transactions parameters (required)
     * @return ApiResponse&lt;IdentifierList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public ApiResponse<IdentifierList> editMultipleTransactionsDeprecatedWithHttpInfo(List<Long> ids, UpdateTransactionsParams body) throws ApiException {
        com.squareup.okhttp.Call call = editMultipleTransactionsDeprecatedValidateBeforeCall(ids, body, null, null);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit multiple transactions (DEPRECATED) (asynchronously)
     * Change the fields of multiple transactions. You can change the following fields: &#39;isNew&#x3D;true|false&#39; and/or &#39;isPotentialDuplicate&#x3D;false&#39; and/or &#39;categoryId&#x3D;&lt;id&gt;&#39; and/or &#39;labelIds&#x3D;[&lt;ids&gt;]&#39;. The max number of input identifiers is limited to 100. To clear the category of the given transactions (so that they are no longer categorized), pass the value &#39;0&#39; as the categoryId. To clear the labels of the given transactions, pass an empty array of label identifiers: &#39;[]&#39;. The result is a list of identifiers of only those transactions that have changed as a result of this service call. WARNING: This service is deprecated and will be removed at some point. If you want to edit multiple transactions, please instead use the service &#39;Edit multiple transactions&#39;, where you can pass a comma-separated list of identifiers .
     * @param ids Comma-separated list of identifiers of updated transactions (required)
     * @param body Update transactions parameters (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call editMultipleTransactionsDeprecatedAsync(List<Long> ids, UpdateTransactionsParams body, final ApiCallback<IdentifierList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = editMultipleTransactionsDeprecatedValidateBeforeCall(ids, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for editTransaction
     * @param id Identifier of transaction (required)
     * @param body Update transactions parameters (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call editTransactionCall(Long id, UpdateTransactionsParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/api/v1/transactions/{id}"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call editTransactionValidateBeforeCall(Long id, UpdateTransactionsParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling editTransaction(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling editTransaction(Async)");
        }
        

        com.squareup.okhttp.Call call = editTransactionCall(id, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Edit a transaction
     * Change a transaction&#39;s fields. You can change the following fields: &#39;isNew&#x3D;true|false&#39; and/or &#39;isPotentialDuplicate&#x3D;false&#39; and/or &#39;categoryId&#x3D;&lt;id&gt;&#39; and/or &#39;labelIds&#x3D;[&lt;ids&gt;]&#39;. To clear a transaction&#39;s category (so that it is no longer categorized), pass the value &#39;0&#39; as the categoryId. To clear the labels of the given transaction, pass an empty array of label identifiers: &#39;[]&#39;.
     * @param id Identifier of transaction (required)
     * @param body Update transactions parameters (required)
     * @return Transaction
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Transaction editTransaction(Long id, UpdateTransactionsParams body) throws ApiException {
        ApiResponse<Transaction> resp = editTransactionWithHttpInfo(id, body);
        return resp.getData();
    }

    /**
     * Edit a transaction
     * Change a transaction&#39;s fields. You can change the following fields: &#39;isNew&#x3D;true|false&#39; and/or &#39;isPotentialDuplicate&#x3D;false&#39; and/or &#39;categoryId&#x3D;&lt;id&gt;&#39; and/or &#39;labelIds&#x3D;[&lt;ids&gt;]&#39;. To clear a transaction&#39;s category (so that it is no longer categorized), pass the value &#39;0&#39; as the categoryId. To clear the labels of the given transaction, pass an empty array of label identifiers: &#39;[]&#39;.
     * @param id Identifier of transaction (required)
     * @param body Update transactions parameters (required)
     * @return ApiResponse&lt;Transaction&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Transaction> editTransactionWithHttpInfo(Long id, UpdateTransactionsParams body) throws ApiException {
        com.squareup.okhttp.Call call = editTransactionValidateBeforeCall(id, body, null, null);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit a transaction (asynchronously)
     * Change a transaction&#39;s fields. You can change the following fields: &#39;isNew&#x3D;true|false&#39; and/or &#39;isPotentialDuplicate&#x3D;false&#39; and/or &#39;categoryId&#x3D;&lt;id&gt;&#39; and/or &#39;labelIds&#x3D;[&lt;ids&gt;]&#39;. To clear a transaction&#39;s category (so that it is no longer categorized), pass the value &#39;0&#39; as the categoryId. To clear the labels of the given transaction, pass an empty array of label identifiers: &#39;[]&#39;.
     * @param id Identifier of transaction (required)
     * @param body Update transactions parameters (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call editTransactionAsync(Long id, UpdateTransactionsParams body, final ApiCallback<Transaction> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = editTransactionValidateBeforeCall(id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAndSearchAllTransactions
     * @param view This parameter defines finAPI&#39;s logical view on the transactions when querying them: &#39;bankView&#39; regards only the original transactions as they were received from the bank, without considering how the transactions might have gotten split by the user (see POST /transactions/&lt;id&gt;/split). This means that if a transaction is split into logical sub-transactions, then the service will still regard only the original transaction, and NOT the logical sub-transactions in its processing (though for convenience, the transactions will have the data of their sub-transactions included in the response). &#39;userView&#39; by contrast regards the transactions as they exist for the user. For transactions that have not been split into logical sub-transactions, there is no difference to the \&quot;bankView\&quot;. But for transaction that have been split into logical sub-transactions, the service will ONLY regard these sub-transactions, and not the originally received transaction (though for convenience, the sub-transactions will have the identifier of their original transaction included in the response). (required)
     * @param ids A comma-separated list of transaction identifiers. If specified, then only transactions whose identifier match any of the given identifiers will be regarded. The maximum number of identifiers is 1000. (optional)
     * @param search If specified, then only those transactions will be contained in the result whose &#39;purpose&#39; or counterpart fields contain the given search string (the matching works case-insensitive). If no transactions contain the search string in any of these fields, then the result will be an empty list. NOTE: If the given search string consists of several terms (separated by whitespace), then ALL of these terms must be contained in the searched fields in order for a transaction to get included into the result. (optional)
     * @param counterpart If specified, then only those transactions will be contained in the result whose counterpart fields contain the given search string (the matching works case-insensitive). If no transactions contain the search string in any of the counterpart fields, then the result will be an empty list. NOTE: If the given search string consists of several terms (separated by whitespace), then ALL of these terms must be contained in the searched fields in order for a transaction to get included into the result. (optional)
     * @param accountIds A comma-separated list of account identifiers. If specified, then only transactions that relate to the given accounts will be regarded. If not specified, then all accounts will be regarded. (optional)
     * @param minBankBookingDate Lower bound for a transaction&#39;s booking date as returned by the bank (&#x3D; original booking date), in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;bankBookingDate&#39; is equal to or later than the given date will be regarded. (optional)
     * @param maxBankBookingDate Upper bound for a transaction&#39;s booking date as returned by the bank (&#x3D; original booking date), in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;bankBookingDate&#39; is equal to or earlier than the given date will be regarded. (optional)
     * @param minFinapiBookingDate Lower bound for a transaction&#39;s booking date as set by finAPI, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). For details about the meaning of the finAPI booking date, please see the field&#39;s documentation in the service&#39;s response. (optional)
     * @param maxFinapiBookingDate Upper bound for a transaction&#39;s booking date as set by finAPI, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). For details about the meaning of the finAPI booking date, please see the field&#39;s documentation in the service&#39;s response. (optional)
     * @param minAmount If specified, then only transactions whose amount is equal to or greater than the given amount will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param maxAmount If specified, then only transactions whose amount is equal to or less than the given amount will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param direction If specified, then only transactions with the given direction(s) will be regarded. Use &#39;income&#39; for regarding only received payments (amount &gt;&#x3D; 0), &#39;spending&#39; for regarding only outgoing payments (amount &lt; 0), or &#39;all&#39; to regard both directions. If not specified, the direction defaults to &#39;all&#39;. (optional, default to all)
     * @param labelIds A comma-separated list of label identifiers. If specified, then only transactions that have been marked with at least one of the given labels will be contained in the result. (optional)
     * @param categoryIds A comma-separated list of category identifiers. If specified, then the result will contain only transactions whose category is either one of the given categories, or - but only if the &#39;includeChildCategories&#39; flag is set to &#39;true&#39; - whose category is a sub-category of one of the given categories. To include transactions without any category, pass the value &#39;0&#39; as the categoryId. (optional)
     * @param includeChildCategories This flag controls how the given &#39;categoryIds&#39; are handled. If set to &#39;true&#39;, then all transactions of a given categoryId, as well as all transactions of any of its sub-categories will be regarded. If set to &#39;false&#39;, then sub-categories of a given categoryId will not be regarded and only those transactions are regarded whose category matches one of the explicitly given categoryIds. The default value for this flag is &#39;true&#39;. (optional, default to true)
     * @param isNew If specified, then only transactions that have their &#39;isNew&#39; flag set to true/false will be regarded. (optional)
     * @param isPotentialDuplicate If specified, then only transactions that have their &#39;isPotentialDuplicate&#39; flag set to true/false will be regarded. (optional)
     * @param isAdjustingEntry If specified, then only transactions that have their &#39;isAdjustingEntry&#39; flag set to true/false will be regarded. (optional)
     * @param minImportDate Lower bound for a transaction&#39;s import date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;importDate&#39; is equal to or later than the given date will be regarded. (optional)
     * @param maxImportDate Upper bound for a transaction&#39;s import date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;importDate&#39; is equal to or earlier than the given date will be regarded. (optional)
     * @param page Result page that you want to retrieve. (optional, default to 1)
     * @param perPage Maximum number of records per page. Can be at most 500. NOTE: Due to its validation and visualization, the swagger frontend might show very low performance, or even crashes, when a service responds with a lot of data. It is recommended to use a HTTP client like Postman or DHC instead of our swagger frontend for service calls with large page sizes. (optional, default to 20)
     * @param order Determines the order of the results. You can use the following fields for ordering the response: &#39;id&#39;, &#39;parentId&#39;, &#39;accountId&#39;, &#39;valueDate&#39;, &#39;bankBookingDate&#39;, &#39;finapiBookingDate&#39;, &#39;amount&#39;, &#39;purpose&#39;, &#39;counterpartName&#39;, &#39;counterpartAccountNumber&#39;, &#39;counterpartIban&#39;, &#39;counterpartBlz&#39;, &#39;counterpartBic&#39;, &#39;type&#39;, &#39;primanota&#39;, &#39;category.id&#39;, &#39;category.name&#39;, &#39;isPotentialDuplicate&#39;, &#39;isNew&#39; and &#39;importDate&#39;. The default order for all services is &#39;id,asc&#39;. You can also order by multiple properties. In that case the order of the parameters passed is important. Example: &#39;/transactions?order&#x3D;finapiBookingDate,desc&amp;order&#x3D;counterpartName&#39; will return the latest transactions first. If there are more transactions on the same day, then these transactions are ordered by the counterpart name (ascending). The general format is: &#39;property[,asc|desc]&#39;, with &#39;asc&#39; being the default value. Please note that ordering by multiple fields is not supported in our swagger frontend, but you can test this feature with any HTTP tool of your choice (e.g. postman or DHC).  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAndSearchAllTransactionsCall(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, Boolean isAdjustingEntry, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/transactions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ids != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "ids", ids));
        if (view != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("view", view));
        if (search != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("search", search));
        if (counterpart != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("counterpart", counterpart));
        if (accountIds != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "accountIds", accountIds));
        if (minBankBookingDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("minBankBookingDate", minBankBookingDate));
        if (maxBankBookingDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("maxBankBookingDate", maxBankBookingDate));
        if (minFinapiBookingDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("minFinapiBookingDate", minFinapiBookingDate));
        if (maxFinapiBookingDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("maxFinapiBookingDate", maxFinapiBookingDate));
        if (minAmount != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("minAmount", minAmount));
        if (maxAmount != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("maxAmount", maxAmount));
        if (direction != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("direction", direction));
        if (labelIds != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "labelIds", labelIds));
        if (categoryIds != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "categoryIds", categoryIds));
        if (includeChildCategories != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("includeChildCategories", includeChildCategories));
        if (isNew != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("isNew", isNew));
        if (isPotentialDuplicate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("isPotentialDuplicate", isPotentialDuplicate));
        if (isAdjustingEntry != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("isAdjustingEntry", isAdjustingEntry));
        if (minImportDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("minImportDate", minImportDate));
        if (maxImportDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("maxImportDate", maxImportDate));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (perPage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("perPage", perPage));
        if (order != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "order", order));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAndSearchAllTransactionsValidateBeforeCall(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, Boolean isAdjustingEntry, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'view' is set
        if (view == null) {
            throw new ApiException("Missing the required parameter 'view' when calling getAndSearchAllTransactions(Async)");
        }
        

        com.squareup.okhttp.Call call = getAndSearchAllTransactionsCall(view, ids, search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, includeChildCategories, isNew, isPotentialDuplicate, isAdjustingEntry, minImportDate, maxImportDate, page, perPage, order, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get and search all transactions
     * Get transactions of the user that is authorized by the access_token. Must pass the user&#39;s access_token. You can set optional search criteria to get only those transactions that you are interested in. If you do not specify any search criteria, then this service functions as a &#39;get all&#39; service.
     * @param view This parameter defines finAPI&#39;s logical view on the transactions when querying them: &#39;bankView&#39; regards only the original transactions as they were received from the bank, without considering how the transactions might have gotten split by the user (see POST /transactions/&lt;id&gt;/split). This means that if a transaction is split into logical sub-transactions, then the service will still regard only the original transaction, and NOT the logical sub-transactions in its processing (though for convenience, the transactions will have the data of their sub-transactions included in the response). &#39;userView&#39; by contrast regards the transactions as they exist for the user. For transactions that have not been split into logical sub-transactions, there is no difference to the \&quot;bankView\&quot;. But for transaction that have been split into logical sub-transactions, the service will ONLY regard these sub-transactions, and not the originally received transaction (though for convenience, the sub-transactions will have the identifier of their original transaction included in the response). (required)
     * @param ids A comma-separated list of transaction identifiers. If specified, then only transactions whose identifier match any of the given identifiers will be regarded. The maximum number of identifiers is 1000. (optional)
     * @param search If specified, then only those transactions will be contained in the result whose &#39;purpose&#39; or counterpart fields contain the given search string (the matching works case-insensitive). If no transactions contain the search string in any of these fields, then the result will be an empty list. NOTE: If the given search string consists of several terms (separated by whitespace), then ALL of these terms must be contained in the searched fields in order for a transaction to get included into the result. (optional)
     * @param counterpart If specified, then only those transactions will be contained in the result whose counterpart fields contain the given search string (the matching works case-insensitive). If no transactions contain the search string in any of the counterpart fields, then the result will be an empty list. NOTE: If the given search string consists of several terms (separated by whitespace), then ALL of these terms must be contained in the searched fields in order for a transaction to get included into the result. (optional)
     * @param accountIds A comma-separated list of account identifiers. If specified, then only transactions that relate to the given accounts will be regarded. If not specified, then all accounts will be regarded. (optional)
     * @param minBankBookingDate Lower bound for a transaction&#39;s booking date as returned by the bank (&#x3D; original booking date), in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;bankBookingDate&#39; is equal to or later than the given date will be regarded. (optional)
     * @param maxBankBookingDate Upper bound for a transaction&#39;s booking date as returned by the bank (&#x3D; original booking date), in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;bankBookingDate&#39; is equal to or earlier than the given date will be regarded. (optional)
     * @param minFinapiBookingDate Lower bound for a transaction&#39;s booking date as set by finAPI, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). For details about the meaning of the finAPI booking date, please see the field&#39;s documentation in the service&#39;s response. (optional)
     * @param maxFinapiBookingDate Upper bound for a transaction&#39;s booking date as set by finAPI, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). For details about the meaning of the finAPI booking date, please see the field&#39;s documentation in the service&#39;s response. (optional)
     * @param minAmount If specified, then only transactions whose amount is equal to or greater than the given amount will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param maxAmount If specified, then only transactions whose amount is equal to or less than the given amount will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param direction If specified, then only transactions with the given direction(s) will be regarded. Use &#39;income&#39; for regarding only received payments (amount &gt;&#x3D; 0), &#39;spending&#39; for regarding only outgoing payments (amount &lt; 0), or &#39;all&#39; to regard both directions. If not specified, the direction defaults to &#39;all&#39;. (optional, default to all)
     * @param labelIds A comma-separated list of label identifiers. If specified, then only transactions that have been marked with at least one of the given labels will be contained in the result. (optional)
     * @param categoryIds A comma-separated list of category identifiers. If specified, then the result will contain only transactions whose category is either one of the given categories, or - but only if the &#39;includeChildCategories&#39; flag is set to &#39;true&#39; - whose category is a sub-category of one of the given categories. To include transactions without any category, pass the value &#39;0&#39; as the categoryId. (optional)
     * @param includeChildCategories This flag controls how the given &#39;categoryIds&#39; are handled. If set to &#39;true&#39;, then all transactions of a given categoryId, as well as all transactions of any of its sub-categories will be regarded. If set to &#39;false&#39;, then sub-categories of a given categoryId will not be regarded and only those transactions are regarded whose category matches one of the explicitly given categoryIds. The default value for this flag is &#39;true&#39;. (optional, default to true)
     * @param isNew If specified, then only transactions that have their &#39;isNew&#39; flag set to true/false will be regarded. (optional)
     * @param isPotentialDuplicate If specified, then only transactions that have their &#39;isPotentialDuplicate&#39; flag set to true/false will be regarded. (optional)
     * @param isAdjustingEntry If specified, then only transactions that have their &#39;isAdjustingEntry&#39; flag set to true/false will be regarded. (optional)
     * @param minImportDate Lower bound for a transaction&#39;s import date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;importDate&#39; is equal to or later than the given date will be regarded. (optional)
     * @param maxImportDate Upper bound for a transaction&#39;s import date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;importDate&#39; is equal to or earlier than the given date will be regarded. (optional)
     * @param page Result page that you want to retrieve. (optional, default to 1)
     * @param perPage Maximum number of records per page. Can be at most 500. NOTE: Due to its validation and visualization, the swagger frontend might show very low performance, or even crashes, when a service responds with a lot of data. It is recommended to use a HTTP client like Postman or DHC instead of our swagger frontend for service calls with large page sizes. (optional, default to 20)
     * @param order Determines the order of the results. You can use the following fields for ordering the response: &#39;id&#39;, &#39;parentId&#39;, &#39;accountId&#39;, &#39;valueDate&#39;, &#39;bankBookingDate&#39;, &#39;finapiBookingDate&#39;, &#39;amount&#39;, &#39;purpose&#39;, &#39;counterpartName&#39;, &#39;counterpartAccountNumber&#39;, &#39;counterpartIban&#39;, &#39;counterpartBlz&#39;, &#39;counterpartBic&#39;, &#39;type&#39;, &#39;primanota&#39;, &#39;category.id&#39;, &#39;category.name&#39;, &#39;isPotentialDuplicate&#39;, &#39;isNew&#39; and &#39;importDate&#39;. The default order for all services is &#39;id,asc&#39;. You can also order by multiple properties. In that case the order of the parameters passed is important. Example: &#39;/transactions?order&#x3D;finapiBookingDate,desc&amp;order&#x3D;counterpartName&#39; will return the latest transactions first. If there are more transactions on the same day, then these transactions are ordered by the counterpart name (ascending). The general format is: &#39;property[,asc|desc]&#39;, with &#39;asc&#39; being the default value. Please note that ordering by multiple fields is not supported in our swagger frontend, but you can test this feature with any HTTP tool of your choice (e.g. postman or DHC).  (optional)
     * @return PageableTransactionList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PageableTransactionList getAndSearchAllTransactions(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, Boolean isAdjustingEntry, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order) throws ApiException {
        ApiResponse<PageableTransactionList> resp = getAndSearchAllTransactionsWithHttpInfo(view, ids, search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, includeChildCategories, isNew, isPotentialDuplicate, isAdjustingEntry, minImportDate, maxImportDate, page, perPage, order);
        return resp.getData();
    }

    /**
     * Get and search all transactions
     * Get transactions of the user that is authorized by the access_token. Must pass the user&#39;s access_token. You can set optional search criteria to get only those transactions that you are interested in. If you do not specify any search criteria, then this service functions as a &#39;get all&#39; service.
     * @param view This parameter defines finAPI&#39;s logical view on the transactions when querying them: &#39;bankView&#39; regards only the original transactions as they were received from the bank, without considering how the transactions might have gotten split by the user (see POST /transactions/&lt;id&gt;/split). This means that if a transaction is split into logical sub-transactions, then the service will still regard only the original transaction, and NOT the logical sub-transactions in its processing (though for convenience, the transactions will have the data of their sub-transactions included in the response). &#39;userView&#39; by contrast regards the transactions as they exist for the user. For transactions that have not been split into logical sub-transactions, there is no difference to the \&quot;bankView\&quot;. But for transaction that have been split into logical sub-transactions, the service will ONLY regard these sub-transactions, and not the originally received transaction (though for convenience, the sub-transactions will have the identifier of their original transaction included in the response). (required)
     * @param ids A comma-separated list of transaction identifiers. If specified, then only transactions whose identifier match any of the given identifiers will be regarded. The maximum number of identifiers is 1000. (optional)
     * @param search If specified, then only those transactions will be contained in the result whose &#39;purpose&#39; or counterpart fields contain the given search string (the matching works case-insensitive). If no transactions contain the search string in any of these fields, then the result will be an empty list. NOTE: If the given search string consists of several terms (separated by whitespace), then ALL of these terms must be contained in the searched fields in order for a transaction to get included into the result. (optional)
     * @param counterpart If specified, then only those transactions will be contained in the result whose counterpart fields contain the given search string (the matching works case-insensitive). If no transactions contain the search string in any of the counterpart fields, then the result will be an empty list. NOTE: If the given search string consists of several terms (separated by whitespace), then ALL of these terms must be contained in the searched fields in order for a transaction to get included into the result. (optional)
     * @param accountIds A comma-separated list of account identifiers. If specified, then only transactions that relate to the given accounts will be regarded. If not specified, then all accounts will be regarded. (optional)
     * @param minBankBookingDate Lower bound for a transaction&#39;s booking date as returned by the bank (&#x3D; original booking date), in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;bankBookingDate&#39; is equal to or later than the given date will be regarded. (optional)
     * @param maxBankBookingDate Upper bound for a transaction&#39;s booking date as returned by the bank (&#x3D; original booking date), in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;bankBookingDate&#39; is equal to or earlier than the given date will be regarded. (optional)
     * @param minFinapiBookingDate Lower bound for a transaction&#39;s booking date as set by finAPI, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). For details about the meaning of the finAPI booking date, please see the field&#39;s documentation in the service&#39;s response. (optional)
     * @param maxFinapiBookingDate Upper bound for a transaction&#39;s booking date as set by finAPI, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). For details about the meaning of the finAPI booking date, please see the field&#39;s documentation in the service&#39;s response. (optional)
     * @param minAmount If specified, then only transactions whose amount is equal to or greater than the given amount will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param maxAmount If specified, then only transactions whose amount is equal to or less than the given amount will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param direction If specified, then only transactions with the given direction(s) will be regarded. Use &#39;income&#39; for regarding only received payments (amount &gt;&#x3D; 0), &#39;spending&#39; for regarding only outgoing payments (amount &lt; 0), or &#39;all&#39; to regard both directions. If not specified, the direction defaults to &#39;all&#39;. (optional, default to all)
     * @param labelIds A comma-separated list of label identifiers. If specified, then only transactions that have been marked with at least one of the given labels will be contained in the result. (optional)
     * @param categoryIds A comma-separated list of category identifiers. If specified, then the result will contain only transactions whose category is either one of the given categories, or - but only if the &#39;includeChildCategories&#39; flag is set to &#39;true&#39; - whose category is a sub-category of one of the given categories. To include transactions without any category, pass the value &#39;0&#39; as the categoryId. (optional)
     * @param includeChildCategories This flag controls how the given &#39;categoryIds&#39; are handled. If set to &#39;true&#39;, then all transactions of a given categoryId, as well as all transactions of any of its sub-categories will be regarded. If set to &#39;false&#39;, then sub-categories of a given categoryId will not be regarded and only those transactions are regarded whose category matches one of the explicitly given categoryIds. The default value for this flag is &#39;true&#39;. (optional, default to true)
     * @param isNew If specified, then only transactions that have their &#39;isNew&#39; flag set to true/false will be regarded. (optional)
     * @param isPotentialDuplicate If specified, then only transactions that have their &#39;isPotentialDuplicate&#39; flag set to true/false will be regarded. (optional)
     * @param isAdjustingEntry If specified, then only transactions that have their &#39;isAdjustingEntry&#39; flag set to true/false will be regarded. (optional)
     * @param minImportDate Lower bound for a transaction&#39;s import date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;importDate&#39; is equal to or later than the given date will be regarded. (optional)
     * @param maxImportDate Upper bound for a transaction&#39;s import date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;importDate&#39; is equal to or earlier than the given date will be regarded. (optional)
     * @param page Result page that you want to retrieve. (optional, default to 1)
     * @param perPage Maximum number of records per page. Can be at most 500. NOTE: Due to its validation and visualization, the swagger frontend might show very low performance, or even crashes, when a service responds with a lot of data. It is recommended to use a HTTP client like Postman or DHC instead of our swagger frontend for service calls with large page sizes. (optional, default to 20)
     * @param order Determines the order of the results. You can use the following fields for ordering the response: &#39;id&#39;, &#39;parentId&#39;, &#39;accountId&#39;, &#39;valueDate&#39;, &#39;bankBookingDate&#39;, &#39;finapiBookingDate&#39;, &#39;amount&#39;, &#39;purpose&#39;, &#39;counterpartName&#39;, &#39;counterpartAccountNumber&#39;, &#39;counterpartIban&#39;, &#39;counterpartBlz&#39;, &#39;counterpartBic&#39;, &#39;type&#39;, &#39;primanota&#39;, &#39;category.id&#39;, &#39;category.name&#39;, &#39;isPotentialDuplicate&#39;, &#39;isNew&#39; and &#39;importDate&#39;. The default order for all services is &#39;id,asc&#39;. You can also order by multiple properties. In that case the order of the parameters passed is important. Example: &#39;/transactions?order&#x3D;finapiBookingDate,desc&amp;order&#x3D;counterpartName&#39; will return the latest transactions first. If there are more transactions on the same day, then these transactions are ordered by the counterpart name (ascending). The general format is: &#39;property[,asc|desc]&#39;, with &#39;asc&#39; being the default value. Please note that ordering by multiple fields is not supported in our swagger frontend, but you can test this feature with any HTTP tool of your choice (e.g. postman or DHC).  (optional)
     * @return ApiResponse&lt;PageableTransactionList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PageableTransactionList> getAndSearchAllTransactionsWithHttpInfo(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, Boolean isAdjustingEntry, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order) throws ApiException {
        com.squareup.okhttp.Call call = getAndSearchAllTransactionsValidateBeforeCall(view, ids, search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, includeChildCategories, isNew, isPotentialDuplicate, isAdjustingEntry, minImportDate, maxImportDate, page, perPage, order, null, null);
        Type localVarReturnType = new TypeToken<PageableTransactionList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get and search all transactions (asynchronously)
     * Get transactions of the user that is authorized by the access_token. Must pass the user&#39;s access_token. You can set optional search criteria to get only those transactions that you are interested in. If you do not specify any search criteria, then this service functions as a &#39;get all&#39; service.
     * @param view This parameter defines finAPI&#39;s logical view on the transactions when querying them: &#39;bankView&#39; regards only the original transactions as they were received from the bank, without considering how the transactions might have gotten split by the user (see POST /transactions/&lt;id&gt;/split). This means that if a transaction is split into logical sub-transactions, then the service will still regard only the original transaction, and NOT the logical sub-transactions in its processing (though for convenience, the transactions will have the data of their sub-transactions included in the response). &#39;userView&#39; by contrast regards the transactions as they exist for the user. For transactions that have not been split into logical sub-transactions, there is no difference to the \&quot;bankView\&quot;. But for transaction that have been split into logical sub-transactions, the service will ONLY regard these sub-transactions, and not the originally received transaction (though for convenience, the sub-transactions will have the identifier of their original transaction included in the response). (required)
     * @param ids A comma-separated list of transaction identifiers. If specified, then only transactions whose identifier match any of the given identifiers will be regarded. The maximum number of identifiers is 1000. (optional)
     * @param search If specified, then only those transactions will be contained in the result whose &#39;purpose&#39; or counterpart fields contain the given search string (the matching works case-insensitive). If no transactions contain the search string in any of these fields, then the result will be an empty list. NOTE: If the given search string consists of several terms (separated by whitespace), then ALL of these terms must be contained in the searched fields in order for a transaction to get included into the result. (optional)
     * @param counterpart If specified, then only those transactions will be contained in the result whose counterpart fields contain the given search string (the matching works case-insensitive). If no transactions contain the search string in any of the counterpart fields, then the result will be an empty list. NOTE: If the given search string consists of several terms (separated by whitespace), then ALL of these terms must be contained in the searched fields in order for a transaction to get included into the result. (optional)
     * @param accountIds A comma-separated list of account identifiers. If specified, then only transactions that relate to the given accounts will be regarded. If not specified, then all accounts will be regarded. (optional)
     * @param minBankBookingDate Lower bound for a transaction&#39;s booking date as returned by the bank (&#x3D; original booking date), in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;bankBookingDate&#39; is equal to or later than the given date will be regarded. (optional)
     * @param maxBankBookingDate Upper bound for a transaction&#39;s booking date as returned by the bank (&#x3D; original booking date), in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;bankBookingDate&#39; is equal to or earlier than the given date will be regarded. (optional)
     * @param minFinapiBookingDate Lower bound for a transaction&#39;s booking date as set by finAPI, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). For details about the meaning of the finAPI booking date, please see the field&#39;s documentation in the service&#39;s response. (optional)
     * @param maxFinapiBookingDate Upper bound for a transaction&#39;s booking date as set by finAPI, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). For details about the meaning of the finAPI booking date, please see the field&#39;s documentation in the service&#39;s response. (optional)
     * @param minAmount If specified, then only transactions whose amount is equal to or greater than the given amount will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param maxAmount If specified, then only transactions whose amount is equal to or less than the given amount will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param direction If specified, then only transactions with the given direction(s) will be regarded. Use &#39;income&#39; for regarding only received payments (amount &gt;&#x3D; 0), &#39;spending&#39; for regarding only outgoing payments (amount &lt; 0), or &#39;all&#39; to regard both directions. If not specified, the direction defaults to &#39;all&#39;. (optional, default to all)
     * @param labelIds A comma-separated list of label identifiers. If specified, then only transactions that have been marked with at least one of the given labels will be contained in the result. (optional)
     * @param categoryIds A comma-separated list of category identifiers. If specified, then the result will contain only transactions whose category is either one of the given categories, or - but only if the &#39;includeChildCategories&#39; flag is set to &#39;true&#39; - whose category is a sub-category of one of the given categories. To include transactions without any category, pass the value &#39;0&#39; as the categoryId. (optional)
     * @param includeChildCategories This flag controls how the given &#39;categoryIds&#39; are handled. If set to &#39;true&#39;, then all transactions of a given categoryId, as well as all transactions of any of its sub-categories will be regarded. If set to &#39;false&#39;, then sub-categories of a given categoryId will not be regarded and only those transactions are regarded whose category matches one of the explicitly given categoryIds. The default value for this flag is &#39;true&#39;. (optional, default to true)
     * @param isNew If specified, then only transactions that have their &#39;isNew&#39; flag set to true/false will be regarded. (optional)
     * @param isPotentialDuplicate If specified, then only transactions that have their &#39;isPotentialDuplicate&#39; flag set to true/false will be regarded. (optional)
     * @param isAdjustingEntry If specified, then only transactions that have their &#39;isAdjustingEntry&#39; flag set to true/false will be regarded. (optional)
     * @param minImportDate Lower bound for a transaction&#39;s import date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;importDate&#39; is equal to or later than the given date will be regarded. (optional)
     * @param maxImportDate Upper bound for a transaction&#39;s import date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only transactions whose &#39;importDate&#39; is equal to or earlier than the given date will be regarded. (optional)
     * @param page Result page that you want to retrieve. (optional, default to 1)
     * @param perPage Maximum number of records per page. Can be at most 500. NOTE: Due to its validation and visualization, the swagger frontend might show very low performance, or even crashes, when a service responds with a lot of data. It is recommended to use a HTTP client like Postman or DHC instead of our swagger frontend for service calls with large page sizes. (optional, default to 20)
     * @param order Determines the order of the results. You can use the following fields for ordering the response: &#39;id&#39;, &#39;parentId&#39;, &#39;accountId&#39;, &#39;valueDate&#39;, &#39;bankBookingDate&#39;, &#39;finapiBookingDate&#39;, &#39;amount&#39;, &#39;purpose&#39;, &#39;counterpartName&#39;, &#39;counterpartAccountNumber&#39;, &#39;counterpartIban&#39;, &#39;counterpartBlz&#39;, &#39;counterpartBic&#39;, &#39;type&#39;, &#39;primanota&#39;, &#39;category.id&#39;, &#39;category.name&#39;, &#39;isPotentialDuplicate&#39;, &#39;isNew&#39; and &#39;importDate&#39;. The default order for all services is &#39;id,asc&#39;. You can also order by multiple properties. In that case the order of the parameters passed is important. Example: &#39;/transactions?order&#x3D;finapiBookingDate,desc&amp;order&#x3D;counterpartName&#39; will return the latest transactions first. If there are more transactions on the same day, then these transactions are ordered by the counterpart name (ascending). The general format is: &#39;property[,asc|desc]&#39;, with &#39;asc&#39; being the default value. Please note that ordering by multiple fields is not supported in our swagger frontend, but you can test this feature with any HTTP tool of your choice (e.g. postman or DHC).  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAndSearchAllTransactionsAsync(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, Boolean isAdjustingEntry, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order, final ApiCallback<PageableTransactionList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAndSearchAllTransactionsValidateBeforeCall(view, ids, search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, includeChildCategories, isNew, isPotentialDuplicate, isAdjustingEntry, minImportDate, maxImportDate, page, perPage, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PageableTransactionList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getMultipleTransactions
     * @param ids Comma-separated list of identifiers of requested transactions (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call getMultipleTransactionsCall(List<Long> ids, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/transactions/{ids}"
            .replaceAll("\\{" + "ids" + "\\}", apiClient.escapeString(ids.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getMultipleTransactionsValidateBeforeCall(List<Long> ids, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'ids' is set
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling getMultipleTransactions(Async)");
        }
        

        com.squareup.okhttp.Call call = getMultipleTransactionsCall(ids, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get multiple transactions
     * Get a list of multiple transactions of the user that is authorized by the access_token. Must pass the transactions&#39; identifiers and the user&#39;s access_token. Transactions whose identifiers do not exist or do not relate to the authorized user will not be contained in the result (If this applies to all of the given identifiers, then the result will be an empty list). WARNING: This service is deprecated and will be removed at some point. If you want to get multiple transactions, please instead use the service &#39;Get and search all transactions&#39;, where you can pass a comma-separated list of identifiers .
     * @param ids Comma-separated list of identifiers of requested transactions (required)
     * @return TransactionList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public TransactionList getMultipleTransactions(List<Long> ids) throws ApiException {
        ApiResponse<TransactionList> resp = getMultipleTransactionsWithHttpInfo(ids);
        return resp.getData();
    }

    /**
     * Get multiple transactions
     * Get a list of multiple transactions of the user that is authorized by the access_token. Must pass the transactions&#39; identifiers and the user&#39;s access_token. Transactions whose identifiers do not exist or do not relate to the authorized user will not be contained in the result (If this applies to all of the given identifiers, then the result will be an empty list). WARNING: This service is deprecated and will be removed at some point. If you want to get multiple transactions, please instead use the service &#39;Get and search all transactions&#39;, where you can pass a comma-separated list of identifiers .
     * @param ids Comma-separated list of identifiers of requested transactions (required)
     * @return ApiResponse&lt;TransactionList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public ApiResponse<TransactionList> getMultipleTransactionsWithHttpInfo(List<Long> ids) throws ApiException {
        com.squareup.okhttp.Call call = getMultipleTransactionsValidateBeforeCall(ids, null, null);
        Type localVarReturnType = new TypeToken<TransactionList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get multiple transactions (asynchronously)
     * Get a list of multiple transactions of the user that is authorized by the access_token. Must pass the transactions&#39; identifiers and the user&#39;s access_token. Transactions whose identifiers do not exist or do not relate to the authorized user will not be contained in the result (If this applies to all of the given identifiers, then the result will be an empty list). WARNING: This service is deprecated and will be removed at some point. If you want to get multiple transactions, please instead use the service &#39;Get and search all transactions&#39;, where you can pass a comma-separated list of identifiers .
     * @param ids Comma-separated list of identifiers of requested transactions (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call getMultipleTransactionsAsync(List<Long> ids, final ApiCallback<TransactionList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getMultipleTransactionsValidateBeforeCall(ids, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TransactionList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getTransaction
     * @param id Identifier of transaction (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTransactionCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/transactions/{id}"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTransactionValidateBeforeCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTransaction(Async)");
        }
        

        com.squareup.okhttp.Call call = getTransactionCall(id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a transaction
     * Get a single transaction of the user that is authorized by the access_token. Must pass the transaction&#39;s identifier and the user&#39;s access_token.
     * @param id Identifier of transaction (required)
     * @return Transaction
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Transaction getTransaction(Long id) throws ApiException {
        ApiResponse<Transaction> resp = getTransactionWithHttpInfo(id);
        return resp.getData();
    }

    /**
     * Get a transaction
     * Get a single transaction of the user that is authorized by the access_token. Must pass the transaction&#39;s identifier and the user&#39;s access_token.
     * @param id Identifier of transaction (required)
     * @return ApiResponse&lt;Transaction&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Transaction> getTransactionWithHttpInfo(Long id) throws ApiException {
        com.squareup.okhttp.Call call = getTransactionValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a transaction (asynchronously)
     * Get a single transaction of the user that is authorized by the access_token. Must pass the transaction&#39;s identifier and the user&#39;s access_token.
     * @param id Identifier of transaction (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTransactionAsync(Long id, final ApiCallback<Transaction> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTransactionValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for restoreTransaction
     * @param id Transaction identifier (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call restoreTransactionCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/transactions/{id}/restore"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call restoreTransactionValidateBeforeCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling restoreTransaction(Async)");
        }
        

        com.squareup.okhttp.Call call = restoreTransactionCall(id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Restore a transaction
     * Restore a previously split transaction. Removes all of its sub-transactions.
     * @param id Transaction identifier (required)
     * @return Transaction
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Transaction restoreTransaction(Long id) throws ApiException {
        ApiResponse<Transaction> resp = restoreTransactionWithHttpInfo(id);
        return resp.getData();
    }

    /**
     * Restore a transaction
     * Restore a previously split transaction. Removes all of its sub-transactions.
     * @param id Transaction identifier (required)
     * @return ApiResponse&lt;Transaction&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Transaction> restoreTransactionWithHttpInfo(Long id) throws ApiException {
        com.squareup.okhttp.Call call = restoreTransactionValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Restore a transaction (asynchronously)
     * Restore a previously split transaction. Removes all of its sub-transactions.
     * @param id Transaction identifier (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call restoreTransactionAsync(Long id, final ApiCallback<Transaction> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = restoreTransactionValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for splitTransaction
     * @param id Transaction identifier (required)
     * @param body Split transactions parameters (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call splitTransactionCall(Long id, SplitTransactionsParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/api/v1/transactions/{id}/split"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call splitTransactionValidateBeforeCall(Long id, SplitTransactionsParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling splitTransaction(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling splitTransaction(Async)");
        }
        

        com.squareup.okhttp.Call call = splitTransactionCall(id, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Split a transaction
     * Split a transaction into several logical sub-transactions. If the given transaction is split already, all its current sub-transactions will get deleted before the new sub-transactions will get created.
     * @param id Transaction identifier (required)
     * @param body Split transactions parameters (required)
     * @return Transaction
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Transaction splitTransaction(Long id, SplitTransactionsParams body) throws ApiException {
        ApiResponse<Transaction> resp = splitTransactionWithHttpInfo(id, body);
        return resp.getData();
    }

    /**
     * Split a transaction
     * Split a transaction into several logical sub-transactions. If the given transaction is split already, all its current sub-transactions will get deleted before the new sub-transactions will get created.
     * @param id Transaction identifier (required)
     * @param body Split transactions parameters (required)
     * @return ApiResponse&lt;Transaction&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Transaction> splitTransactionWithHttpInfo(Long id, SplitTransactionsParams body) throws ApiException {
        com.squareup.okhttp.Call call = splitTransactionValidateBeforeCall(id, body, null, null);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Split a transaction (asynchronously)
     * Split a transaction into several logical sub-transactions. If the given transaction is split already, all its current sub-transactions will get deleted before the new sub-transactions will get created.
     * @param id Transaction identifier (required)
     * @param body Split transactions parameters (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call splitTransactionAsync(Long id, SplitTransactionsParams body, final ApiCallback<Transaction> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = splitTransactionValidateBeforeCall(id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for triggerCategorization
     * @param body Trigger categorization parameters (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call triggerCategorizationCall(TriggerCategorizationParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/api/v1/transactions/triggerCategorization";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call triggerCategorizationValidateBeforeCall(TriggerCategorizationParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling triggerCategorization(Async)");
        }
        

        com.squareup.okhttp.Call call = triggerCategorizationCall(body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Trigger categorization
     * Triggers finAPI&#39;s background categorization process for all uncategorized transactions of the given bank connection(s) (or of all of the user&#39;s bank connections, if no bank connection identifiers are passed). The service returns as soon as the categorizations are scheduled. At this point, the bank connections will have their &#39;categorizationStatus&#39; set to &#39;PENDING&#39;. Use the service \&quot;Get a bank connection\&quot; or \&quot;Get all bank connections\&quot; to check when the categorization has finished (this is the case when the categorizationStatus has switched to &#39;READY&#39;).&lt;br/&gt;&lt;br/&gt;Note that if at least one of the target bank connections is currently locked at the time when you call this service (i.e. the bank connection is currently being updated, or another categorization is already scheduled for it), then no categorization will be triggered at all and the service will respond with HTTP code 422.&lt;br/&gt;&lt;br/&gt;Please also note:&lt;br/&gt;&amp;bull; finAPI&#39;s background categorization process is executed automatically whenever you import or update a bank connection (though in case of update, it will categorize only the new transactions, and not re-run categorization for previously imported transactions). This means that in general you do not have to call this service after an import or update. Use this service only when you wish to re-run the categorization of all existing uncategorized transactions.&lt;br/&gt;&amp;bull; if you wish to just manually assign categories to transactions, please use the service \&quot;Edit a transaction\&quot; or \&quot;Edit multiple transactions\&quot; instead.
     * @param body Trigger categorization parameters (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void triggerCategorization(TriggerCategorizationParams body) throws ApiException {
        triggerCategorizationWithHttpInfo(body);
    }

    /**
     * Trigger categorization
     * Triggers finAPI&#39;s background categorization process for all uncategorized transactions of the given bank connection(s) (or of all of the user&#39;s bank connections, if no bank connection identifiers are passed). The service returns as soon as the categorizations are scheduled. At this point, the bank connections will have their &#39;categorizationStatus&#39; set to &#39;PENDING&#39;. Use the service \&quot;Get a bank connection\&quot; or \&quot;Get all bank connections\&quot; to check when the categorization has finished (this is the case when the categorizationStatus has switched to &#39;READY&#39;).&lt;br/&gt;&lt;br/&gt;Note that if at least one of the target bank connections is currently locked at the time when you call this service (i.e. the bank connection is currently being updated, or another categorization is already scheduled for it), then no categorization will be triggered at all and the service will respond with HTTP code 422.&lt;br/&gt;&lt;br/&gt;Please also note:&lt;br/&gt;&amp;bull; finAPI&#39;s background categorization process is executed automatically whenever you import or update a bank connection (though in case of update, it will categorize only the new transactions, and not re-run categorization for previously imported transactions). This means that in general you do not have to call this service after an import or update. Use this service only when you wish to re-run the categorization of all existing uncategorized transactions.&lt;br/&gt;&amp;bull; if you wish to just manually assign categories to transactions, please use the service \&quot;Edit a transaction\&quot; or \&quot;Edit multiple transactions\&quot; instead.
     * @param body Trigger categorization parameters (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> triggerCategorizationWithHttpInfo(TriggerCategorizationParams body) throws ApiException {
        com.squareup.okhttp.Call call = triggerCategorizationValidateBeforeCall(body, null, null);
        return apiClient.execute(call);
    }

    /**
     * Trigger categorization (asynchronously)
     * Triggers finAPI&#39;s background categorization process for all uncategorized transactions of the given bank connection(s) (or of all of the user&#39;s bank connections, if no bank connection identifiers are passed). The service returns as soon as the categorizations are scheduled. At this point, the bank connections will have their &#39;categorizationStatus&#39; set to &#39;PENDING&#39;. Use the service \&quot;Get a bank connection\&quot; or \&quot;Get all bank connections\&quot; to check when the categorization has finished (this is the case when the categorizationStatus has switched to &#39;READY&#39;).&lt;br/&gt;&lt;br/&gt;Note that if at least one of the target bank connections is currently locked at the time when you call this service (i.e. the bank connection is currently being updated, or another categorization is already scheduled for it), then no categorization will be triggered at all and the service will respond with HTTP code 422.&lt;br/&gt;&lt;br/&gt;Please also note:&lt;br/&gt;&amp;bull; finAPI&#39;s background categorization process is executed automatically whenever you import or update a bank connection (though in case of update, it will categorize only the new transactions, and not re-run categorization for previously imported transactions). This means that in general you do not have to call this service after an import or update. Use this service only when you wish to re-run the categorization of all existing uncategorized transactions.&lt;br/&gt;&amp;bull; if you wish to just manually assign categories to transactions, please use the service \&quot;Edit a transaction\&quot; or \&quot;Edit multiple transactions\&quot; instead.
     * @param body Trigger categorization parameters (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call triggerCategorizationAsync(TriggerCategorizationParams body, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = triggerCategorizationValidateBeforeCall(body, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
