/*
 * finAPI RESTful Services
 * finAPI RESTful Services
 *
 * OpenAPI spec version: v1.46.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.Account;
import io.swagger.client.model.AccountList;
import io.swagger.client.model.AccountParams;
import io.swagger.client.model.BadCredentialsError;
import io.swagger.client.model.BankResponse;
import java.math.BigDecimal;
import io.swagger.client.model.DailyBalanceList;
import io.swagger.client.model.DirectDebitOrderingResponse;
import io.swagger.client.model.ErrorMessage;
import io.swagger.client.model.ExecuteSepaDirectDebitParams;
import io.swagger.client.model.ExecuteSepaMoneyTransferParams;
import io.swagger.client.model.IdentifierList;
import io.swagger.client.model.MoneyTransferOrderingResponse;
import io.swagger.client.model.RequestSepaDirectDebitParams;
import io.swagger.client.model.RequestSepaMoneyTransferParams;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountsApi {
    private ApiClient apiClient;

    public AccountsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deleteAccount
     * @param id Identifier of the account to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteAccountCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/accounts/{id}"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteAccountValidateBeforeCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteAccount(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteAccountCall(id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete an account
     * Delete a single bank account of the user that is authorized by the access_token, including its transactions and balance data. Must pass the account&#39;s identifier and the user&#39;s access_token.&lt;br/&gt;&lt;br/&gt;Notes: &lt;br/&gt;- You cannot delete an account while the bank connection that it relates to is currently in the process of import, update, or transactions categorization. &lt;br/&gt;- When the last remaining account of a bank connection gets deleted, then the bank connection itself will get deleted as well! &lt;br/&gt;- All notification rules that are connected to the account will get adjusted so that they no longer have this account listed. Notification rules that are connected to just this account (and no other accounts) will get deleted altogether.
     * @param id Identifier of the account to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteAccount(Long id) throws ApiException {
        deleteAccountWithHttpInfo(id);
    }

    /**
     * Delete an account
     * Delete a single bank account of the user that is authorized by the access_token, including its transactions and balance data. Must pass the account&#39;s identifier and the user&#39;s access_token.&lt;br/&gt;&lt;br/&gt;Notes: &lt;br/&gt;- You cannot delete an account while the bank connection that it relates to is currently in the process of import, update, or transactions categorization. &lt;br/&gt;- When the last remaining account of a bank connection gets deleted, then the bank connection itself will get deleted as well! &lt;br/&gt;- All notification rules that are connected to the account will get adjusted so that they no longer have this account listed. Notification rules that are connected to just this account (and no other accounts) will get deleted altogether.
     * @param id Identifier of the account to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteAccountWithHttpInfo(Long id) throws ApiException {
        com.squareup.okhttp.Call call = deleteAccountValidateBeforeCall(id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete an account (asynchronously)
     * Delete a single bank account of the user that is authorized by the access_token, including its transactions and balance data. Must pass the account&#39;s identifier and the user&#39;s access_token.&lt;br/&gt;&lt;br/&gt;Notes: &lt;br/&gt;- You cannot delete an account while the bank connection that it relates to is currently in the process of import, update, or transactions categorization. &lt;br/&gt;- When the last remaining account of a bank connection gets deleted, then the bank connection itself will get deleted as well! &lt;br/&gt;- All notification rules that are connected to the account will get adjusted so that they no longer have this account listed. Notification rules that are connected to just this account (and no other accounts) will get deleted altogether.
     * @param id Identifier of the account to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteAccountAsync(Long id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteAccountValidateBeforeCall(id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteAllAccounts
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteAllAccountsCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/accounts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteAllAccountsValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = deleteAllAccountsCall(progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete all accounts
     * Delete all accounts of the user that is authorized by the access_token, including all transactions and balance data. Must pass the user&#39;s access_token.&lt;br/&gt;&lt;br/&gt;Notes: &lt;br/&gt;- Deleting all of the user&#39;s accounts also deletes all of his bank connections. &lt;br/&gt;- All notification rules that are connected to any specific accounts will get deleted as well. &lt;br/&gt;- If at least one of the user&#39;s bank connections in currently in the process of import, update, or transactions categorization, then this service will perform no action at all.
     * @return IdentifierList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public IdentifierList deleteAllAccounts() throws ApiException {
        ApiResponse<IdentifierList> resp = deleteAllAccountsWithHttpInfo();
        return resp.getData();
    }

    /**
     * Delete all accounts
     * Delete all accounts of the user that is authorized by the access_token, including all transactions and balance data. Must pass the user&#39;s access_token.&lt;br/&gt;&lt;br/&gt;Notes: &lt;br/&gt;- Deleting all of the user&#39;s accounts also deletes all of his bank connections. &lt;br/&gt;- All notification rules that are connected to any specific accounts will get deleted as well. &lt;br/&gt;- If at least one of the user&#39;s bank connections in currently in the process of import, update, or transactions categorization, then this service will perform no action at all.
     * @return ApiResponse&lt;IdentifierList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<IdentifierList> deleteAllAccountsWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = deleteAllAccountsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete all accounts (asynchronously)
     * Delete all accounts of the user that is authorized by the access_token, including all transactions and balance data. Must pass the user&#39;s access_token.&lt;br/&gt;&lt;br/&gt;Notes: &lt;br/&gt;- Deleting all of the user&#39;s accounts also deletes all of his bank connections. &lt;br/&gt;- All notification rules that are connected to any specific accounts will get deleted as well. &lt;br/&gt;- If at least one of the user&#39;s bank connections in currently in the process of import, update, or transactions categorization, then this service will perform no action at all.
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteAllAccountsAsync(final ApiCallback<IdentifierList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteAllAccountsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for editAccount
     * @param id Identifier of the account to edit (required)
     * @param body New account name and/or type and/or &#39;isNew&#39; flag (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call editAccountCall(Long id, AccountParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/api/v1/accounts/{id}"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call editAccountValidateBeforeCall(Long id, AccountParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling editAccount(Async)");
        }
        

        com.squareup.okhttp.Call call = editAccountCall(id, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Edit an account
     * Change the name and/or the type and/or the &#39;isNew&#39; flag of a single bank account of the user that is authorized by the access_token. Must pass the account&#39;s identifier, the account&#39;s new name and/or type and/or &#39;isNew&#39; flag, and the user&#39;s access_token.
     * @param id Identifier of the account to edit (required)
     * @param body New account name and/or type and/or &#39;isNew&#39; flag (optional)
     * @return Account
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Account editAccount(Long id, AccountParams body) throws ApiException {
        ApiResponse<Account> resp = editAccountWithHttpInfo(id, body);
        return resp.getData();
    }

    /**
     * Edit an account
     * Change the name and/or the type and/or the &#39;isNew&#39; flag of a single bank account of the user that is authorized by the access_token. Must pass the account&#39;s identifier, the account&#39;s new name and/or type and/or &#39;isNew&#39; flag, and the user&#39;s access_token.
     * @param id Identifier of the account to edit (required)
     * @param body New account name and/or type and/or &#39;isNew&#39; flag (optional)
     * @return ApiResponse&lt;Account&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Account> editAccountWithHttpInfo(Long id, AccountParams body) throws ApiException {
        com.squareup.okhttp.Call call = editAccountValidateBeforeCall(id, body, null, null);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit an account (asynchronously)
     * Change the name and/or the type and/or the &#39;isNew&#39; flag of a single bank account of the user that is authorized by the access_token. Must pass the account&#39;s identifier, the account&#39;s new name and/or type and/or &#39;isNew&#39; flag, and the user&#39;s access_token.
     * @param id Identifier of the account to edit (required)
     * @param body New account name and/or type and/or &#39;isNew&#39; flag (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call editAccountAsync(Long id, AccountParams body, final ApiCallback<Account> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = editAccountValidateBeforeCall(id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for executeSepaDirectDebit
     * @param body Parameters for the execution of a SEPA direct debit order (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call executeSepaDirectDebitCall(ExecuteSepaDirectDebitParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/api/v1/accounts/executeSepaDirectDebit";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call executeSepaDirectDebitValidateBeforeCall(ExecuteSepaDirectDebitParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling executeSepaDirectDebit(Async)");
        }
        

        com.squareup.okhttp.Call call = executeSepaDirectDebitCall(body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Execute SEPA Direct Debit
     * Execute a SEPA direct debit order that has been previously submitted by the use of the /requestSepaDirectDebit service. Note that this service cannot be used for the demo account.
     * @param body Parameters for the execution of a SEPA direct debit order (required)
     * @return BankResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BankResponse executeSepaDirectDebit(ExecuteSepaDirectDebitParams body) throws ApiException {
        ApiResponse<BankResponse> resp = executeSepaDirectDebitWithHttpInfo(body);
        return resp.getData();
    }

    /**
     * Execute SEPA Direct Debit
     * Execute a SEPA direct debit order that has been previously submitted by the use of the /requestSepaDirectDebit service. Note that this service cannot be used for the demo account.
     * @param body Parameters for the execution of a SEPA direct debit order (required)
     * @return ApiResponse&lt;BankResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BankResponse> executeSepaDirectDebitWithHttpInfo(ExecuteSepaDirectDebitParams body) throws ApiException {
        com.squareup.okhttp.Call call = executeSepaDirectDebitValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<BankResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Execute SEPA Direct Debit (asynchronously)
     * Execute a SEPA direct debit order that has been previously submitted by the use of the /requestSepaDirectDebit service. Note that this service cannot be used for the demo account.
     * @param body Parameters for the execution of a SEPA direct debit order (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call executeSepaDirectDebitAsync(ExecuteSepaDirectDebitParams body, final ApiCallback<BankResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = executeSepaDirectDebitValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BankResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for executeSepaMoneyTransfer
     * @param body Parameters for the execution of a SEPA money transfer order (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call executeSepaMoneyTransferCall(ExecuteSepaMoneyTransferParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/api/v1/accounts/executeSepaMoneyTransfer";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call executeSepaMoneyTransferValidateBeforeCall(ExecuteSepaMoneyTransferParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling executeSepaMoneyTransfer(Async)");
        }
        

        com.squareup.okhttp.Call call = executeSepaMoneyTransferCall(body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Execute SEPA Money Transfer
     * Execute a SEPA money transfer order that has been previously submitted by the use of the /requestSepaMoneyTransfer service. Note that this service cannot be used for the demo account.
     * @param body Parameters for the execution of a SEPA money transfer order (required)
     * @return BankResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BankResponse executeSepaMoneyTransfer(ExecuteSepaMoneyTransferParams body) throws ApiException {
        ApiResponse<BankResponse> resp = executeSepaMoneyTransferWithHttpInfo(body);
        return resp.getData();
    }

    /**
     * Execute SEPA Money Transfer
     * Execute a SEPA money transfer order that has been previously submitted by the use of the /requestSepaMoneyTransfer service. Note that this service cannot be used for the demo account.
     * @param body Parameters for the execution of a SEPA money transfer order (required)
     * @return ApiResponse&lt;BankResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BankResponse> executeSepaMoneyTransferWithHttpInfo(ExecuteSepaMoneyTransferParams body) throws ApiException {
        com.squareup.okhttp.Call call = executeSepaMoneyTransferValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<BankResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Execute SEPA Money Transfer (asynchronously)
     * Execute a SEPA money transfer order that has been previously submitted by the use of the /requestSepaMoneyTransfer service. Note that this service cannot be used for the demo account.
     * @param body Parameters for the execution of a SEPA money transfer order (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call executeSepaMoneyTransferAsync(ExecuteSepaMoneyTransferParams body, final ApiCallback<BankResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = executeSepaMoneyTransferValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BankResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAccount
     * @param id Identifier of requested account (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAccountCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/accounts/{id}"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAccountValidateBeforeCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getAccount(Async)");
        }
        

        com.squareup.okhttp.Call call = getAccountCall(id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get an account
     * Get a single bank account of the user that is authorized by the access_token. Must pass the account&#39;s identifier and the user&#39;s access_token.
     * @param id Identifier of requested account (required)
     * @return Account
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Account getAccount(Long id) throws ApiException {
        ApiResponse<Account> resp = getAccountWithHttpInfo(id);
        return resp.getData();
    }

    /**
     * Get an account
     * Get a single bank account of the user that is authorized by the access_token. Must pass the account&#39;s identifier and the user&#39;s access_token.
     * @param id Identifier of requested account (required)
     * @return ApiResponse&lt;Account&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Account> getAccountWithHttpInfo(Long id) throws ApiException {
        com.squareup.okhttp.Call call = getAccountValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get an account (asynchronously)
     * Get a single bank account of the user that is authorized by the access_token. Must pass the account&#39;s identifier and the user&#39;s access_token.
     * @param id Identifier of requested account (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAccountAsync(Long id, final ApiCallback<Account> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAccountValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAndSearchAllAccounts
     * @param ids A comma-separated list of account identifiers. If specified, then only accounts whose identifier match any of the given identifiers will be regarded. The maximum number of identifiers is 1000. (optional)
     * @param search If specified, then only those accounts will be contained in the result whose &#39;accountName&#39;, &#39;iban&#39;, &#39;accountNumber&#39; or &#39;subAccountNumber&#39; contains the given search string (the matching works case-insensitive). If no accounts contain the search string in any of these fields, then the result will be an empty list. NOTE: If the given search string consists of several terms (separated by whitespace), then ALL of these terms must be contained in the searched fields in order for an account to get included into the result. (optional)
     * @param accountTypeIds A comma-separated list of account types. If specified, then only accounts that relate to the given types will be regarded. If not specified, then all accounts will be regarded. (optional)
     * @param bankConnectionIds A comma-separated list of bank connection identifiers. If specified, then only accounts that relate to the given bank connections will be regarded. If not specified, then all accounts will be regarded. (optional)
     * @param minLastSuccessfulUpdate Lower bound for a account&#39;s last successful update date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only accounts whose &#39;lastSuccessfulUpdate&#39; is equal to or later than the given date will be regarded. (optional)
     * @param maxLastSuccessfulUpdate Upper bound for a account&#39;s last successful update date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only accounts whose &#39;lastSuccessfulUpdate&#39; is equal to or earlier than the given date will be regarded. (optional)
     * @param minBalance If specified, then only accounts whose balance is equal to or greater than the given balance will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param maxBalance If specified, then only accounts whose balance is equal to or less than the given balance will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAndSearchAllAccountsCall(List<Long> ids, String search, List<Long> accountTypeIds, List<Long> bankConnectionIds, String minLastSuccessfulUpdate, String maxLastSuccessfulUpdate, BigDecimal minBalance, BigDecimal maxBalance, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/accounts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ids != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "ids", ids));
        if (search != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("search", search));
        if (accountTypeIds != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "accountTypeIds", accountTypeIds));
        if (bankConnectionIds != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "bankConnectionIds", bankConnectionIds));
        if (minLastSuccessfulUpdate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("minLastSuccessfulUpdate", minLastSuccessfulUpdate));
        if (maxLastSuccessfulUpdate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("maxLastSuccessfulUpdate", maxLastSuccessfulUpdate));
        if (minBalance != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("minBalance", minBalance));
        if (maxBalance != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("maxBalance", maxBalance));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAndSearchAllAccountsValidateBeforeCall(List<Long> ids, String search, List<Long> accountTypeIds, List<Long> bankConnectionIds, String minLastSuccessfulUpdate, String maxLastSuccessfulUpdate, BigDecimal minBalance, BigDecimal maxBalance, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getAndSearchAllAccountsCall(ids, search, accountTypeIds, bankConnectionIds, minLastSuccessfulUpdate, maxLastSuccessfulUpdate, minBalance, maxBalance, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get and search all accounts
     * Get bank accounts of the user that is authorized by the access_token. Must pass the user&#39;s access_token. You can set optional search criteria to get only those bank accounts that you are interested in. If you do not specify any search criteria, then this service functions as a &#39;get all&#39; service.
     * @param ids A comma-separated list of account identifiers. If specified, then only accounts whose identifier match any of the given identifiers will be regarded. The maximum number of identifiers is 1000. (optional)
     * @param search If specified, then only those accounts will be contained in the result whose &#39;accountName&#39;, &#39;iban&#39;, &#39;accountNumber&#39; or &#39;subAccountNumber&#39; contains the given search string (the matching works case-insensitive). If no accounts contain the search string in any of these fields, then the result will be an empty list. NOTE: If the given search string consists of several terms (separated by whitespace), then ALL of these terms must be contained in the searched fields in order for an account to get included into the result. (optional)
     * @param accountTypeIds A comma-separated list of account types. If specified, then only accounts that relate to the given types will be regarded. If not specified, then all accounts will be regarded. (optional)
     * @param bankConnectionIds A comma-separated list of bank connection identifiers. If specified, then only accounts that relate to the given bank connections will be regarded. If not specified, then all accounts will be regarded. (optional)
     * @param minLastSuccessfulUpdate Lower bound for a account&#39;s last successful update date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only accounts whose &#39;lastSuccessfulUpdate&#39; is equal to or later than the given date will be regarded. (optional)
     * @param maxLastSuccessfulUpdate Upper bound for a account&#39;s last successful update date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only accounts whose &#39;lastSuccessfulUpdate&#39; is equal to or earlier than the given date will be regarded. (optional)
     * @param minBalance If specified, then only accounts whose balance is equal to or greater than the given balance will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param maxBalance If specified, then only accounts whose balance is equal to or less than the given balance will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @return AccountList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AccountList getAndSearchAllAccounts(List<Long> ids, String search, List<Long> accountTypeIds, List<Long> bankConnectionIds, String minLastSuccessfulUpdate, String maxLastSuccessfulUpdate, BigDecimal minBalance, BigDecimal maxBalance) throws ApiException {
        ApiResponse<AccountList> resp = getAndSearchAllAccountsWithHttpInfo(ids, search, accountTypeIds, bankConnectionIds, minLastSuccessfulUpdate, maxLastSuccessfulUpdate, minBalance, maxBalance);
        return resp.getData();
    }

    /**
     * Get and search all accounts
     * Get bank accounts of the user that is authorized by the access_token. Must pass the user&#39;s access_token. You can set optional search criteria to get only those bank accounts that you are interested in. If you do not specify any search criteria, then this service functions as a &#39;get all&#39; service.
     * @param ids A comma-separated list of account identifiers. If specified, then only accounts whose identifier match any of the given identifiers will be regarded. The maximum number of identifiers is 1000. (optional)
     * @param search If specified, then only those accounts will be contained in the result whose &#39;accountName&#39;, &#39;iban&#39;, &#39;accountNumber&#39; or &#39;subAccountNumber&#39; contains the given search string (the matching works case-insensitive). If no accounts contain the search string in any of these fields, then the result will be an empty list. NOTE: If the given search string consists of several terms (separated by whitespace), then ALL of these terms must be contained in the searched fields in order for an account to get included into the result. (optional)
     * @param accountTypeIds A comma-separated list of account types. If specified, then only accounts that relate to the given types will be regarded. If not specified, then all accounts will be regarded. (optional)
     * @param bankConnectionIds A comma-separated list of bank connection identifiers. If specified, then only accounts that relate to the given bank connections will be regarded. If not specified, then all accounts will be regarded. (optional)
     * @param minLastSuccessfulUpdate Lower bound for a account&#39;s last successful update date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only accounts whose &#39;lastSuccessfulUpdate&#39; is equal to or later than the given date will be regarded. (optional)
     * @param maxLastSuccessfulUpdate Upper bound for a account&#39;s last successful update date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only accounts whose &#39;lastSuccessfulUpdate&#39; is equal to or earlier than the given date will be regarded. (optional)
     * @param minBalance If specified, then only accounts whose balance is equal to or greater than the given balance will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param maxBalance If specified, then only accounts whose balance is equal to or less than the given balance will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @return ApiResponse&lt;AccountList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AccountList> getAndSearchAllAccountsWithHttpInfo(List<Long> ids, String search, List<Long> accountTypeIds, List<Long> bankConnectionIds, String minLastSuccessfulUpdate, String maxLastSuccessfulUpdate, BigDecimal minBalance, BigDecimal maxBalance) throws ApiException {
        com.squareup.okhttp.Call call = getAndSearchAllAccountsValidateBeforeCall(ids, search, accountTypeIds, bankConnectionIds, minLastSuccessfulUpdate, maxLastSuccessfulUpdate, minBalance, maxBalance, null, null);
        Type localVarReturnType = new TypeToken<AccountList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get and search all accounts (asynchronously)
     * Get bank accounts of the user that is authorized by the access_token. Must pass the user&#39;s access_token. You can set optional search criteria to get only those bank accounts that you are interested in. If you do not specify any search criteria, then this service functions as a &#39;get all&#39; service.
     * @param ids A comma-separated list of account identifiers. If specified, then only accounts whose identifier match any of the given identifiers will be regarded. The maximum number of identifiers is 1000. (optional)
     * @param search If specified, then only those accounts will be contained in the result whose &#39;accountName&#39;, &#39;iban&#39;, &#39;accountNumber&#39; or &#39;subAccountNumber&#39; contains the given search string (the matching works case-insensitive). If no accounts contain the search string in any of these fields, then the result will be an empty list. NOTE: If the given search string consists of several terms (separated by whitespace), then ALL of these terms must be contained in the searched fields in order for an account to get included into the result. (optional)
     * @param accountTypeIds A comma-separated list of account types. If specified, then only accounts that relate to the given types will be regarded. If not specified, then all accounts will be regarded. (optional)
     * @param bankConnectionIds A comma-separated list of bank connection identifiers. If specified, then only accounts that relate to the given bank connections will be regarded. If not specified, then all accounts will be regarded. (optional)
     * @param minLastSuccessfulUpdate Lower bound for a account&#39;s last successful update date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only accounts whose &#39;lastSuccessfulUpdate&#39; is equal to or later than the given date will be regarded. (optional)
     * @param maxLastSuccessfulUpdate Upper bound for a account&#39;s last successful update date, in the format &#39;YYYY-MM-DD&#39; (e.g. &#39;2016-01-01&#39;). If specified, then only accounts whose &#39;lastSuccessfulUpdate&#39; is equal to or earlier than the given date will be regarded. (optional)
     * @param minBalance If specified, then only accounts whose balance is equal to or greater than the given balance will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param maxBalance If specified, then only accounts whose balance is equal to or less than the given balance will be regarded. Can contain a positive or negative number with at most two decimal places. Examples: -300.12, or 90.95 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAndSearchAllAccountsAsync(List<Long> ids, String search, List<Long> accountTypeIds, List<Long> bankConnectionIds, String minLastSuccessfulUpdate, String maxLastSuccessfulUpdate, BigDecimal minBalance, BigDecimal maxBalance, final ApiCallback<AccountList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAndSearchAllAccountsValidateBeforeCall(ids, search, accountTypeIds, bankConnectionIds, minLastSuccessfulUpdate, maxLastSuccessfulUpdate, minBalance, maxBalance, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccountList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDailyBalances
     * @param accountIds A comma-separated list of (non-security) account identifiers. If no accounts are specified, all (non-security) accounts of the current user are regarded. (optional)
     * @param startDate A string in the format &#39;YYYY-MM-DD&#39;. Note that the requested date range [startDate..endDate] may not exceed 365 days. If startDate is not specified, it defaults to the endDate minus one month. (optional)
     * @param endDate A string in the format &#39;YYYY-MM-DD&#39;. Note that the requested date range [startDate..endDate] may not exceed 365 days. If endDate is not specified, it defaults to today&#39;s date. (optional)
     * @param withProjection Whether finAPI should project the first and last actually existing balance into the past and future. When passing &#39;true&#39;, then the result will always contain a daily balance for every day of the entire requested date range, even for days before the first actually existing balance, resp. after the last actually existing balance. Those days will have the same balance as the day of the first actual balance, resp. last actual balance, i.e. the first/last balance will be infinitely projected into the past/the future. When passing &#39;false&#39;, then the result will contain daily balances only from the day on where the first actual balance exists for any of the given accounts, and only up to the day where the last actual balance exists for any of the given accounts. Note that when in this case there are no actual balances within the requested date range, then an empty array will be returned. Default value for this parameter is &#39;true&#39;. (optional, default to true)
     * @param page Result page that you want to retrieve. (optional, default to 1)
     * @param perPage Maximum number of records per page. Can be at most 500. NOTE: Due to its validation and visualization, the swagger frontend might show very low performance, or even crashes, when a service responds with a lot of data. It is recommended to use a HTTP client like Postman or DHC instead of our swagger frontend for service calls with large page sizes. (optional, default to 20)
     * @param order Determines the order of the results. You can order the results by &#39;date&#39;, &#39;balance&#39;, &#39;income&#39; or &#39;spending&#39;. The default order for this service is &#39;date,asc&#39;. You can also order by multiple properties. In that case the order of the parameters passed is important. Example: &#39;/accounts/dailyBalances?order&#x3D;date,desc&amp;order&#x3D;balance,asc&#39; will return daily balances ordered by &#39;date&#39; (descending), where items with the same &#39;date&#39; are ordered by &#39;balance&#39; (ascending). The general format is: &#39;property[,asc|desc]&#39;, with &#39;asc&#39; being the default value. Please note that ordering by multiple fields is not supported in our swagger frontend, but you can test this feature with any HTTP tool of your choice (e.g. postman or DHC).  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDailyBalancesCall(List<Long> accountIds, String startDate, String endDate, Boolean withProjection, Integer page, Integer perPage, List<String> order, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/accounts/dailyBalances";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountIds != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "accountIds", accountIds));
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
        if (withProjection != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("withProjection", withProjection));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (perPage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("perPage", perPage));
        if (order != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "order", order));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDailyBalancesValidateBeforeCall(List<Long> accountIds, String startDate, String endDate, Boolean withProjection, Integer page, Integer perPage, List<String> order, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getDailyBalancesCall(accountIds, startDate, endDate, withProjection, page, perPage, order, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get daily balances
     * Returns the daily balances for the given accounts and the given period. The balances are calculated by finAPI and are based on each account&#39;s latest balance.
     * @param accountIds A comma-separated list of (non-security) account identifiers. If no accounts are specified, all (non-security) accounts of the current user are regarded. (optional)
     * @param startDate A string in the format &#39;YYYY-MM-DD&#39;. Note that the requested date range [startDate..endDate] may not exceed 365 days. If startDate is not specified, it defaults to the endDate minus one month. (optional)
     * @param endDate A string in the format &#39;YYYY-MM-DD&#39;. Note that the requested date range [startDate..endDate] may not exceed 365 days. If endDate is not specified, it defaults to today&#39;s date. (optional)
     * @param withProjection Whether finAPI should project the first and last actually existing balance into the past and future. When passing &#39;true&#39;, then the result will always contain a daily balance for every day of the entire requested date range, even for days before the first actually existing balance, resp. after the last actually existing balance. Those days will have the same balance as the day of the first actual balance, resp. last actual balance, i.e. the first/last balance will be infinitely projected into the past/the future. When passing &#39;false&#39;, then the result will contain daily balances only from the day on where the first actual balance exists for any of the given accounts, and only up to the day where the last actual balance exists for any of the given accounts. Note that when in this case there are no actual balances within the requested date range, then an empty array will be returned. Default value for this parameter is &#39;true&#39;. (optional, default to true)
     * @param page Result page that you want to retrieve. (optional, default to 1)
     * @param perPage Maximum number of records per page. Can be at most 500. NOTE: Due to its validation and visualization, the swagger frontend might show very low performance, or even crashes, when a service responds with a lot of data. It is recommended to use a HTTP client like Postman or DHC instead of our swagger frontend for service calls with large page sizes. (optional, default to 20)
     * @param order Determines the order of the results. You can order the results by &#39;date&#39;, &#39;balance&#39;, &#39;income&#39; or &#39;spending&#39;. The default order for this service is &#39;date,asc&#39;. You can also order by multiple properties. In that case the order of the parameters passed is important. Example: &#39;/accounts/dailyBalances?order&#x3D;date,desc&amp;order&#x3D;balance,asc&#39; will return daily balances ordered by &#39;date&#39; (descending), where items with the same &#39;date&#39; are ordered by &#39;balance&#39; (ascending). The general format is: &#39;property[,asc|desc]&#39;, with &#39;asc&#39; being the default value. Please note that ordering by multiple fields is not supported in our swagger frontend, but you can test this feature with any HTTP tool of your choice (e.g. postman or DHC).  (optional)
     * @return DailyBalanceList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DailyBalanceList getDailyBalances(List<Long> accountIds, String startDate, String endDate, Boolean withProjection, Integer page, Integer perPage, List<String> order) throws ApiException {
        ApiResponse<DailyBalanceList> resp = getDailyBalancesWithHttpInfo(accountIds, startDate, endDate, withProjection, page, perPage, order);
        return resp.getData();
    }

    /**
     * Get daily balances
     * Returns the daily balances for the given accounts and the given period. The balances are calculated by finAPI and are based on each account&#39;s latest balance.
     * @param accountIds A comma-separated list of (non-security) account identifiers. If no accounts are specified, all (non-security) accounts of the current user are regarded. (optional)
     * @param startDate A string in the format &#39;YYYY-MM-DD&#39;. Note that the requested date range [startDate..endDate] may not exceed 365 days. If startDate is not specified, it defaults to the endDate minus one month. (optional)
     * @param endDate A string in the format &#39;YYYY-MM-DD&#39;. Note that the requested date range [startDate..endDate] may not exceed 365 days. If endDate is not specified, it defaults to today&#39;s date. (optional)
     * @param withProjection Whether finAPI should project the first and last actually existing balance into the past and future. When passing &#39;true&#39;, then the result will always contain a daily balance for every day of the entire requested date range, even for days before the first actually existing balance, resp. after the last actually existing balance. Those days will have the same balance as the day of the first actual balance, resp. last actual balance, i.e. the first/last balance will be infinitely projected into the past/the future. When passing &#39;false&#39;, then the result will contain daily balances only from the day on where the first actual balance exists for any of the given accounts, and only up to the day where the last actual balance exists for any of the given accounts. Note that when in this case there are no actual balances within the requested date range, then an empty array will be returned. Default value for this parameter is &#39;true&#39;. (optional, default to true)
     * @param page Result page that you want to retrieve. (optional, default to 1)
     * @param perPage Maximum number of records per page. Can be at most 500. NOTE: Due to its validation and visualization, the swagger frontend might show very low performance, or even crashes, when a service responds with a lot of data. It is recommended to use a HTTP client like Postman or DHC instead of our swagger frontend for service calls with large page sizes. (optional, default to 20)
     * @param order Determines the order of the results. You can order the results by &#39;date&#39;, &#39;balance&#39;, &#39;income&#39; or &#39;spending&#39;. The default order for this service is &#39;date,asc&#39;. You can also order by multiple properties. In that case the order of the parameters passed is important. Example: &#39;/accounts/dailyBalances?order&#x3D;date,desc&amp;order&#x3D;balance,asc&#39; will return daily balances ordered by &#39;date&#39; (descending), where items with the same &#39;date&#39; are ordered by &#39;balance&#39; (ascending). The general format is: &#39;property[,asc|desc]&#39;, with &#39;asc&#39; being the default value. Please note that ordering by multiple fields is not supported in our swagger frontend, but you can test this feature with any HTTP tool of your choice (e.g. postman or DHC).  (optional)
     * @return ApiResponse&lt;DailyBalanceList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DailyBalanceList> getDailyBalancesWithHttpInfo(List<Long> accountIds, String startDate, String endDate, Boolean withProjection, Integer page, Integer perPage, List<String> order) throws ApiException {
        com.squareup.okhttp.Call call = getDailyBalancesValidateBeforeCall(accountIds, startDate, endDate, withProjection, page, perPage, order, null, null);
        Type localVarReturnType = new TypeToken<DailyBalanceList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get daily balances (asynchronously)
     * Returns the daily balances for the given accounts and the given period. The balances are calculated by finAPI and are based on each account&#39;s latest balance.
     * @param accountIds A comma-separated list of (non-security) account identifiers. If no accounts are specified, all (non-security) accounts of the current user are regarded. (optional)
     * @param startDate A string in the format &#39;YYYY-MM-DD&#39;. Note that the requested date range [startDate..endDate] may not exceed 365 days. If startDate is not specified, it defaults to the endDate minus one month. (optional)
     * @param endDate A string in the format &#39;YYYY-MM-DD&#39;. Note that the requested date range [startDate..endDate] may not exceed 365 days. If endDate is not specified, it defaults to today&#39;s date. (optional)
     * @param withProjection Whether finAPI should project the first and last actually existing balance into the past and future. When passing &#39;true&#39;, then the result will always contain a daily balance for every day of the entire requested date range, even for days before the first actually existing balance, resp. after the last actually existing balance. Those days will have the same balance as the day of the first actual balance, resp. last actual balance, i.e. the first/last balance will be infinitely projected into the past/the future. When passing &#39;false&#39;, then the result will contain daily balances only from the day on where the first actual balance exists for any of the given accounts, and only up to the day where the last actual balance exists for any of the given accounts. Note that when in this case there are no actual balances within the requested date range, then an empty array will be returned. Default value for this parameter is &#39;true&#39;. (optional, default to true)
     * @param page Result page that you want to retrieve. (optional, default to 1)
     * @param perPage Maximum number of records per page. Can be at most 500. NOTE: Due to its validation and visualization, the swagger frontend might show very low performance, or even crashes, when a service responds with a lot of data. It is recommended to use a HTTP client like Postman or DHC instead of our swagger frontend for service calls with large page sizes. (optional, default to 20)
     * @param order Determines the order of the results. You can order the results by &#39;date&#39;, &#39;balance&#39;, &#39;income&#39; or &#39;spending&#39;. The default order for this service is &#39;date,asc&#39;. You can also order by multiple properties. In that case the order of the parameters passed is important. Example: &#39;/accounts/dailyBalances?order&#x3D;date,desc&amp;order&#x3D;balance,asc&#39; will return daily balances ordered by &#39;date&#39; (descending), where items with the same &#39;date&#39; are ordered by &#39;balance&#39; (ascending). The general format is: &#39;property[,asc|desc]&#39;, with &#39;asc&#39; being the default value. Please note that ordering by multiple fields is not supported in our swagger frontend, but you can test this feature with any HTTP tool of your choice (e.g. postman or DHC).  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDailyBalancesAsync(List<Long> accountIds, String startDate, String endDate, Boolean withProjection, Integer page, Integer perPage, List<String> order, final ApiCallback<DailyBalanceList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDailyBalancesValidateBeforeCall(accountIds, startDate, endDate, withProjection, page, perPage, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DailyBalanceList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getMultipleAccounts
     * @param ids Comma-separated list of identifiers of requested accounts (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call getMultipleAccountsCall(List<Long> ids, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/accounts/{ids}"
            .replaceAll("\\{" + "ids" + "\\}", apiClient.escapeString(ids.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getMultipleAccountsValidateBeforeCall(List<Long> ids, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'ids' is set
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling getMultipleAccounts(Async)");
        }
        

        com.squareup.okhttp.Call call = getMultipleAccountsCall(ids, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get multiple accounts
     * Get a list of multiple bank accounts of the user that is authorized by the access_token. Must pass the accounts&#39; identifiers and the user&#39;s access_token. Accounts whose identifiers do not exist or do not relate to the authorized user will not be contained in the result (If this applies to all of the given identifiers, then the result will be an empty list). WARNING: This service is deprecated and will be removed at some point. If you want to get multiple accounts, please instead use the service &#39;Get and search all accounts&#39; and pass a comma-separated list of identifiers as a parameter &#39;ids&#39;.
     * @param ids Comma-separated list of identifiers of requested accounts (required)
     * @return AccountList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public AccountList getMultipleAccounts(List<Long> ids) throws ApiException {
        ApiResponse<AccountList> resp = getMultipleAccountsWithHttpInfo(ids);
        return resp.getData();
    }

    /**
     * Get multiple accounts
     * Get a list of multiple bank accounts of the user that is authorized by the access_token. Must pass the accounts&#39; identifiers and the user&#39;s access_token. Accounts whose identifiers do not exist or do not relate to the authorized user will not be contained in the result (If this applies to all of the given identifiers, then the result will be an empty list). WARNING: This service is deprecated and will be removed at some point. If you want to get multiple accounts, please instead use the service &#39;Get and search all accounts&#39; and pass a comma-separated list of identifiers as a parameter &#39;ids&#39;.
     * @param ids Comma-separated list of identifiers of requested accounts (required)
     * @return ApiResponse&lt;AccountList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public ApiResponse<AccountList> getMultipleAccountsWithHttpInfo(List<Long> ids) throws ApiException {
        com.squareup.okhttp.Call call = getMultipleAccountsValidateBeforeCall(ids, null, null);
        Type localVarReturnType = new TypeToken<AccountList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get multiple accounts (asynchronously)
     * Get a list of multiple bank accounts of the user that is authorized by the access_token. Must pass the accounts&#39; identifiers and the user&#39;s access_token. Accounts whose identifiers do not exist or do not relate to the authorized user will not be contained in the result (If this applies to all of the given identifiers, then the result will be an empty list). WARNING: This service is deprecated and will be removed at some point. If you want to get multiple accounts, please instead use the service &#39;Get and search all accounts&#39; and pass a comma-separated list of identifiers as a parameter &#39;ids&#39;.
     * @param ids Comma-separated list of identifiers of requested accounts (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call getMultipleAccountsAsync(List<Long> ids, final ApiCallback<AccountList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getMultipleAccountsValidateBeforeCall(ids, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccountList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for requestSepaDirectDebit
     * @param body Parameters for a SEPA direct debit request (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call requestSepaDirectDebitCall(RequestSepaDirectDebitParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/api/v1/accounts/requestSepaDirectDebit";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call requestSepaDirectDebitValidateBeforeCall(RequestSepaDirectDebitParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling requestSepaDirectDebit(Async)");
        }
        

        com.squareup.okhttp.Call call = requestSepaDirectDebitCall(body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Request SEPA Direct Debit
     * Submit a SEPA direct debit order for one or multiple direct debits. Returns an instruction from the bank server that can be displayed to the user (e.g. \&quot;Enter TAN\&quot;), typically in the language of the bank&#39;s country. The order remains valid for execution for only a couple of minutes (the exact validity period depends on the bank). For executing the order, use the /executeSepaDirectDebit service after calling this service. Note that when the order is not executed within the validity period, the bank might take note of that and - if happening too often - ultimately lock the user&#39;s online banking access. If there already exists a previously submitted but not yet executed SEPA order for this account (either another direct debit order, or a money transfer order), then that order will be discarded and replaced with the new order that is being created with this service call.&lt;br/&gt;&lt;br/&gt;Notes:&lt;br/&gt;&amp;bull; This service cannot be used for the demo account.&lt;br/&gt;&amp;bull; When using a two-step-procedure with flag &#39;implicitExecute&#39; &#x3D; true, then this service will immediately execute the direct debit. The response will not contain any challenge message and you won&#39;t be required to make a subsequent call to /executeSepaDirectDebit.
     * @param body Parameters for a SEPA direct debit request (required)
     * @return DirectDebitOrderingResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DirectDebitOrderingResponse requestSepaDirectDebit(RequestSepaDirectDebitParams body) throws ApiException {
        ApiResponse<DirectDebitOrderingResponse> resp = requestSepaDirectDebitWithHttpInfo(body);
        return resp.getData();
    }

    /**
     * Request SEPA Direct Debit
     * Submit a SEPA direct debit order for one or multiple direct debits. Returns an instruction from the bank server that can be displayed to the user (e.g. \&quot;Enter TAN\&quot;), typically in the language of the bank&#39;s country. The order remains valid for execution for only a couple of minutes (the exact validity period depends on the bank). For executing the order, use the /executeSepaDirectDebit service after calling this service. Note that when the order is not executed within the validity period, the bank might take note of that and - if happening too often - ultimately lock the user&#39;s online banking access. If there already exists a previously submitted but not yet executed SEPA order for this account (either another direct debit order, or a money transfer order), then that order will be discarded and replaced with the new order that is being created with this service call.&lt;br/&gt;&lt;br/&gt;Notes:&lt;br/&gt;&amp;bull; This service cannot be used for the demo account.&lt;br/&gt;&amp;bull; When using a two-step-procedure with flag &#39;implicitExecute&#39; &#x3D; true, then this service will immediately execute the direct debit. The response will not contain any challenge message and you won&#39;t be required to make a subsequent call to /executeSepaDirectDebit.
     * @param body Parameters for a SEPA direct debit request (required)
     * @return ApiResponse&lt;DirectDebitOrderingResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DirectDebitOrderingResponse> requestSepaDirectDebitWithHttpInfo(RequestSepaDirectDebitParams body) throws ApiException {
        com.squareup.okhttp.Call call = requestSepaDirectDebitValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<DirectDebitOrderingResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Request SEPA Direct Debit (asynchronously)
     * Submit a SEPA direct debit order for one or multiple direct debits. Returns an instruction from the bank server that can be displayed to the user (e.g. \&quot;Enter TAN\&quot;), typically in the language of the bank&#39;s country. The order remains valid for execution for only a couple of minutes (the exact validity period depends on the bank). For executing the order, use the /executeSepaDirectDebit service after calling this service. Note that when the order is not executed within the validity period, the bank might take note of that and - if happening too often - ultimately lock the user&#39;s online banking access. If there already exists a previously submitted but not yet executed SEPA order for this account (either another direct debit order, or a money transfer order), then that order will be discarded and replaced with the new order that is being created with this service call.&lt;br/&gt;&lt;br/&gt;Notes:&lt;br/&gt;&amp;bull; This service cannot be used for the demo account.&lt;br/&gt;&amp;bull; When using a two-step-procedure with flag &#39;implicitExecute&#39; &#x3D; true, then this service will immediately execute the direct debit. The response will not contain any challenge message and you won&#39;t be required to make a subsequent call to /executeSepaDirectDebit.
     * @param body Parameters for a SEPA direct debit request (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call requestSepaDirectDebitAsync(RequestSepaDirectDebitParams body, final ApiCallback<DirectDebitOrderingResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = requestSepaDirectDebitValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DirectDebitOrderingResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for requestSepaMoneyTransfer
     * @param body Parameters for a SEPA money transfer request (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call requestSepaMoneyTransferCall(RequestSepaMoneyTransferParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/api/v1/accounts/requestSepaMoneyTransfer";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call requestSepaMoneyTransferValidateBeforeCall(RequestSepaMoneyTransferParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling requestSepaMoneyTransfer(Async)");
        }
        

        com.squareup.okhttp.Call call = requestSepaMoneyTransferCall(body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Request SEPA Money Transfer
     * Submit a SEPA money transfer order for either a single or a collective money transfer. Returns an instruction from the bank server that can be displayed to the user (e.g. \&quot;Enter TAN\&quot;), typically in the language of the bank&#39;s country. The order remains valid for execution for only a couple of minutes (the exact validity period depends on the bank). For executing the order, use the /executeSepaMoneyTransfer service after calling this service. Note that when the order is not executed within the validity period, the bank might take note of that and - if happening too often - ultimately lock the user&#39;s online banking access. If there already exists a previously submitted but not yet executed SEPA order for this account (either another money transfer order, or a direct debit order), then that order will be discarded and replaced with the new order that is being created with this service call.&lt;br/&gt;&lt;br/&gt;Notes:&lt;br/&gt;&amp;bull; This service cannot be used for the demo account.&lt;br/&gt;&amp;bull; Some banks may require a multi-step authentication, in which case the service will respond with HTTP code 510 and an error message containing a challenge for the user from the bank. You must display the challenge message to the user, and then retry the service call, passing the user&#39;s answer to the bank&#39;s challenge in the &#39;challengeResponse&#39; field.&lt;br/&gt;&amp;bull; When using a two-step-procedure with flag &#39;implicitExecute&#39; &#x3D; true, then this service will immediately execute the money transfer. The response will not contain any challenge message and you won&#39;t be required to make a subsequent call to /executeSepaMoneyTransfer.
     * @param body Parameters for a SEPA money transfer request (required)
     * @return MoneyTransferOrderingResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public MoneyTransferOrderingResponse requestSepaMoneyTransfer(RequestSepaMoneyTransferParams body) throws ApiException {
        ApiResponse<MoneyTransferOrderingResponse> resp = requestSepaMoneyTransferWithHttpInfo(body);
        return resp.getData();
    }

    /**
     * Request SEPA Money Transfer
     * Submit a SEPA money transfer order for either a single or a collective money transfer. Returns an instruction from the bank server that can be displayed to the user (e.g. \&quot;Enter TAN\&quot;), typically in the language of the bank&#39;s country. The order remains valid for execution for only a couple of minutes (the exact validity period depends on the bank). For executing the order, use the /executeSepaMoneyTransfer service after calling this service. Note that when the order is not executed within the validity period, the bank might take note of that and - if happening too often - ultimately lock the user&#39;s online banking access. If there already exists a previously submitted but not yet executed SEPA order for this account (either another money transfer order, or a direct debit order), then that order will be discarded and replaced with the new order that is being created with this service call.&lt;br/&gt;&lt;br/&gt;Notes:&lt;br/&gt;&amp;bull; This service cannot be used for the demo account.&lt;br/&gt;&amp;bull; Some banks may require a multi-step authentication, in which case the service will respond with HTTP code 510 and an error message containing a challenge for the user from the bank. You must display the challenge message to the user, and then retry the service call, passing the user&#39;s answer to the bank&#39;s challenge in the &#39;challengeResponse&#39; field.&lt;br/&gt;&amp;bull; When using a two-step-procedure with flag &#39;implicitExecute&#39; &#x3D; true, then this service will immediately execute the money transfer. The response will not contain any challenge message and you won&#39;t be required to make a subsequent call to /executeSepaMoneyTransfer.
     * @param body Parameters for a SEPA money transfer request (required)
     * @return ApiResponse&lt;MoneyTransferOrderingResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<MoneyTransferOrderingResponse> requestSepaMoneyTransferWithHttpInfo(RequestSepaMoneyTransferParams body) throws ApiException {
        com.squareup.okhttp.Call call = requestSepaMoneyTransferValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<MoneyTransferOrderingResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Request SEPA Money Transfer (asynchronously)
     * Submit a SEPA money transfer order for either a single or a collective money transfer. Returns an instruction from the bank server that can be displayed to the user (e.g. \&quot;Enter TAN\&quot;), typically in the language of the bank&#39;s country. The order remains valid for execution for only a couple of minutes (the exact validity period depends on the bank). For executing the order, use the /executeSepaMoneyTransfer service after calling this service. Note that when the order is not executed within the validity period, the bank might take note of that and - if happening too often - ultimately lock the user&#39;s online banking access. If there already exists a previously submitted but not yet executed SEPA order for this account (either another money transfer order, or a direct debit order), then that order will be discarded and replaced with the new order that is being created with this service call.&lt;br/&gt;&lt;br/&gt;Notes:&lt;br/&gt;&amp;bull; This service cannot be used for the demo account.&lt;br/&gt;&amp;bull; Some banks may require a multi-step authentication, in which case the service will respond with HTTP code 510 and an error message containing a challenge for the user from the bank. You must display the challenge message to the user, and then retry the service call, passing the user&#39;s answer to the bank&#39;s challenge in the &#39;challengeResponse&#39; field.&lt;br/&gt;&amp;bull; When using a two-step-procedure with flag &#39;implicitExecute&#39; &#x3D; true, then this service will immediately execute the money transfer. The response will not contain any challenge message and you won&#39;t be required to make a subsequent call to /executeSepaMoneyTransfer.
     * @param body Parameters for a SEPA money transfer request (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call requestSepaMoneyTransferAsync(RequestSepaMoneyTransferParams body, final ApiCallback<MoneyTransferOrderingResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = requestSepaMoneyTransferValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MoneyTransferOrderingResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
