/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.MonthlyUserStats;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container for user information")
public class UserInfo {
    @SerializedName(value="userId")
    private String userId = null;
    @SerializedName(value="registrationDate")
    private String registrationDate = null;
    @SerializedName(value="deletionDate")
    private String deletionDate = null;
    @SerializedName(value="lastActiveDate")
    private String lastActiveDate = null;
    @SerializedName(value="bankConnectionCount")
    private Integer bankConnectionCount = null;
    @SerializedName(value="latestBankConnectionImportDate")
    private String latestBankConnectionImportDate = null;
    @SerializedName(value="latestBankConnectionDeletionDate")
    private String latestBankConnectionDeletionDate = null;
    @SerializedName(value="monthlyStats")
    private List<MonthlyUserStats> monthlyStats = null;

    public UserInfo userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(required=true, value="User's identifier")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public UserInfo registrationDate(String registrationDate) {
        this.registrationDate = registrationDate;
        return this;
    }

    @ApiModelProperty(required=true, value="User's registration date, in the format 'yyyy-MM-dd'")
    public String getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(String registrationDate) {
        this.registrationDate = registrationDate;
    }

    public UserInfo deletionDate(String deletionDate) {
        this.deletionDate = deletionDate;
        return this;
    }

    @ApiModelProperty(value="User's deletion date, in the format 'yyyy-MM-dd'. May be null if the user has not been deleted.")
    public String getDeletionDate() {
        return this.deletionDate;
    }

    public void setDeletionDate(String deletionDate) {
        this.deletionDate = deletionDate;
    }

    public UserInfo lastActiveDate(String lastActiveDate) {
        this.lastActiveDate = lastActiveDate;
        return this;
    }

    @ApiModelProperty(value="User's last active date, in the format 'yyyy-MM-dd'. May be null if the user has not yet logged in.")
    public String getLastActiveDate() {
        return this.lastActiveDate;
    }

    public void setLastActiveDate(String lastActiveDate) {
        this.lastActiveDate = lastActiveDate;
    }

    public UserInfo bankConnectionCount(Integer bankConnectionCount) {
        this.bankConnectionCount = bankConnectionCount;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of bank connections that currently exist for this user.")
    public Integer getBankConnectionCount() {
        return this.bankConnectionCount;
    }

    public void setBankConnectionCount(Integer bankConnectionCount) {
        this.bankConnectionCount = bankConnectionCount;
    }

    public UserInfo latestBankConnectionImportDate(String latestBankConnectionImportDate) {
        this.latestBankConnectionImportDate = latestBankConnectionImportDate;
        return this;
    }

    @ApiModelProperty(value="Latest date of when a bank connection was imported for this user, in the format 'yyyy-MM-dd'. This field is null when there has never been a bank connection import.")
    public String getLatestBankConnectionImportDate() {
        return this.latestBankConnectionImportDate;
    }

    public void setLatestBankConnectionImportDate(String latestBankConnectionImportDate) {
        this.latestBankConnectionImportDate = latestBankConnectionImportDate;
    }

    public UserInfo latestBankConnectionDeletionDate(String latestBankConnectionDeletionDate) {
        this.latestBankConnectionDeletionDate = latestBankConnectionDeletionDate;
        return this;
    }

    @ApiModelProperty(value="Latest date of when a bank connection was deleted for this user, in the format 'yyyy-MM-dd'. This field is null when there has never been a bank connection deletion.")
    public String getLatestBankConnectionDeletionDate() {
        return this.latestBankConnectionDeletionDate;
    }

    public void setLatestBankConnectionDeletionDate(String latestBankConnectionDeletionDate) {
        this.latestBankConnectionDeletionDate = latestBankConnectionDeletionDate;
    }

    public UserInfo monthlyStats(List<MonthlyUserStats> monthlyStats) {
        this.monthlyStats = monthlyStats;
        return this;
    }

    public UserInfo addMonthlyStatsItem(MonthlyUserStats monthlyStatsItem) {
        if (this.monthlyStats == null) {
            this.monthlyStats = new ArrayList<MonthlyUserStats>();
        }
        this.monthlyStats.add(monthlyStatsItem);
        return this;
    }

    @ApiModelProperty(value="Additional information about the user's data or activities, broken down in months. The list will by default contain an entry for each month starting with the month of when the user was registered, up to the current month. The date range may vary when you have limited it in the request. <br/><br/>Please note:<br/>&bull; this field is only set when 'includeMonthlyStats' = true, otherwise it will be null.<br/>&bull; the list is always ordered from the latest month first, to the oldest month last.<br/>&bull; the list will never contain an entry for a month that was prior to the month of when the user was registered, or after the month of when the user was deleted, even when you have explicitly set a respective date range. This means that the list may be empty if you are requesting a date range where the user didn't exist yet, or didn't exist any longer.")
    public List<MonthlyUserStats> getMonthlyStats() {
        return this.monthlyStats;
    }

    public void setMonthlyStats(List<MonthlyUserStats> monthlyStats) {
        this.monthlyStats = monthlyStats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserInfo userInfo = (UserInfo)o;
        return Objects.equals(this.userId, userInfo.userId) && Objects.equals(this.registrationDate, userInfo.registrationDate) && Objects.equals(this.deletionDate, userInfo.deletionDate) && Objects.equals(this.lastActiveDate, userInfo.lastActiveDate) && Objects.equals(this.bankConnectionCount, userInfo.bankConnectionCount) && Objects.equals(this.latestBankConnectionImportDate, userInfo.latestBankConnectionImportDate) && Objects.equals(this.latestBankConnectionDeletionDate, userInfo.latestBankConnectionDeletionDate) && Objects.equals(this.monthlyStats, userInfo.monthlyStats);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.registrationDate, this.deletionDate, this.lastActiveDate, this.bankConnectionCount, this.latestBankConnectionImportDate, this.latestBankConnectionDeletionDate, this.monthlyStats);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserInfo {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    registrationDate: ").append(this.toIndentedString(this.registrationDate)).append("\n");
        sb.append("    deletionDate: ").append(this.toIndentedString(this.deletionDate)).append("\n");
        sb.append("    lastActiveDate: ").append(this.toIndentedString(this.lastActiveDate)).append("\n");
        sb.append("    bankConnectionCount: ").append(this.toIndentedString(this.bankConnectionCount)).append("\n");
        sb.append("    latestBankConnectionImportDate: ").append(this.toIndentedString(this.latestBankConnectionImportDate)).append("\n");
        sb.append("    latestBankConnectionDeletionDate: ").append(this.toIndentedString(this.latestBankConnectionDeletionDate)).append("\n");
        sb.append("    monthlyStats: ").append(this.toIndentedString(this.monthlyStats)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

