/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Update transactions parameters")
public class UpdateTransactionsParams {
    @SerializedName(value="isNew")
    private Boolean isNew = false;
    @SerializedName(value="isPotentialDuplicate")
    private Boolean isPotentialDuplicate = false;
    @SerializedName(value="categoryId")
    private Long categoryId = null;
    @SerializedName(value="trainCategorization")
    private Boolean trainCategorization = false;
    @SerializedName(value="labelIds")
    private List<Long> labelIds = null;

    public UpdateTransactionsParams isNew(Boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    @ApiModelProperty(value="Whether this transactions should be flagged as 'new' or not. Any newly imported transaction will have this flag initially set to true. How you use this field is up to your interpretation. For example, you might want to set it to false once a user has clicked on/seen the transaction.")
    public Boolean isIsNew() {
        return this.isNew;
    }

    public void setIsNew(Boolean isNew) {
        this.isNew = isNew;
    }

    public UpdateTransactionsParams isPotentialDuplicate(Boolean isPotentialDuplicate) {
        this.isPotentialDuplicate = isPotentialDuplicate;
        return this;
    }

    @ApiModelProperty(value="You can set this field only to 'false'. finAPI marks transactions as a potential duplicates  when its internal duplicate detection algorithm is signaling so. Transactions that are flagged as duplicates can be deleted by the user. To prevent the user from deleting original transactions, which might lead to incorrect balances, it is not possible to manually set this flag to 'true'.")
    public Boolean isIsPotentialDuplicate() {
        return this.isPotentialDuplicate;
    }

    public void setIsPotentialDuplicate(Boolean isPotentialDuplicate) {
        this.isPotentialDuplicate = isPotentialDuplicate;
    }

    public UpdateTransactionsParams categoryId(Long categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @ApiModelProperty(value="Identifier of the new category to apply to the transaction. When updating the transaction's category, the category's fields 'id', 'name', 'parentId', 'parentName', and 'isCustom' will all get updated. To clear the category for the transaction, the categoryId field must be passed with value 0.")
    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public UpdateTransactionsParams trainCategorization(Boolean trainCategorization) {
        this.trainCategorization = trainCategorization;
        return this;
    }

    @ApiModelProperty(value="This field is only regarded when the field 'categoryId' is set. It controls whether finAPI's categorization system should learn from the given categorization(s). If set to 'true', then the user's categorization rules will be updated so that similar transactions will get categorized accordingly in future. If set to 'false', then the service will simply change the category of the given transaction(s), without updating the user's categorization rules. The field defaults to 'true' if not specified.")
    public Boolean isTrainCategorization() {
        return this.trainCategorization;
    }

    public void setTrainCategorization(Boolean trainCategorization) {
        this.trainCategorization = trainCategorization;
    }

    public UpdateTransactionsParams labelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
        return this;
    }

    public UpdateTransactionsParams addLabelIdsItem(Long labelIdsItem) {
        if (this.labelIds == null) {
            this.labelIds = new ArrayList<Long>();
        }
        this.labelIds.add(labelIdsItem);
        return this;
    }

    @ApiModelProperty(value="Identifiers of labels to apply to the transaction. To clear transactions' labels, pass an empty array of identifiers: '[]'")
    public List<Long> getLabelIds() {
        return this.labelIds;
    }

    public void setLabelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateTransactionsParams updateTransactionsParams = (UpdateTransactionsParams)o;
        return Objects.equals(this.isNew, updateTransactionsParams.isNew) && Objects.equals(this.isPotentialDuplicate, updateTransactionsParams.isPotentialDuplicate) && Objects.equals(this.categoryId, updateTransactionsParams.categoryId) && Objects.equals(this.trainCategorization, updateTransactionsParams.trainCategorization) && Objects.equals(this.labelIds, updateTransactionsParams.labelIds);
    }

    public int hashCode() {
        return Objects.hash(this.isNew, this.isPotentialDuplicate, this.categoryId, this.trainCategorization, this.labelIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateTransactionsParams {\n");
        sb.append("    isNew: ").append(this.toIndentedString(this.isNew)).append("\n");
        sb.append("    isPotentialDuplicate: ").append(this.toIndentedString(this.isPotentialDuplicate)).append("\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("    trainCategorization: ").append(this.toIndentedString(this.trainCategorization)).append("\n");
        sb.append("    labelIds: ").append(this.toIndentedString(this.labelIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

