/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.Bank;
import io.swagger.client.model.Paging;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container for banks with paging info")
public class PageableBankList {
    @SerializedName(value="banks")
    private List<Bank> banks = new ArrayList<Bank>();
    @SerializedName(value="paging")
    private Paging paging = null;

    public PageableBankList banks(List<Bank> banks) {
        this.banks = banks;
        return this;
    }

    public PageableBankList addBanksItem(Bank banksItem) {
        this.banks.add(banksItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Banks data")
    public List<Bank> getBanks() {
        return this.banks;
    }

    public void setBanks(List<Bank> banks) {
        this.banks = banks;
    }

    public PageableBankList paging(Paging paging) {
        this.paging = paging;
        return this;
    }

    @ApiModelProperty(required=true, value="Information for pagination")
    public Paging getPaging() {
        return this.paging;
    }

    public void setPaging(Paging paging) {
        this.paging = paging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageableBankList pageableBankList = (PageableBankList)o;
        return Objects.equals(this.banks, pageableBankList.banks) && Objects.equals(this.paging, pageableBankList.paging);
    }

    public int hashCode() {
        return Objects.hash(this.banks, this.paging);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageableBankList {\n");
        sb.append("    banks: ").append(this.toIndentedString(this.banks)).append("\n");
        sb.append("    paging: ").append(this.toIndentedString(this.paging)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

