/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Parameters of notification rule")
public class NotificationRuleParams {
    @SerializedName(value="triggerEvent")
    private TriggerEventEnum triggerEvent = null;
    @SerializedName(value="params")
    private Map<String, String> params = null;
    @SerializedName(value="callbackHandle")
    private String callbackHandle = null;
    @SerializedName(value="includeDetails")
    private Boolean includeDetails = false;

    public NotificationRuleParams triggerEvent(TriggerEventEnum triggerEvent) {
        this.triggerEvent = triggerEvent;
        return this;
    }

    @ApiModelProperty(required=true, value="Trigger event type")
    public TriggerEventEnum getTriggerEvent() {
        return this.triggerEvent;
    }

    public void setTriggerEvent(TriggerEventEnum triggerEvent) {
        this.triggerEvent = triggerEvent;
    }

    public NotificationRuleParams params(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public NotificationRuleParams putParamsItem(String key, String paramsItem) {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        this.params.put(key, paramsItem);
        return this;
    }

    @ApiModelProperty(value="Additional parameters that are specific to the chosen trigger event type. Please refer to the documentation for details.")
    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public NotificationRuleParams callbackHandle(String callbackHandle) {
        this.callbackHandle = callbackHandle;
        return this;
    }

    @ApiModelProperty(value="An arbitrary string that finAPI will include into the notifications that it sends based on this rule and that you can use to identify the notification in your application. For instance, you could include the identifier of the user that you create this rule for. Maximum allowed length of the string is 512 characters.<br/><br/>Note that for this parameter, you can pass the symbols '/', '=', '%' and '\"' in addition to the symbols that are generally allowed in finAPI (see https://finapi.zendesk.com/hc/en-us/articles/222013148). This was done to enable you to set Base64 encoded strings and JSON structures for the callback handle.")
    public String getCallbackHandle() {
        return this.callbackHandle;
    }

    public void setCallbackHandle(String callbackHandle) {
        this.callbackHandle = callbackHandle;
    }

    public NotificationRuleParams includeDetails(Boolean includeDetails) {
        this.includeDetails = includeDetails;
        return this;
    }

    @ApiModelProperty(value="Whether the notification messages that will be sent based on this rule should contain encrypted detailed data or not")
    public Boolean isIncludeDetails() {
        return this.includeDetails;
    }

    public void setIncludeDetails(Boolean includeDetails) {
        this.includeDetails = includeDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationRuleParams notificationRuleParams = (NotificationRuleParams)o;
        return Objects.equals((Object)this.triggerEvent, (Object)notificationRuleParams.triggerEvent) && Objects.equals(this.params, notificationRuleParams.params) && Objects.equals(this.callbackHandle, notificationRuleParams.callbackHandle) && Objects.equals(this.includeDetails, notificationRuleParams.includeDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.triggerEvent, this.params, this.callbackHandle, this.includeDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationRuleParams {\n");
        sb.append("    triggerEvent: ").append(this.toIndentedString((Object)this.triggerEvent)).append("\n");
        sb.append("    params: ").append(this.toIndentedString(this.params)).append("\n");
        sb.append("    callbackHandle: ").append(this.toIndentedString(this.callbackHandle)).append("\n");
        sb.append("    includeDetails: ").append(this.toIndentedString(this.includeDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TriggerEventEnum {
        NEW_ACCOUNT_BALANCE("NEW_ACCOUNT_BALANCE"),
        NEW_TRANSACTIONS("NEW_TRANSACTIONS"),
        BANK_LOGIN_ERROR("BANK_LOGIN_ERROR"),
        FOREIGN_MONEY_TRANSFER("FOREIGN_MONEY_TRANSFER"),
        LOW_ACCOUNT_BALANCE("LOW_ACCOUNT_BALANCE"),
        HIGH_TRANSACTION_AMOUNT("HIGH_TRANSACTION_AMOUNT"),
        CATEGORY_CASH_FLOW("CATEGORY_CASH_FLOW");

        private String value;

        private TriggerEventEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TriggerEventEnum fromValue(String text) {
            for (TriggerEventEnum b : TriggerEventEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TriggerEventEnum> {
            public void write(JsonWriter jsonWriter, TriggerEventEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TriggerEventEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TriggerEventEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

