/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information about a user's data or activities for a certain month")
public class MonthlyUserStats {
    @SerializedName(value="month")
    private String month = null;
    @SerializedName(value="minBankConnectionCount")
    private Integer minBankConnectionCount = null;
    @SerializedName(value="maxBankConnectionCount")
    private Integer maxBankConnectionCount = null;

    public MonthlyUserStats month(String month) {
        this.month = month;
        return this;
    }

    @ApiModelProperty(required=true, value="The month that the contained information applies to, in the format 'YYYY-MM'.")
    public String getMonth() {
        return this.month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public MonthlyUserStats minBankConnectionCount(Integer minBankConnectionCount) {
        this.minBankConnectionCount = minBankConnectionCount;
        return this;
    }

    @ApiModelProperty(required=true, value="Minimum count of bank connections that this user has had at any point during the month.")
    public Integer getMinBankConnectionCount() {
        return this.minBankConnectionCount;
    }

    public void setMinBankConnectionCount(Integer minBankConnectionCount) {
        this.minBankConnectionCount = minBankConnectionCount;
    }

    public MonthlyUserStats maxBankConnectionCount(Integer maxBankConnectionCount) {
        this.maxBankConnectionCount = maxBankConnectionCount;
        return this;
    }

    @ApiModelProperty(required=true, value="Maximum count of bank connections that this user has had at any point during the month.")
    public Integer getMaxBankConnectionCount() {
        return this.maxBankConnectionCount;
    }

    public void setMaxBankConnectionCount(Integer maxBankConnectionCount) {
        this.maxBankConnectionCount = maxBankConnectionCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonthlyUserStats monthlyUserStats = (MonthlyUserStats)o;
        return Objects.equals(this.month, monthlyUserStats.month) && Objects.equals(this.minBankConnectionCount, monthlyUserStats.minBankConnectionCount) && Objects.equals(this.maxBankConnectionCount, monthlyUserStats.maxBankConnectionCount);
    }

    public int hashCode() {
        return Objects.hash(this.month, this.minBankConnectionCount, this.maxBankConnectionCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonthlyUserStats {\n");
        sb.append("    month: ").append(this.toIndentedString(this.month)).append("\n");
        sb.append("    minBankConnectionCount: ").append(this.toIndentedString(this.minBankConnectionCount)).append("\n");
        sb.append("    maxBankConnectionCount: ").append(this.toIndentedString(this.maxBankConnectionCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

