/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container for bank connection import parameters")
public class ImportBankConnectionParams {
    @SerializedName(value="bankId")
    private Long bankId = null;
    @SerializedName(value="bankingUserId")
    private String bankingUserId = null;
    @SerializedName(value="bankingCustomerId")
    private String bankingCustomerId = null;
    @SerializedName(value="bankingPin")
    private String bankingPin = null;
    @SerializedName(value="storePin")
    private Boolean storePin = false;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="skipPositionsDownload")
    private Boolean skipPositionsDownload = false;
    @SerializedName(value="loadOwnerData")
    private Boolean loadOwnerData = false;
    @SerializedName(value="maxDaysForDownload")
    private Integer maxDaysForDownload = null;
    @SerializedName(value="accountTypeIds")
    private List<Long> accountTypeIds = null;
    @SerializedName(value="challengeResponse")
    private String challengeResponse = null;

    public ImportBankConnectionParams bankId(Long bankId) {
        this.bankId = bankId;
        return this;
    }

    @ApiModelProperty(required=true, value="Bank Identifier")
    public Long getBankId() {
        return this.bankId;
    }

    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }

    public ImportBankConnectionParams bankingUserId(String bankingUserId) {
        this.bankingUserId = bankingUserId;
        return this;
    }

    @ApiModelProperty(value="Online banking user ID credential. When importing the 'demo connection', you may leave this field unset. Max length: 64.")
    public String getBankingUserId() {
        return this.bankingUserId;
    }

    public void setBankingUserId(String bankingUserId) {
        this.bankingUserId = bankingUserId;
    }

    public ImportBankConnectionParams bankingCustomerId(String bankingCustomerId) {
        this.bankingCustomerId = bankingCustomerId;
        return this;
    }

    @ApiModelProperty(value="Online banking customer ID credential (for most banks this field can remain unset). Max length: 64.")
    public String getBankingCustomerId() {
        return this.bankingCustomerId;
    }

    public void setBankingCustomerId(String bankingCustomerId) {
        this.bankingCustomerId = bankingCustomerId;
    }

    public ImportBankConnectionParams bankingPin(String bankingPin) {
        this.bankingPin = bankingPin;
        return this;
    }

    @ApiModelProperty(value="Online banking PIN. When importing the 'demo connection', you may leave this field unset. Any symbols are allowed. Max length: 170.")
    public String getBankingPin() {
        return this.bankingPin;
    }

    public void setBankingPin(String bankingPin) {
        this.bankingPin = bankingPin;
    }

    public ImportBankConnectionParams storePin(Boolean storePin) {
        this.storePin = storePin;
        return this;
    }

    @ApiModelProperty(value="Whether to store the PIN. If the PIN is stored, it is not required to pass the PIN again when updating this bank connection or executing orders (like money transfers). Default is false. <br/><br/>NOTE: Before you set this field to true, please regard the 'pinsAreVolatile' flag of this connection's bank.")
    public Boolean isStorePin() {
        return this.storePin;
    }

    public void setStorePin(Boolean storePin) {
        this.storePin = storePin;
    }

    public ImportBankConnectionParams name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Custom name for the bank connection. Maximum length is 64. If you do not want to set a name, you can leave this field unset.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ImportBankConnectionParams skipPositionsDownload(Boolean skipPositionsDownload) {
        this.skipPositionsDownload = skipPositionsDownload;
        return this;
    }

    @ApiModelProperty(value="Whether to skip the download of transactions and securities or not. If set to true, then finAPI will download just the accounts list with the accounts' information (like account name, number, holder, etc), as well as the accounts' balances (if possible), but skip the download of transactions and securities. Default is false.<br/><br/>NOTES:<br/>&bull; If you skip the download of transactions and securities during an import or update, you can still download them on a later update (though you might not get all positions at a later point, because the date range in which the bank servers provide this data is usually limited). However, once finAPI has downloaded the transactions or securities for the first time, you will not be able to go back to skipping the download of transactions and securities! In other words: Once you make your first request with skipPositionsDownload=false for a certain bank connection, you will no longer be able to make a request with skipPositionsDownload=true for that same bank connection.<br/>&bull; If this bank connection is updated via finAPI's automatic batch update, then transactions and security positions <u>will</u> be downloaded in any case!<br/>&bull; For security accounts, skipping the downloading of the securities might result in the account's balance also not being downloaded.<br/>&bull; For Bausparen accounts, this field is ignored. finAPI will always download transactions for Bausparen accounts.<br/><br/><b>This flag is currently not guaranteed to work for non-German banks!</b>")
    public Boolean isSkipPositionsDownload() {
        return this.skipPositionsDownload;
    }

    public void setSkipPositionsDownload(Boolean skipPositionsDownload) {
        this.skipPositionsDownload = skipPositionsDownload;
    }

    public ImportBankConnectionParams loadOwnerData(Boolean loadOwnerData) {
        this.loadOwnerData = loadOwnerData;
        return this;
    }

    @ApiModelProperty(value="Whether to load information about the bank connection owner(s) - see field 'owners'. Default value is 'false'.")
    public Boolean isLoadOwnerData() {
        return this.loadOwnerData;
    }

    public void setLoadOwnerData(Boolean loadOwnerData) {
        this.loadOwnerData = loadOwnerData;
    }

    public ImportBankConnectionParams maxDaysForDownload(Integer maxDaysForDownload) {
        this.maxDaysForDownload = maxDaysForDownload;
        return this;
    }

    @ApiModelProperty(value="Use this parameter if you want to limit the date range for transactions download. The value depicts the number of days that finAPI will download transactions for, starting from - and including - today. For example, if you want to download only transactions from within the past 30 days (including today), then pass the value 30. The minimum allowed value is 14, the maximum value is 3650. You may also pass the value 0 though (which is also the default value when you do not specify this parameter), in which case there will be no limit to the transactions download and finAPI will try to get all transactions that it can. Please note that when you specify the parameter there is no guarantee that finAPI will actually download transactions for the entire given date range, as the bank servers may limit the date range on their own. Also note that this parameter only applies to transactions, not to security positions; finAPI will always download all positions that it can get. At last, please note that this parameter is ignored when importing the 'demo connection'.<br/><br/><b>This flag is currently not guaranteed to work for non-German banks!</b>")
    public Integer getMaxDaysForDownload() {
        return this.maxDaysForDownload;
    }

    public void setMaxDaysForDownload(Integer maxDaysForDownload) {
        this.maxDaysForDownload = maxDaysForDownload;
    }

    public ImportBankConnectionParams accountTypeIds(List<Long> accountTypeIds) {
        this.accountTypeIds = accountTypeIds;
        return this;
    }

    public ImportBankConnectionParams addAccountTypeIdsItem(Long accountTypeIdsItem) {
        if (this.accountTypeIds == null) {
            this.accountTypeIds = new ArrayList<Long>();
        }
        this.accountTypeIds.add(accountTypeIdsItem);
        return this;
    }

    @ApiModelProperty(value="Whitelist of identifiers of finAPI account types that are considered for the import. Only accounts whose type matches with one of the given types will be imported. Note that when the bank connection does not contain any accounts of the given types, the import will fail with error code NO_ACCOUNTS_FOR_TYPE_LIST. If no whitelist is given, then all accounts will be imported.<br/><br/><br/>1 = Checking,<br/>2 = Savings,<br/>3 = CreditCard,<br/>4 = Security,<br/>5 = Loan,<br/>6 = Pocket (DEPRECATED; will not be returned for any account unless this type has explicitly been set via PATCH),<br/>7 = Membership,<br/>8 = Bausparen<br/><br/><b>This flag is currently not guaranteed to work for non-German banks!</b>")
    public List<Long> getAccountTypeIds() {
        return this.accountTypeIds;
    }

    public void setAccountTypeIds(List<Long> accountTypeIds) {
        this.accountTypeIds = accountTypeIds;
    }

    public ImportBankConnectionParams challengeResponse(String challengeResponse) {
        this.challengeResponse = challengeResponse;
        return this;
    }

    @ApiModelProperty(value="Challenge response. This field should be set only when the previous attempt of importing the bank connection failed with HTTP code 510, i.e. the bank sent a challenge for the user for an additional authentication. In this case, this field must contain the response to the bank's challenge.")
    public String getChallengeResponse() {
        return this.challengeResponse;
    }

    public void setChallengeResponse(String challengeResponse) {
        this.challengeResponse = challengeResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportBankConnectionParams importBankConnectionParams = (ImportBankConnectionParams)o;
        return Objects.equals(this.bankId, importBankConnectionParams.bankId) && Objects.equals(this.bankingUserId, importBankConnectionParams.bankingUserId) && Objects.equals(this.bankingCustomerId, importBankConnectionParams.bankingCustomerId) && Objects.equals(this.bankingPin, importBankConnectionParams.bankingPin) && Objects.equals(this.storePin, importBankConnectionParams.storePin) && Objects.equals(this.name, importBankConnectionParams.name) && Objects.equals(this.skipPositionsDownload, importBankConnectionParams.skipPositionsDownload) && Objects.equals(this.loadOwnerData, importBankConnectionParams.loadOwnerData) && Objects.equals(this.maxDaysForDownload, importBankConnectionParams.maxDaysForDownload) && Objects.equals(this.accountTypeIds, importBankConnectionParams.accountTypeIds) && Objects.equals(this.challengeResponse, importBankConnectionParams.challengeResponse);
    }

    public int hashCode() {
        return Objects.hash(this.bankId, this.bankingUserId, this.bankingCustomerId, this.bankingPin, this.storePin, this.name, this.skipPositionsDownload, this.loadOwnerData, this.maxDaysForDownload, this.accountTypeIds, this.challengeResponse);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportBankConnectionParams {\n");
        sb.append("    bankId: ").append(this.toIndentedString(this.bankId)).append("\n");
        sb.append("    bankingUserId: ").append(this.toIndentedString(this.bankingUserId)).append("\n");
        sb.append("    bankingCustomerId: ").append(this.toIndentedString(this.bankingCustomerId)).append("\n");
        sb.append("    bankingPin: ").append(this.toIndentedString(this.bankingPin)).append("\n");
        sb.append("    storePin: ").append(this.toIndentedString(this.storePin)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    skipPositionsDownload: ").append(this.toIndentedString(this.skipPositionsDownload)).append("\n");
        sb.append("    loadOwnerData: ").append(this.toIndentedString(this.loadOwnerData)).append("\n");
        sb.append("    maxDaysForDownload: ").append(this.toIndentedString(this.maxDaysForDownload)).append("\n");
        sb.append("    accountTypeIds: ").append(this.toIndentedString(this.accountTypeIds)).append("\n");
        sb.append("    challengeResponse: ").append(this.toIndentedString(this.challengeResponse)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

