/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Container for bank connection edit params")
public class EditBankConnectionParams {
    @SerializedName(value="bankingUserId")
    private String bankingUserId = null;
    @SerializedName(value="bankingCustomerId")
    private String bankingCustomerId = null;
    @SerializedName(value="bankingPin")
    private String bankingPin = null;
    @SerializedName(value="defaultTwoStepProcedureId")
    private String defaultTwoStepProcedureId = null;
    @SerializedName(value="name")
    private String name = null;

    public EditBankConnectionParams bankingUserId(String bankingUserId) {
        this.bankingUserId = bankingUserId;
        return this;
    }

    @ApiModelProperty(value="New online banking user ID. If you do not want to change the current user ID let this field remain unset. Note that you cannot clear the current user ID, i.e. a bank connection must always have a user ID (except for when it is a 'demo connection'). Max length: 64.")
    public String getBankingUserId() {
        return this.bankingUserId;
    }

    public void setBankingUserId(String bankingUserId) {
        this.bankingUserId = bankingUserId;
    }

    public EditBankConnectionParams bankingCustomerId(String bankingCustomerId) {
        this.bankingCustomerId = bankingCustomerId;
        return this;
    }

    @ApiModelProperty(value="New online banking customer ID. If you do not want to change the current customer ID let this field remain unset. If you want to clear the current customer ID, set the field's value to an empty string (\"\"). Max length: 64.")
    public String getBankingCustomerId() {
        return this.bankingCustomerId;
    }

    public void setBankingCustomerId(String bankingCustomerId) {
        this.bankingCustomerId = bankingCustomerId;
    }

    public EditBankConnectionParams bankingPin(String bankingPin) {
        this.bankingPin = bankingPin;
        return this;
    }

    @ApiModelProperty(value="New online banking PIN. If you do not want to change the current PIN let this field remain unset. If you want to clear the current PIN, set the field's value to an empty string (\"\").<br/><br/>NOTE: Before you set this field, please regard the 'pinsAreVolatile' flag of this connection's bank. Any symbols are allowed. Max length: 170.")
    public String getBankingPin() {
        return this.bankingPin;
    }

    public void setBankingPin(String bankingPin) {
        this.bankingPin = bankingPin;
    }

    public EditBankConnectionParams defaultTwoStepProcedureId(String defaultTwoStepProcedureId) {
        this.defaultTwoStepProcedureId = defaultTwoStepProcedureId;
        return this;
    }

    @ApiModelProperty(value="New default two-step-procedure. Must match the 'procedureId' of one of the procedures that are listed in the bank connection. If you do not want to change this field let it remain unset. If you want to clear the current default two-step-procedure, set the field's value to an empty string (\"\").")
    public String getDefaultTwoStepProcedureId() {
        return this.defaultTwoStepProcedureId;
    }

    public void setDefaultTwoStepProcedureId(String defaultTwoStepProcedureId) {
        this.defaultTwoStepProcedureId = defaultTwoStepProcedureId;
    }

    public EditBankConnectionParams name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="New name for the bank connection. Maximum length is 64. If you do not want to change the current name let this field remain unset. If you want to clear the current name, set the field's value to an empty string (\"\").")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditBankConnectionParams editBankConnectionParams = (EditBankConnectionParams)o;
        return Objects.equals(this.bankingUserId, editBankConnectionParams.bankingUserId) && Objects.equals(this.bankingCustomerId, editBankConnectionParams.bankingCustomerId) && Objects.equals(this.bankingPin, editBankConnectionParams.bankingPin) && Objects.equals(this.defaultTwoStepProcedureId, editBankConnectionParams.defaultTwoStepProcedureId) && Objects.equals(this.name, editBankConnectionParams.name);
    }

    public int hashCode() {
        return Objects.hash(this.bankingUserId, this.bankingCustomerId, this.bankingPin, this.defaultTwoStepProcedureId, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EditBankConnectionParams {\n");
        sb.append("    bankingUserId: ").append(this.toIndentedString(this.bankingUserId)).append("\n");
        sb.append("    bankingCustomerId: ").append(this.toIndentedString(this.bankingCustomerId)).append("\n");
        sb.append("    bankingPin: ").append(this.toIndentedString(this.bankingPin)).append("\n");
        sb.append("    defaultTwoStepProcedureId: ").append(this.toIndentedString(this.defaultTwoStepProcedureId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

