/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Parameters for changing client credentials")
public class ChangeClientCredentialsParams {
    @SerializedName(value="clientId")
    private String clientId = null;
    @SerializedName(value="oldClientSecret")
    private String oldClientSecret = null;
    @SerializedName(value="newClientSecret")
    private String newClientSecret = null;

    public ChangeClientCredentialsParams clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @ApiModelProperty(required=true, value="client_id of the client that you want to change the secret for")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ChangeClientCredentialsParams oldClientSecret(String oldClientSecret) {
        this.oldClientSecret = oldClientSecret;
        return this;
    }

    @ApiModelProperty(required=true, value="Old (=current) client_secret")
    public String getOldClientSecret() {
        return this.oldClientSecret;
    }

    public void setOldClientSecret(String oldClientSecret) {
        this.oldClientSecret = oldClientSecret;
    }

    public ChangeClientCredentialsParams newClientSecret(String newClientSecret) {
        this.newClientSecret = newClientSecret;
        return this;
    }

    @ApiModelProperty(required=true, value="New client_secret. Required length is 36. Allowed symbols: Digits (0 through 9), lower-case and upper-case letters (A through Z), and the dash symbol (\"-\").")
    public String getNewClientSecret() {
        return this.newClientSecret;
    }

    public void setNewClientSecret(String newClientSecret) {
        this.newClientSecret = newClientSecret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeClientCredentialsParams changeClientCredentialsParams = (ChangeClientCredentialsParams)o;
        return Objects.equals(this.clientId, changeClientCredentialsParams.clientId) && Objects.equals(this.oldClientSecret, changeClientCredentialsParams.oldClientSecret) && Objects.equals(this.newClientSecret, changeClientCredentialsParams.newClientSecret);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.oldClientSecret, this.newClientSecret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChangeClientCredentialsParams {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    oldClientSecret: ").append(this.toIndentedString(this.oldClientSecret)).append("\n");
        sb.append("    newClientSecret: ").append(this.toIndentedString(this.newClientSecret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

