/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container for a bank's data")
public class Bank {
    @SerializedName(value="id")
    private Long id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="loginHint")
    private String loginHint = null;
    @SerializedName(value="bic")
    private String bic = null;
    @SerializedName(value="blz")
    private String blz = null;
    @SerializedName(value="blzs")
    private List<String> blzs = new ArrayList<String>();
    @SerializedName(value="loginFieldUserId")
    private String loginFieldUserId = null;
    @SerializedName(value="loginFieldCustomerId")
    private String loginFieldCustomerId = null;
    @SerializedName(value="loginFieldPin")
    private String loginFieldPin = null;
    @SerializedName(value="isSupported")
    private Boolean isSupported = false;
    @SerializedName(value="supportedDataSources")
    private List<SupportedDataSourcesEnum> supportedDataSources = new ArrayList<SupportedDataSourcesEnum>();
    @SerializedName(value="pinsAreVolatile")
    private Boolean pinsAreVolatile = false;
    @SerializedName(value="location")
    private String location = null;
    @SerializedName(value="city")
    private String city = null;
    @SerializedName(value="isTestBank")
    private Boolean isTestBank = false;
    @SerializedName(value="popularity")
    private Integer popularity = null;
    @SerializedName(value="health")
    private Integer health = null;
    @SerializedName(value="lastCommunicationAttempt")
    private String lastCommunicationAttempt = null;
    @SerializedName(value="lastSuccessfulCommunication")
    private String lastSuccessfulCommunication = null;

    public Bank id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Bank identifier.<br/><br/>NOTE: Do NOT assume that the identifiers of banks are the same across different finAPI environments. In fact, the identifiers may change whenever a new finAPI version is released, even within the same environment. The identifiers are meant to be used for references within the finAPI services only, but not for hard-coding them in your application. If you need to hard-code the usage of a certain bank within your application, please instead refer to the BLZ.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Bank name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of bank")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Bank loginHint(String loginHint) {
        this.loginHint = loginHint;
        return this;
    }

    @ApiModelProperty(value="Login hint. Contains a German message for the user that explains what kind of credentials are expected.<br/><br/>Please note that it is strongly recommended to always show the login hint to the user if there is one, as the credentials that finAPI requires for the bank might be different to the credentials that the user knows from the bank's website.<br/><br/>Also note that the contents of this field should always be interpreted as HTML, as the text might contain HTML tags for highlighted words, paragraphs, etc.")
    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public Bank bic(String bic) {
        this.bic = bic;
        return this;
    }

    @ApiModelProperty(value="BIC of bank")
    public String getBic() {
        return this.bic;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public Bank blz(String blz) {
        this.blz = blz;
        return this;
    }

    @ApiModelProperty(required=true, value="BLZ of bank")
    public String getBlz() {
        return this.blz;
    }

    public void setBlz(String blz) {
        this.blz = blz;
    }

    public Bank blzs(List<String> blzs) {
        this.blzs = blzs;
        return this;
    }

    public Bank addBlzsItem(String blzsItem) {
        this.blzs.add(blzsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of BLZs that belong to this bank. NOTE: This field is deprecated and will be removed at some point. Please refer to field 'blz' instead.")
    public List<String> getBlzs() {
        return this.blzs;
    }

    public void setBlzs(List<String> blzs) {
        this.blzs = blzs;
    }

    public Bank loginFieldUserId(String loginFieldUserId) {
        this.loginFieldUserId = loginFieldUserId;
        return this;
    }

    @ApiModelProperty(value="Label for the user ID login field, as it is called on the bank's website (e.g. \"Nutzerkennung\"). If this field is set (i.e. not null) then you should prompt your users to enter the required data in a text field which you can label with this field's value.")
    public String getLoginFieldUserId() {
        return this.loginFieldUserId;
    }

    public void setLoginFieldUserId(String loginFieldUserId) {
        this.loginFieldUserId = loginFieldUserId;
    }

    public Bank loginFieldCustomerId(String loginFieldCustomerId) {
        this.loginFieldCustomerId = loginFieldCustomerId;
        return this;
    }

    @ApiModelProperty(value="Label for the customer ID login field, as it is called on the bank's website (e.g. \"Kundennummer\"). If this field is set (i.e. not null) then you should prompt your users to enter the required data in a text field which you can label with this field's value.")
    public String getLoginFieldCustomerId() {
        return this.loginFieldCustomerId;
    }

    public void setLoginFieldCustomerId(String loginFieldCustomerId) {
        this.loginFieldCustomerId = loginFieldCustomerId;
    }

    public Bank loginFieldPin(String loginFieldPin) {
        this.loginFieldPin = loginFieldPin;
        return this;
    }

    @ApiModelProperty(value="Label for the PIN field, as it is called on the bank's website (mostly \"PIN\"). If this field is set (i.e. not null) then you should prompt your users to enter the required data in a text field which you can label with this field's value.")
    public String getLoginFieldPin() {
        return this.loginFieldPin;
    }

    public void setLoginFieldPin(String loginFieldPin) {
        this.loginFieldPin = loginFieldPin;
    }

    public Bank isSupported(Boolean isSupported) {
        this.isSupported = isSupported;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether this bank is supported by finAPI, i.e. whether you can import/update a bank connection of this bank.")
    public Boolean isIsSupported() {
        return this.isSupported;
    }

    public void setIsSupported(Boolean isSupported) {
        this.isSupported = isSupported;
    }

    public Bank supportedDataSources(List<SupportedDataSourcesEnum> supportedDataSources) {
        this.supportedDataSources = supportedDataSources;
        return this;
    }

    public Bank addSupportedDataSourcesItem(SupportedDataSourcesEnum supportedDataSourcesItem) {
        this.supportedDataSources.add(supportedDataSourcesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of the data sources that finAPI will use for data download for this bank. Possible values:</br></br>&bull; <code>FINTS_SERVER</code> - means that finAPI will download data via the bank's FinTS interface.</br>&bull; <code>WEB_SCRAPER</code> - means that finAPI will parse data from the bank's online banking website.</br></br>Note that this list will be empty for non-supported banks. Note also that web scraping might be disabled for your client (see GET /clientConfiguration). When this is the case, then finAPI will not use the web scraper for data download, and if the web scraper is the only supported data source of this bank, then finAPI will not allow to download any data for this bank at all (for details, see POST /bankConnections/import and POST /bankConnections/update).")
    public List<SupportedDataSourcesEnum> getSupportedDataSources() {
        return this.supportedDataSources;
    }

    public void setSupportedDataSources(List<SupportedDataSourcesEnum> supportedDataSources) {
        this.supportedDataSources = supportedDataSources;
    }

    public Bank pinsAreVolatile(Boolean pinsAreVolatile) {
        this.pinsAreVolatile = pinsAreVolatile;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the PINs that are used for authentication with the bank are volatile. If the PINs are volatile, it means that a PIN is usually valid only for a single authentication, and is then invalidated. If a bank uses volatile PINs, it is strongly inadvisable to store PINs in finAPI, as a stored PIN will not work for future authentications.")
    public Boolean isPinsAreVolatile() {
        return this.pinsAreVolatile;
    }

    public void setPinsAreVolatile(Boolean pinsAreVolatile) {
        this.pinsAreVolatile = pinsAreVolatile;
    }

    public Bank location(String location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(value="Bank location (two-letter country code; ISO 3166 ALPHA-2). Note that when this field is not set, it means that this bank depicts an international institute which is not bound to any specific country.")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Bank city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="City that this bank is located in. Note that this field may not be set for some banks.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Bank isTestBank(Boolean isTestBank) {
        this.isTestBank = isTestBank;
        return this;
    }

    @ApiModelProperty(required=true, value="If true, then this bank does not depict a real bank, but rather a testing endpoint provided by a bank or by finAPI. You probably want to regard these banks only during the development of your application, but not in production. You can filter out these banks in production by making sure that the 'isTestBank' parameter is always set to 'false' whenever your application is calling the 'Get and search all banks' service.")
    public Boolean isIsTestBank() {
        return this.isTestBank;
    }

    public void setIsTestBank(Boolean isTestBank) {
        this.isTestBank = isTestBank;
    }

    public Bank popularity(Integer popularity) {
        this.popularity = popularity;
        return this;
    }

    @ApiModelProperty(required=true, value="Popularity of this bank with your users (mandator-wide, i.e. across all of your clients). The value equals the number of bank connections that are currently imported for this bank across all of your users (which means it is a constantly adjusting value). You can use this field for statistical evaluation, and also for ordering bank search results (see service 'Get and search all banks').")
    public Integer getPopularity() {
        return this.popularity;
    }

    public void setPopularity(Integer popularity) {
        this.popularity = popularity;
    }

    public Bank health(Integer health) {
        this.health = health;
        return this;
    }

    @ApiModelProperty(required=true, value="The health status of this bank. This is a value between 0 and 100, depicting the percentage of successful communication attempts with this bank during the latest couple of bank connection imports or updates (across the entire finAPI system). Note that 'successful' means that there was no technical error trying to establish a communication with the bank. Non-technical errors (like incorrect credentials) are regarded successful communication attempts.")
    public Integer getHealth() {
        return this.health;
    }

    public void setHealth(Integer health) {
        this.health = health;
    }

    public Bank lastCommunicationAttempt(String lastCommunicationAttempt) {
        this.lastCommunicationAttempt = lastCommunicationAttempt;
        return this;
    }

    @ApiModelProperty(value="Time of the last communication attempt with this bank during a bank connection import or update (across the entire finAPI system). The value is returned in the format 'yyyy-MM-dd HH:mm:ss.SSS' (german time).")
    public String getLastCommunicationAttempt() {
        return this.lastCommunicationAttempt;
    }

    public void setLastCommunicationAttempt(String lastCommunicationAttempt) {
        this.lastCommunicationAttempt = lastCommunicationAttempt;
    }

    public Bank lastSuccessfulCommunication(String lastSuccessfulCommunication) {
        this.lastSuccessfulCommunication = lastSuccessfulCommunication;
        return this;
    }

    @ApiModelProperty(value="Time of the last successful communication with this bank during a bank connection import or update (across the entire finAPI system). The value is returned in the format 'yyyy-MM-dd HH:mm:ss.SSS' (german time).")
    public String getLastSuccessfulCommunication() {
        return this.lastSuccessfulCommunication;
    }

    public void setLastSuccessfulCommunication(String lastSuccessfulCommunication) {
        this.lastSuccessfulCommunication = lastSuccessfulCommunication;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bank bank = (Bank)o;
        return Objects.equals(this.id, bank.id) && Objects.equals(this.name, bank.name) && Objects.equals(this.loginHint, bank.loginHint) && Objects.equals(this.bic, bank.bic) && Objects.equals(this.blz, bank.blz) && Objects.equals(this.blzs, bank.blzs) && Objects.equals(this.loginFieldUserId, bank.loginFieldUserId) && Objects.equals(this.loginFieldCustomerId, bank.loginFieldCustomerId) && Objects.equals(this.loginFieldPin, bank.loginFieldPin) && Objects.equals(this.isSupported, bank.isSupported) && Objects.equals(this.supportedDataSources, bank.supportedDataSources) && Objects.equals(this.pinsAreVolatile, bank.pinsAreVolatile) && Objects.equals(this.location, bank.location) && Objects.equals(this.city, bank.city) && Objects.equals(this.isTestBank, bank.isTestBank) && Objects.equals(this.popularity, bank.popularity) && Objects.equals(this.health, bank.health) && Objects.equals(this.lastCommunicationAttempt, bank.lastCommunicationAttempt) && Objects.equals(this.lastSuccessfulCommunication, bank.lastSuccessfulCommunication);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.loginHint, this.bic, this.blz, this.blzs, this.loginFieldUserId, this.loginFieldCustomerId, this.loginFieldPin, this.isSupported, this.supportedDataSources, this.pinsAreVolatile, this.location, this.city, this.isTestBank, this.popularity, this.health, this.lastCommunicationAttempt, this.lastSuccessfulCommunication);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Bank {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    loginHint: ").append(this.toIndentedString(this.loginHint)).append("\n");
        sb.append("    bic: ").append(this.toIndentedString(this.bic)).append("\n");
        sb.append("    blz: ").append(this.toIndentedString(this.blz)).append("\n");
        sb.append("    blzs: ").append(this.toIndentedString(this.blzs)).append("\n");
        sb.append("    loginFieldUserId: ").append(this.toIndentedString(this.loginFieldUserId)).append("\n");
        sb.append("    loginFieldCustomerId: ").append(this.toIndentedString(this.loginFieldCustomerId)).append("\n");
        sb.append("    loginFieldPin: ").append(this.toIndentedString(this.loginFieldPin)).append("\n");
        sb.append("    isSupported: ").append(this.toIndentedString(this.isSupported)).append("\n");
        sb.append("    supportedDataSources: ").append(this.toIndentedString(this.supportedDataSources)).append("\n");
        sb.append("    pinsAreVolatile: ").append(this.toIndentedString(this.pinsAreVolatile)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    isTestBank: ").append(this.toIndentedString(this.isTestBank)).append("\n");
        sb.append("    popularity: ").append(this.toIndentedString(this.popularity)).append("\n");
        sb.append("    health: ").append(this.toIndentedString(this.health)).append("\n");
        sb.append("    lastCommunicationAttempt: ").append(this.toIndentedString(this.lastCommunicationAttempt)).append("\n");
        sb.append("    lastSuccessfulCommunication: ").append(this.toIndentedString(this.lastSuccessfulCommunication)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SupportedDataSourcesEnum {
        WEB_SCRAPER("WEB_SCRAPER"),
        FINTS_SERVER("FINTS_SERVER");

        private String value;

        private SupportedDataSourcesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SupportedDataSourcesEnum fromValue(String text) {
            for (SupportedDataSourcesEnum b : SupportedDataSourcesEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SupportedDataSourcesEnum> {
            public void write(JsonWriter jsonWriter, SupportedDataSourcesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SupportedDataSourcesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SupportedDataSourcesEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

