/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="User access token info")
public class AccessToken {
    @SerializedName(value="access_token")
    private String accessToken = null;
    @SerializedName(value="token_type")
    private String tokenType = null;
    @SerializedName(value="refresh_token")
    private String refreshToken = null;
    @SerializedName(value="expires_in")
    private Integer expiresIn = null;
    @SerializedName(value="scope")
    private String scope = null;

    public AccessToken accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="Access token. Token has a length of up to 128 characters.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public AccessToken tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @ApiModelProperty(required=true, value="Token type (it's always 'bearer')")
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public AccessToken refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @ApiModelProperty(value="Refresh token. Only set in case of grant_type='password'. Token has a length of up to 128 characters.")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public AccessToken expiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @ApiModelProperty(required=true, value="Expiration time in seconds. A value of 0 means that the token never expires (unless it is explicitly invalidated, e.g. by revocation, or when a user gets locked).")
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public AccessToken scope(String scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(required=true, value="Requested scopes (it's always 'all')")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken accessToken = (AccessToken)o;
        return Objects.equals(this.accessToken, accessToken.accessToken) && Objects.equals(this.tokenType, accessToken.tokenType) && Objects.equals(this.refreshToken, accessToken.refreshToken) && Objects.equals(this.expiresIn, accessToken.expiresIn) && Objects.equals(this.scope, accessToken.scope);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.refreshToken, this.expiresIn, this.scope);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccessToken {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

