/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.Account;
import io.swagger.client.model.AccountList;
import io.swagger.client.model.AccountParams;
import io.swagger.client.model.BankResponse;
import io.swagger.client.model.DailyBalanceList;
import io.swagger.client.model.DirectDebitOrderingResponse;
import io.swagger.client.model.ExecuteSepaDirectDebitParams;
import io.swagger.client.model.ExecuteSepaMoneyTransferParams;
import io.swagger.client.model.IdentifierList;
import io.swagger.client.model.MoneyTransferOrderingResponse;
import io.swagger.client.model.RequestSepaDirectDebitParams;
import io.swagger.client.model.RequestSepaMoneyTransferParams;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AccountsApi {
    private ApiClient apiClient;

    public AccountsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteAccountCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/accounts/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAccountValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteAccount(Async)");
        }
        Call call = this.deleteAccountCall(id, progressListener, progressRequestListener);
        return call;
    }

    public void deleteAccount(Long id) throws ApiException {
        this.deleteAccountWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteAccountWithHttpInfo(Long id) throws ApiException {
        Call call = this.deleteAccountValidateBeforeCall(id, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteAccountAsync(Long id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAccountValidateBeforeCall(id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteAllAccountsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAllAccountsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.deleteAllAccountsCall(progressListener, progressRequestListener);
        return call;
    }

    public IdentifierList deleteAllAccounts() throws ApiException {
        ApiResponse<IdentifierList> resp = this.deleteAllAccountsWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<IdentifierList> deleteAllAccountsWithHttpInfo() throws ApiException {
        Call call = this.deleteAllAccountsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAllAccountsAsync(final ApiCallback<IdentifierList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAllAccountsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IdentifierList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call editAccountCall(Long id, AccountParams body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AccountParams localVarPostBody = body;
        String localVarPath = "/api/v1/accounts/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call editAccountValidateBeforeCall(Long id, AccountParams body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling editAccount(Async)");
        }
        Call call = this.editAccountCall(id, body, progressListener, progressRequestListener);
        return call;
    }

    public Account editAccount(Long id, AccountParams body) throws ApiException {
        ApiResponse<Account> resp = this.editAccountWithHttpInfo(id, body);
        return resp.getData();
    }

    public ApiResponse<Account> editAccountWithHttpInfo(Long id, AccountParams body) throws ApiException {
        Call call = this.editAccountValidateBeforeCall(id, body, null, null);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call editAccountAsync(Long id, AccountParams body, final ApiCallback<Account> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.editAccountValidateBeforeCall(id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call executeSepaDirectDebitCall(ExecuteSepaDirectDebitParams body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ExecuteSepaDirectDebitParams localVarPostBody = body;
        String localVarPath = "/api/v1/accounts/executeSepaDirectDebit";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call executeSepaDirectDebitValidateBeforeCall(ExecuteSepaDirectDebitParams body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling executeSepaDirectDebit(Async)");
        }
        Call call = this.executeSepaDirectDebitCall(body, progressListener, progressRequestListener);
        return call;
    }

    public BankResponse executeSepaDirectDebit(ExecuteSepaDirectDebitParams body) throws ApiException {
        ApiResponse<BankResponse> resp = this.executeSepaDirectDebitWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<BankResponse> executeSepaDirectDebitWithHttpInfo(ExecuteSepaDirectDebitParams body) throws ApiException {
        Call call = this.executeSepaDirectDebitValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<BankResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call executeSepaDirectDebitAsync(ExecuteSepaDirectDebitParams body, final ApiCallback<BankResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.executeSepaDirectDebitValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BankResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call executeSepaMoneyTransferCall(ExecuteSepaMoneyTransferParams body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ExecuteSepaMoneyTransferParams localVarPostBody = body;
        String localVarPath = "/api/v1/accounts/executeSepaMoneyTransfer";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call executeSepaMoneyTransferValidateBeforeCall(ExecuteSepaMoneyTransferParams body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling executeSepaMoneyTransfer(Async)");
        }
        Call call = this.executeSepaMoneyTransferCall(body, progressListener, progressRequestListener);
        return call;
    }

    public BankResponse executeSepaMoneyTransfer(ExecuteSepaMoneyTransferParams body) throws ApiException {
        ApiResponse<BankResponse> resp = this.executeSepaMoneyTransferWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<BankResponse> executeSepaMoneyTransferWithHttpInfo(ExecuteSepaMoneyTransferParams body) throws ApiException {
        Call call = this.executeSepaMoneyTransferValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<BankResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call executeSepaMoneyTransferAsync(ExecuteSepaMoneyTransferParams body, final ApiCallback<BankResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.executeSepaMoneyTransferValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BankResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAccountCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/accounts/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAccountValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getAccount(Async)");
        }
        Call call = this.getAccountCall(id, progressListener, progressRequestListener);
        return call;
    }

    public Account getAccount(Long id) throws ApiException {
        ApiResponse<Account> resp = this.getAccountWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<Account> getAccountWithHttpInfo(Long id) throws ApiException {
        Call call = this.getAccountValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAccountAsync(Long id, final ApiCallback<Account> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAccountValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAndSearchAllAccountsCall(List<Long> ids, String search, List<Long> accountTypeIds, List<Long> bankConnectionIds, String minLastSuccessfulUpdate, String maxLastSuccessfulUpdate, BigDecimal minBalance, BigDecimal maxBalance, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ids != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "ids", ids));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search", search));
        }
        if (accountTypeIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "accountTypeIds", accountTypeIds));
        }
        if (bankConnectionIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "bankConnectionIds", bankConnectionIds));
        }
        if (minLastSuccessfulUpdate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("minLastSuccessfulUpdate", minLastSuccessfulUpdate));
        }
        if (maxLastSuccessfulUpdate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxLastSuccessfulUpdate", maxLastSuccessfulUpdate));
        }
        if (minBalance != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("minBalance", minBalance));
        }
        if (maxBalance != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxBalance", maxBalance));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAndSearchAllAccountsValidateBeforeCall(List<Long> ids, String search, List<Long> accountTypeIds, List<Long> bankConnectionIds, String minLastSuccessfulUpdate, String maxLastSuccessfulUpdate, BigDecimal minBalance, BigDecimal maxBalance, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAndSearchAllAccountsCall(ids, search, accountTypeIds, bankConnectionIds, minLastSuccessfulUpdate, maxLastSuccessfulUpdate, minBalance, maxBalance, progressListener, progressRequestListener);
        return call;
    }

    public AccountList getAndSearchAllAccounts(List<Long> ids, String search, List<Long> accountTypeIds, List<Long> bankConnectionIds, String minLastSuccessfulUpdate, String maxLastSuccessfulUpdate, BigDecimal minBalance, BigDecimal maxBalance) throws ApiException {
        ApiResponse<AccountList> resp = this.getAndSearchAllAccountsWithHttpInfo(ids, search, accountTypeIds, bankConnectionIds, minLastSuccessfulUpdate, maxLastSuccessfulUpdate, minBalance, maxBalance);
        return resp.getData();
    }

    public ApiResponse<AccountList> getAndSearchAllAccountsWithHttpInfo(List<Long> ids, String search, List<Long> accountTypeIds, List<Long> bankConnectionIds, String minLastSuccessfulUpdate, String maxLastSuccessfulUpdate, BigDecimal minBalance, BigDecimal maxBalance) throws ApiException {
        Call call = this.getAndSearchAllAccountsValidateBeforeCall(ids, search, accountTypeIds, bankConnectionIds, minLastSuccessfulUpdate, maxLastSuccessfulUpdate, minBalance, maxBalance, null, null);
        Type localVarReturnType = new TypeToken<AccountList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAndSearchAllAccountsAsync(List<Long> ids, String search, List<Long> accountTypeIds, List<Long> bankConnectionIds, String minLastSuccessfulUpdate, String maxLastSuccessfulUpdate, BigDecimal minBalance, BigDecimal maxBalance, final ApiCallback<AccountList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAndSearchAllAccountsValidateBeforeCall(ids, search, accountTypeIds, bankConnectionIds, minLastSuccessfulUpdate, maxLastSuccessfulUpdate, minBalance, maxBalance, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccountList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDailyBalancesCall(List<Long> accountIds, String startDate, String endDate, Boolean withProjection, Integer page, Integer perPage, List<String> order, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/accounts/dailyBalances";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "accountIds", accountIds));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        if (withProjection != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("withProjection", withProjection));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("perPage", perPage));
        }
        if (order != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "order", order));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDailyBalancesValidateBeforeCall(List<Long> accountIds, String startDate, String endDate, Boolean withProjection, Integer page, Integer perPage, List<String> order, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getDailyBalancesCall(accountIds, startDate, endDate, withProjection, page, perPage, order, progressListener, progressRequestListener);
        return call;
    }

    public DailyBalanceList getDailyBalances(List<Long> accountIds, String startDate, String endDate, Boolean withProjection, Integer page, Integer perPage, List<String> order) throws ApiException {
        ApiResponse<DailyBalanceList> resp = this.getDailyBalancesWithHttpInfo(accountIds, startDate, endDate, withProjection, page, perPage, order);
        return resp.getData();
    }

    public ApiResponse<DailyBalanceList> getDailyBalancesWithHttpInfo(List<Long> accountIds, String startDate, String endDate, Boolean withProjection, Integer page, Integer perPage, List<String> order) throws ApiException {
        Call call = this.getDailyBalancesValidateBeforeCall(accountIds, startDate, endDate, withProjection, page, perPage, order, null, null);
        Type localVarReturnType = new TypeToken<DailyBalanceList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDailyBalancesAsync(List<Long> accountIds, String startDate, String endDate, Boolean withProjection, Integer page, Integer perPage, List<String> order, final ApiCallback<DailyBalanceList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDailyBalancesValidateBeforeCall(accountIds, startDate, endDate, withProjection, page, perPage, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DailyBalanceList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    @Deprecated
    public Call getMultipleAccountsCall(List<Long> ids, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/accounts/{ids}".replaceAll("\\{ids\\}", this.apiClient.escapeString(ids.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    private Call getMultipleAccountsValidateBeforeCall(List<Long> ids, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling getMultipleAccounts(Async)");
        }
        Call call = this.getMultipleAccountsCall(ids, progressListener, progressRequestListener);
        return call;
    }

    @Deprecated
    public AccountList getMultipleAccounts(List<Long> ids) throws ApiException {
        ApiResponse<AccountList> resp = this.getMultipleAccountsWithHttpInfo(ids);
        return resp.getData();
    }

    @Deprecated
    public ApiResponse<AccountList> getMultipleAccountsWithHttpInfo(List<Long> ids) throws ApiException {
        Call call = this.getMultipleAccountsValidateBeforeCall(ids, null, null);
        Type localVarReturnType = new TypeToken<AccountList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    @Deprecated
    public Call getMultipleAccountsAsync(List<Long> ids, final ApiCallback<AccountList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMultipleAccountsValidateBeforeCall(ids, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccountList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call requestSepaDirectDebitCall(RequestSepaDirectDebitParams body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RequestSepaDirectDebitParams localVarPostBody = body;
        String localVarPath = "/api/v1/accounts/requestSepaDirectDebit";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call requestSepaDirectDebitValidateBeforeCall(RequestSepaDirectDebitParams body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling requestSepaDirectDebit(Async)");
        }
        Call call = this.requestSepaDirectDebitCall(body, progressListener, progressRequestListener);
        return call;
    }

    public DirectDebitOrderingResponse requestSepaDirectDebit(RequestSepaDirectDebitParams body) throws ApiException {
        ApiResponse<DirectDebitOrderingResponse> resp = this.requestSepaDirectDebitWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<DirectDebitOrderingResponse> requestSepaDirectDebitWithHttpInfo(RequestSepaDirectDebitParams body) throws ApiException {
        Call call = this.requestSepaDirectDebitValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<DirectDebitOrderingResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call requestSepaDirectDebitAsync(RequestSepaDirectDebitParams body, final ApiCallback<DirectDebitOrderingResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.requestSepaDirectDebitValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DirectDebitOrderingResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call requestSepaMoneyTransferCall(RequestSepaMoneyTransferParams body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RequestSepaMoneyTransferParams localVarPostBody = body;
        String localVarPath = "/api/v1/accounts/requestSepaMoneyTransfer";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call requestSepaMoneyTransferValidateBeforeCall(RequestSepaMoneyTransferParams body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling requestSepaMoneyTransfer(Async)");
        }
        Call call = this.requestSepaMoneyTransferCall(body, progressListener, progressRequestListener);
        return call;
    }

    public MoneyTransferOrderingResponse requestSepaMoneyTransfer(RequestSepaMoneyTransferParams body) throws ApiException {
        ApiResponse<MoneyTransferOrderingResponse> resp = this.requestSepaMoneyTransferWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<MoneyTransferOrderingResponse> requestSepaMoneyTransferWithHttpInfo(RequestSepaMoneyTransferParams body) throws ApiException {
        Call call = this.requestSepaMoneyTransferValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<MoneyTransferOrderingResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call requestSepaMoneyTransferAsync(RequestSepaMoneyTransferParams body, final ApiCallback<MoneyTransferOrderingResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.requestSepaMoneyTransferValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MoneyTransferOrderingResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

