/*
 * finAPI RESTful Services
 * finAPI RESTful Services
 *
 * OpenAPI spec version: v1.46.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;

/**
 * Data for a single direct debit
 */
@ApiModel(description = "Data for a single direct debit")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-05-14T19:12:52.919Z")
public class SingleDirectDebitData {
  @SerializedName("debitorName")
  private String debitorName = null;

  @SerializedName("debitorIban")
  private String debitorIban = null;

  @SerializedName("debitorBic")
  private String debitorBic = null;

  @SerializedName("amount")
  private BigDecimal amount = null;

  @SerializedName("purpose")
  private String purpose = null;

  @SerializedName("mandateId")
  private String mandateId = null;

  @SerializedName("mandateDate")
  private String mandateDate = null;

  @SerializedName("creditorId")
  private String creditorId = null;

  @SerializedName("endToEndId")
  private String endToEndId = null;

  public SingleDirectDebitData debitorName(String debitorName) {
    this.debitorName = debitorName;
    return this;
  }

   /**
   * Name of the debitor. Note: Neither finAPI nor the involved bank servers are guaranteed to validate the debitor name. Even if the debitor name does not depict the actual registered account holder of the specified debitor account, the direct debit request might still be successful.
   * @return debitorName
  **/
  @ApiModelProperty(required = true, value = "Name of the debitor. Note: Neither finAPI nor the involved bank servers are guaranteed to validate the debitor name. Even if the debitor name does not depict the actual registered account holder of the specified debitor account, the direct debit request might still be successful.")
  public String getDebitorName() {
    return debitorName;
  }

  public void setDebitorName(String debitorName) {
    this.debitorName = debitorName;
  }

  public SingleDirectDebitData debitorIban(String debitorIban) {
    this.debitorIban = debitorIban;
    return this;
  }

   /**
   * IBAN of the debitor&#39;s account
   * @return debitorIban
  **/
  @ApiModelProperty(required = true, value = "IBAN of the debitor's account")
  public String getDebitorIban() {
    return debitorIban;
  }

  public void setDebitorIban(String debitorIban) {
    this.debitorIban = debitorIban;
  }

  public SingleDirectDebitData debitorBic(String debitorBic) {
    this.debitorBic = debitorBic;
    return this;
  }

   /**
   * BIC of the debitor&#39;s account. Note: This field is optional if - and only if - the bank connection of the account that you want to transfer money to supports the IBAN-Only direct debit. You can find this out via GET /bankConnections/&lt;id&gt;. Also note that when a BIC is given, then this BIC will be used for the direct debit request independent of whether it is required or not.
   * @return debitorBic
  **/
  @ApiModelProperty(value = "BIC of the debitor's account. Note: This field is optional if - and only if - the bank connection of the account that you want to transfer money to supports the IBAN-Only direct debit. You can find this out via GET /bankConnections/<id>. Also note that when a BIC is given, then this BIC will be used for the direct debit request independent of whether it is required or not.")
  public String getDebitorBic() {
    return debitorBic;
  }

  public void setDebitorBic(String debitorBic) {
    this.debitorBic = debitorBic;
  }

  public SingleDirectDebitData amount(BigDecimal amount) {
    this.amount = amount;
    return this;
  }

   /**
   * The amount to transfer. Must be a positive decimal number with at most two decimal places (e.g. 99.90)
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "The amount to transfer. Must be a positive decimal number with at most two decimal places (e.g. 99.90)")
  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public SingleDirectDebitData purpose(String purpose) {
    this.purpose = purpose;
    return this;
  }

   /**
   * The purpose of the transfer transaction
   * @return purpose
  **/
  @ApiModelProperty(value = "The purpose of the transfer transaction")
  public String getPurpose() {
    return purpose;
  }

  public void setPurpose(String purpose) {
    this.purpose = purpose;
  }

  public SingleDirectDebitData mandateId(String mandateId) {
    this.mandateId = mandateId;
    return this;
  }

   /**
   * Mandate ID that this direct debit order is based on.
   * @return mandateId
  **/
  @ApiModelProperty(required = true, value = "Mandate ID that this direct debit order is based on.")
  public String getMandateId() {
    return mandateId;
  }

  public void setMandateId(String mandateId) {
    this.mandateId = mandateId;
  }

  public SingleDirectDebitData mandateDate(String mandateDate) {
    this.mandateDate = mandateDate;
    return this;
  }

   /**
   * Date of the mandate that this direct debit order is based on, in the format &#39;yyyy-MM-dd&#39;
   * @return mandateDate
  **/
  @ApiModelProperty(required = true, value = "Date of the mandate that this direct debit order is based on, in the format 'yyyy-MM-dd'")
  public String getMandateDate() {
    return mandateDate;
  }

  public void setMandateDate(String mandateDate) {
    this.mandateDate = mandateDate;
  }

  public SingleDirectDebitData creditorId(String creditorId) {
    this.creditorId = creditorId;
    return this;
  }

   /**
   * Creditor ID of the source account&#39;s holder
   * @return creditorId
  **/
  @ApiModelProperty(value = "Creditor ID of the source account's holder")
  public String getCreditorId() {
    return creditorId;
  }

  public void setCreditorId(String creditorId) {
    this.creditorId = creditorId;
  }

  public SingleDirectDebitData endToEndId(String endToEndId) {
    this.endToEndId = endToEndId;
    return this;
  }

   /**
   * End-To-End ID for the transfer transaction
   * @return endToEndId
  **/
  @ApiModelProperty(value = "End-To-End ID for the transfer transaction")
  public String getEndToEndId() {
    return endToEndId;
  }

  public void setEndToEndId(String endToEndId) {
    this.endToEndId = endToEndId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SingleDirectDebitData singleDirectDebitData = (SingleDirectDebitData) o;
    return Objects.equals(this.debitorName, singleDirectDebitData.debitorName) &&
        Objects.equals(this.debitorIban, singleDirectDebitData.debitorIban) &&
        Objects.equals(this.debitorBic, singleDirectDebitData.debitorBic) &&
        Objects.equals(this.amount, singleDirectDebitData.amount) &&
        Objects.equals(this.purpose, singleDirectDebitData.purpose) &&
        Objects.equals(this.mandateId, singleDirectDebitData.mandateId) &&
        Objects.equals(this.mandateDate, singleDirectDebitData.mandateDate) &&
        Objects.equals(this.creditorId, singleDirectDebitData.creditorId) &&
        Objects.equals(this.endToEndId, singleDirectDebitData.endToEndId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(debitorName, debitorIban, debitorBic, amount, purpose, mandateId, mandateDate, creditorId, endToEndId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SingleDirectDebitData {\n");
    
    sb.append("    debitorName: ").append(toIndentedString(debitorName)).append("\n");
    sb.append("    debitorIban: ").append(toIndentedString(debitorIban)).append("\n");
    sb.append("    debitorBic: ").append(toIndentedString(debitorBic)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    purpose: ").append(toIndentedString(purpose)).append("\n");
    sb.append("    mandateId: ").append(toIndentedString(mandateId)).append("\n");
    sb.append("    mandateDate: ").append(toIndentedString(mandateDate)).append("\n");
    sb.append("    creditorId: ").append(toIndentedString(creditorId)).append("\n");
    sb.append("    endToEndId: ").append(toIndentedString(endToEndId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

