/*
 * finAPI RESTful Services
 * finAPI RESTful Services
 *
 * OpenAPI spec version: v1.46.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;

/**
 * Container for a security position&#39;s data
 */
@ApiModel(description = "Container for a security position's data")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-05-14T19:12:52.919Z")
public class Security {
  @SerializedName("id")
  private Long id = null;

  @SerializedName("accountId")
  private Long accountId = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("isin")
  private String isin = null;

  @SerializedName("wkn")
  private String wkn = null;

  @SerializedName("quote")
  private BigDecimal quote = null;

  @SerializedName("quoteCurrency")
  private String quoteCurrency = null;

  /**
   * Type of quote. &#39;PERC&#39; if quote is a percentage value, &#39;ACTU&#39; if quote is the actual amount
   */
  @JsonAdapter(QuoteTypeEnum.Adapter.class)
  public enum QuoteTypeEnum {
    ACTU("ACTU"),
    
    PERC("PERC");

    private String value;

    QuoteTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static QuoteTypeEnum fromValue(String text) {
      for (QuoteTypeEnum b : QuoteTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<QuoteTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final QuoteTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public QuoteTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return QuoteTypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("quoteType")
  private QuoteTypeEnum quoteType = null;

  @SerializedName("quoteDate")
  private String quoteDate = null;

  @SerializedName("quantityNominal")
  private BigDecimal quantityNominal = null;

  /**
   * Type of quantity or nominal value. &#39;UNIT&#39; if value is a quantity, &#39;FAMT&#39; if value is the nominal amount
   */
  @JsonAdapter(QuantityNominalTypeEnum.Adapter.class)
  public enum QuantityNominalTypeEnum {
    UNIT("UNIT"),
    
    FAMT("FAMT");

    private String value;

    QuantityNominalTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static QuantityNominalTypeEnum fromValue(String text) {
      for (QuantityNominalTypeEnum b : QuantityNominalTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<QuantityNominalTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final QuantityNominalTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public QuantityNominalTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return QuantityNominalTypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("quantityNominalType")
  private QuantityNominalTypeEnum quantityNominalType = null;

  @SerializedName("marketValue")
  private BigDecimal marketValue = null;

  @SerializedName("marketValueCurrency")
  private String marketValueCurrency = null;

  @SerializedName("entryQuote")
  private BigDecimal entryQuote = null;

  @SerializedName("entryQuoteCurrency")
  private String entryQuoteCurrency = null;

  public Security id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * Identifier. Note: Whenever a security account is being updated, its security positions will be internally re-created, meaning that the identifier of a security position might change over time.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Identifier. Note: Whenever a security account is being updated, its security positions will be internally re-created, meaning that the identifier of a security position might change over time.")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public Security accountId(Long accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Security account identifier
   * @return accountId
  **/
  @ApiModelProperty(required = true, value = "Security account identifier")
  public Long getAccountId() {
    return accountId;
  }

  public void setAccountId(Long accountId) {
    this.accountId = accountId;
  }

  public Security name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Name
   * @return name
  **/
  @ApiModelProperty(value = "Name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Security isin(String isin) {
    this.isin = isin;
    return this;
  }

   /**
   * ISIN
   * @return isin
  **/
  @ApiModelProperty(value = "ISIN")
  public String getIsin() {
    return isin;
  }

  public void setIsin(String isin) {
    this.isin = isin;
  }

  public Security wkn(String wkn) {
    this.wkn = wkn;
    return this;
  }

   /**
   * WKN
   * @return wkn
  **/
  @ApiModelProperty(value = "WKN")
  public String getWkn() {
    return wkn;
  }

  public void setWkn(String wkn) {
    this.wkn = wkn;
  }

  public Security quote(BigDecimal quote) {
    this.quote = quote;
    return this;
  }

   /**
   * Quote
   * @return quote
  **/
  @ApiModelProperty(value = "Quote")
  public BigDecimal getQuote() {
    return quote;
  }

  public void setQuote(BigDecimal quote) {
    this.quote = quote;
  }

  public Security quoteCurrency(String quoteCurrency) {
    this.quoteCurrency = quoteCurrency;
    return this;
  }

   /**
   * Currency of quote
   * @return quoteCurrency
  **/
  @ApiModelProperty(value = "Currency of quote")
  public String getQuoteCurrency() {
    return quoteCurrency;
  }

  public void setQuoteCurrency(String quoteCurrency) {
    this.quoteCurrency = quoteCurrency;
  }

  public Security quoteType(QuoteTypeEnum quoteType) {
    this.quoteType = quoteType;
    return this;
  }

   /**
   * Type of quote. &#39;PERC&#39; if quote is a percentage value, &#39;ACTU&#39; if quote is the actual amount
   * @return quoteType
  **/
  @ApiModelProperty(value = "Type of quote. 'PERC' if quote is a percentage value, 'ACTU' if quote is the actual amount")
  public QuoteTypeEnum getQuoteType() {
    return quoteType;
  }

  public void setQuoteType(QuoteTypeEnum quoteType) {
    this.quoteType = quoteType;
  }

  public Security quoteDate(String quoteDate) {
    this.quoteDate = quoteDate;
    return this;
  }

   /**
   * Quote date
   * @return quoteDate
  **/
  @ApiModelProperty(value = "Quote date")
  public String getQuoteDate() {
    return quoteDate;
  }

  public void setQuoteDate(String quoteDate) {
    this.quoteDate = quoteDate;
  }

  public Security quantityNominal(BigDecimal quantityNominal) {
    this.quantityNominal = quantityNominal;
    return this;
  }

   /**
   * Value of quantity or nominal
   * @return quantityNominal
  **/
  @ApiModelProperty(value = "Value of quantity or nominal")
  public BigDecimal getQuantityNominal() {
    return quantityNominal;
  }

  public void setQuantityNominal(BigDecimal quantityNominal) {
    this.quantityNominal = quantityNominal;
  }

  public Security quantityNominalType(QuantityNominalTypeEnum quantityNominalType) {
    this.quantityNominalType = quantityNominalType;
    return this;
  }

   /**
   * Type of quantity or nominal value. &#39;UNIT&#39; if value is a quantity, &#39;FAMT&#39; if value is the nominal amount
   * @return quantityNominalType
  **/
  @ApiModelProperty(value = "Type of quantity or nominal value. 'UNIT' if value is a quantity, 'FAMT' if value is the nominal amount")
  public QuantityNominalTypeEnum getQuantityNominalType() {
    return quantityNominalType;
  }

  public void setQuantityNominalType(QuantityNominalTypeEnum quantityNominalType) {
    this.quantityNominalType = quantityNominalType;
  }

  public Security marketValue(BigDecimal marketValue) {
    this.marketValue = marketValue;
    return this;
  }

   /**
   * Market value
   * @return marketValue
  **/
  @ApiModelProperty(value = "Market value")
  public BigDecimal getMarketValue() {
    return marketValue;
  }

  public void setMarketValue(BigDecimal marketValue) {
    this.marketValue = marketValue;
  }

  public Security marketValueCurrency(String marketValueCurrency) {
    this.marketValueCurrency = marketValueCurrency;
    return this;
  }

   /**
   * Currency of market value
   * @return marketValueCurrency
  **/
  @ApiModelProperty(value = "Currency of market value")
  public String getMarketValueCurrency() {
    return marketValueCurrency;
  }

  public void setMarketValueCurrency(String marketValueCurrency) {
    this.marketValueCurrency = marketValueCurrency;
  }

  public Security entryQuote(BigDecimal entryQuote) {
    this.entryQuote = entryQuote;
    return this;
  }

   /**
   * Entry quote
   * @return entryQuote
  **/
  @ApiModelProperty(value = "Entry quote")
  public BigDecimal getEntryQuote() {
    return entryQuote;
  }

  public void setEntryQuote(BigDecimal entryQuote) {
    this.entryQuote = entryQuote;
  }

  public Security entryQuoteCurrency(String entryQuoteCurrency) {
    this.entryQuoteCurrency = entryQuoteCurrency;
    return this;
  }

   /**
   * Currency of entry quote
   * @return entryQuoteCurrency
  **/
  @ApiModelProperty(value = "Currency of entry quote")
  public String getEntryQuoteCurrency() {
    return entryQuoteCurrency;
  }

  public void setEntryQuoteCurrency(String entryQuoteCurrency) {
    this.entryQuoteCurrency = entryQuoteCurrency;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Security security = (Security) o;
    return Objects.equals(this.id, security.id) &&
        Objects.equals(this.accountId, security.accountId) &&
        Objects.equals(this.name, security.name) &&
        Objects.equals(this.isin, security.isin) &&
        Objects.equals(this.wkn, security.wkn) &&
        Objects.equals(this.quote, security.quote) &&
        Objects.equals(this.quoteCurrency, security.quoteCurrency) &&
        Objects.equals(this.quoteType, security.quoteType) &&
        Objects.equals(this.quoteDate, security.quoteDate) &&
        Objects.equals(this.quantityNominal, security.quantityNominal) &&
        Objects.equals(this.quantityNominalType, security.quantityNominalType) &&
        Objects.equals(this.marketValue, security.marketValue) &&
        Objects.equals(this.marketValueCurrency, security.marketValueCurrency) &&
        Objects.equals(this.entryQuote, security.entryQuote) &&
        Objects.equals(this.entryQuoteCurrency, security.entryQuoteCurrency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, accountId, name, isin, wkn, quote, quoteCurrency, quoteType, quoteDate, quantityNominal, quantityNominalType, marketValue, marketValueCurrency, entryQuote, entryQuoteCurrency);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Security {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    isin: ").append(toIndentedString(isin)).append("\n");
    sb.append("    wkn: ").append(toIndentedString(wkn)).append("\n");
    sb.append("    quote: ").append(toIndentedString(quote)).append("\n");
    sb.append("    quoteCurrency: ").append(toIndentedString(quoteCurrency)).append("\n");
    sb.append("    quoteType: ").append(toIndentedString(quoteType)).append("\n");
    sb.append("    quoteDate: ").append(toIndentedString(quoteDate)).append("\n");
    sb.append("    quantityNominal: ").append(toIndentedString(quantityNominal)).append("\n");
    sb.append("    quantityNominalType: ").append(toIndentedString(quantityNominalType)).append("\n");
    sb.append("    marketValue: ").append(toIndentedString(marketValue)).append("\n");
    sb.append("    marketValueCurrency: ").append(toIndentedString(marketValueCurrency)).append("\n");
    sb.append("    entryQuote: ").append(toIndentedString(entryQuote)).append("\n");
    sb.append("    entryQuoteCurrency: ").append(toIndentedString(entryQuoteCurrency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

