/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Container for user information")
public class UserInfo {
    @SerializedName(value="userId")
    private String userId = null;
    @SerializedName(value="registrationDate")
    private String registrationDate = null;
    @SerializedName(value="deletionDate")
    private String deletionDate = null;
    @SerializedName(value="lastActiveDate")
    private String lastActiveDate = null;

    public UserInfo userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="User's identifier")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public UserInfo registrationDate(String registrationDate) {
        this.registrationDate = registrationDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="User's registration date, in the format 'yyyy-MM-dd'")
    public String getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(String registrationDate) {
        this.registrationDate = registrationDate;
    }

    public UserInfo deletionDate(String deletionDate) {
        this.deletionDate = deletionDate;
        return this;
    }

    @ApiModelProperty(example="null", value="User's deletion date, in the format 'yyyy-MM-dd'. May be null if the user has not been deleted.")
    public String getDeletionDate() {
        return this.deletionDate;
    }

    public void setDeletionDate(String deletionDate) {
        this.deletionDate = deletionDate;
    }

    public UserInfo lastActiveDate(String lastActiveDate) {
        this.lastActiveDate = lastActiveDate;
        return this;
    }

    @ApiModelProperty(example="null", value="User's last active date, in the format 'yyyy-MM-dd'. May be null if the user has not yet logged in.")
    public String getLastActiveDate() {
        return this.lastActiveDate;
    }

    public void setLastActiveDate(String lastActiveDate) {
        this.lastActiveDate = lastActiveDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserInfo userInfo = (UserInfo)o;
        return Objects.equals(this.userId, userInfo.userId) && Objects.equals(this.registrationDate, userInfo.registrationDate) && Objects.equals(this.deletionDate, userInfo.deletionDate) && Objects.equals(this.lastActiveDate, userInfo.lastActiveDate);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.registrationDate, this.deletionDate, this.lastActiveDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserInfo {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    registrationDate: ").append(this.toIndentedString(this.registrationDate)).append("\n");
        sb.append("    deletionDate: ").append(this.toIndentedString(this.deletionDate)).append("\n");
        sb.append("    lastActiveDate: ").append(this.toIndentedString(this.lastActiveDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

