/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Update specific transactions parameters")
public class UpdateMultipleTransactionsParams {
    @SerializedName(value="isNew")
    private Boolean isNew = false;
    @SerializedName(value="isPotentialDuplicate")
    private Boolean isPotentialDuplicate = false;
    @SerializedName(value="categoryId")
    private Long categoryId = null;
    @SerializedName(value="labelIds")
    private List<Long> labelIds = new ArrayList<Long>();
    @SerializedName(value="ids")
    private List<Long> ids = new ArrayList<Long>();
    @SerializedName(value="accountIds")
    private List<Long> accountIds = new ArrayList<Long>();

    public UpdateMultipleTransactionsParams isNew(Boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this transactions should be flagged as 'new' or not. Any newly imported transaction will have this flag initially set to true. How you use this field is up to your interpretation. For example, you might want to set it to false once a user has clicked on/seen the transaction.")
    public Boolean getIsNew() {
        return this.isNew;
    }

    public void setIsNew(Boolean isNew) {
        this.isNew = isNew;
    }

    public UpdateMultipleTransactionsParams isPotentialDuplicate(Boolean isPotentialDuplicate) {
        this.isPotentialDuplicate = isPotentialDuplicate;
        return this;
    }

    @ApiModelProperty(example="null", value="You can set this field only to 'false'. finAPI marks transactions as a potential duplicates  when its internal duplicate detection algorithm is signaling so. Transactions that are flagged as duplicates can be deleted by the user. To prevent the user from deleting original transactions, which might lead to incorrect balances, it is not possible to manually set this flag to 'true'.")
    public Boolean getIsPotentialDuplicate() {
        return this.isPotentialDuplicate;
    }

    public void setIsPotentialDuplicate(Boolean isPotentialDuplicate) {
        this.isPotentialDuplicate = isPotentialDuplicate;
    }

    public UpdateMultipleTransactionsParams categoryId(Long categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifier of the new category to apply to the transaction. When updating the transaction's category, the category's fields 'id', 'name', 'parentId', 'parentName', and 'isCustom' will all get updated. To clear the category for the transaction, the categoryId field must be passed with value 0.")
    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public UpdateMultipleTransactionsParams labelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
        return this;
    }

    public UpdateMultipleTransactionsParams addLabelIdsItem(Long labelIdsItem) {
        this.labelIds.add(labelIdsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="Identifiers of labels to apply to the transaction. To clear transactions' labels, pass an empty array of identifiers: '[]'")
    public List<Long> getLabelIds() {
        return this.labelIds;
    }

    public void setLabelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
    }

    public UpdateMultipleTransactionsParams ids(List<Long> ids) {
        this.ids = ids;
        return this;
    }

    public UpdateMultipleTransactionsParams addIdsItem(Long idsItem) {
        this.ids.add(idsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="A comma-separated list of transaction identifiers. If specified, then only transactions whose identifier match any of the given identifiers will be regarded. The maximum number of identifiers is 100.")
    public List<Long> getIds() {
        return this.ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public UpdateMultipleTransactionsParams accountIds(List<Long> accountIds) {
        this.accountIds = accountIds;
        return this;
    }

    public UpdateMultipleTransactionsParams addAccountIdsItem(Long accountIdsItem) {
        this.accountIds.add(accountIdsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="A comma-separated list of account identifiers. If specified, then only transactions whose account's identifier is included in this list will be regarded.")
    public List<Long> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(List<Long> accountIds) {
        this.accountIds = accountIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateMultipleTransactionsParams updateMultipleTransactionsParams = (UpdateMultipleTransactionsParams)o;
        return Objects.equals(this.isNew, updateMultipleTransactionsParams.isNew) && Objects.equals(this.isPotentialDuplicate, updateMultipleTransactionsParams.isPotentialDuplicate) && Objects.equals(this.categoryId, updateMultipleTransactionsParams.categoryId) && Objects.equals(this.labelIds, updateMultipleTransactionsParams.labelIds) && Objects.equals(this.ids, updateMultipleTransactionsParams.ids) && Objects.equals(this.accountIds, updateMultipleTransactionsParams.accountIds);
    }

    public int hashCode() {
        return Objects.hash(this.isNew, this.isPotentialDuplicate, this.categoryId, this.labelIds, this.ids, this.accountIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateMultipleTransactionsParams {\n");
        sb.append("    isNew: ").append(this.toIndentedString(this.isNew)).append("\n");
        sb.append("    isPotentialDuplicate: ").append(this.toIndentedString(this.isPotentialDuplicate)).append("\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("    labelIds: ").append(this.toIndentedString(this.labelIds)).append("\n");
        sb.append("    ids: ").append(this.toIndentedString(this.ids)).append("\n");
        sb.append("    accountIds: ").append(this.toIndentedString(this.accountIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

