/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Data of a sub-transaction")
public class SubTransactionParams {
    @SerializedName(value="amount")
    private BigDecimal amount = null;
    @SerializedName(value="categoryId")
    private Long categoryId = null;
    @SerializedName(value="purpose")
    private String purpose = null;
    @SerializedName(value="counterpart")
    private String counterpart = null;
    @SerializedName(value="counterpartAccountNumber")
    private String counterpartAccountNumber = null;
    @SerializedName(value="counterpartIban")
    private String counterpartIban = null;
    @SerializedName(value="counterpartBic")
    private String counterpartBic = null;
    @SerializedName(value="counterpartBlz")
    private String counterpartBlz = null;
    @SerializedName(value="labelIds")
    private List<Long> labelIds = new ArrayList<Long>();

    public SubTransactionParams amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Amount")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public SubTransactionParams categoryId(Long categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @ApiModelProperty(example="null", value="Category identifier. If not specified, the original transaction's category will be applied. If you explicitly want the sub-transaction to have no category, then pass this field with value '0' (zero).")
    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public SubTransactionParams purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(example="null", value="Purpose. Maximum length is 2000. If not specified, the original transaction's value will be applied.")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public SubTransactionParams counterpart(String counterpart) {
        this.counterpart = counterpart;
        return this;
    }

    @ApiModelProperty(example="null", value="Counterpart. Maximum length is 270. If not specified, the original transaction's value will be applied.")
    public String getCounterpart() {
        return this.counterpart;
    }

    public void setCounterpart(String counterpart) {
        this.counterpart = counterpart;
    }

    public SubTransactionParams counterpartAccountNumber(String counterpartAccountNumber) {
        this.counterpartAccountNumber = counterpartAccountNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Counterpart account number. If not specified, the original transaction's value will be applied.")
    public String getCounterpartAccountNumber() {
        return this.counterpartAccountNumber;
    }

    public void setCounterpartAccountNumber(String counterpartAccountNumber) {
        this.counterpartAccountNumber = counterpartAccountNumber;
    }

    public SubTransactionParams counterpartIban(String counterpartIban) {
        this.counterpartIban = counterpartIban;
        return this;
    }

    @ApiModelProperty(example="null", value="Counterpart IBAN. If not specified, the original transaction's value will be applied.")
    public String getCounterpartIban() {
        return this.counterpartIban;
    }

    public void setCounterpartIban(String counterpartIban) {
        this.counterpartIban = counterpartIban;
    }

    public SubTransactionParams counterpartBic(String counterpartBic) {
        this.counterpartBic = counterpartBic;
        return this;
    }

    @ApiModelProperty(example="null", value="Counterpart BIC. If not specified, the original transaction's value will be applied.")
    public String getCounterpartBic() {
        return this.counterpartBic;
    }

    public void setCounterpartBic(String counterpartBic) {
        this.counterpartBic = counterpartBic;
    }

    public SubTransactionParams counterpartBlz(String counterpartBlz) {
        this.counterpartBlz = counterpartBlz;
        return this;
    }

    @ApiModelProperty(example="null", value="Counterpart BLZ. If not specified, the original transaction's value will be applied.")
    public String getCounterpartBlz() {
        return this.counterpartBlz;
    }

    public void setCounterpartBlz(String counterpartBlz) {
        this.counterpartBlz = counterpartBlz;
    }

    public SubTransactionParams labelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
        return this;
    }

    public SubTransactionParams addLabelIdsItem(Long labelIdsItem) {
        this.labelIds.add(labelIdsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="List of connected labels. Note that when this field is not specified, then the labels of the original transaction will NOT get applied to the sub-transaction. Instead, the sub-transaction will have no labels assigned to it.")
    public List<Long> getLabelIds() {
        return this.labelIds;
    }

    public void setLabelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubTransactionParams subTransactionParams = (SubTransactionParams)o;
        return Objects.equals(this.amount, subTransactionParams.amount) && Objects.equals(this.categoryId, subTransactionParams.categoryId) && Objects.equals(this.purpose, subTransactionParams.purpose) && Objects.equals(this.counterpart, subTransactionParams.counterpart) && Objects.equals(this.counterpartAccountNumber, subTransactionParams.counterpartAccountNumber) && Objects.equals(this.counterpartIban, subTransactionParams.counterpartIban) && Objects.equals(this.counterpartBic, subTransactionParams.counterpartBic) && Objects.equals(this.counterpartBlz, subTransactionParams.counterpartBlz) && Objects.equals(this.labelIds, subTransactionParams.labelIds);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.categoryId, this.purpose, this.counterpart, this.counterpartAccountNumber, this.counterpartIban, this.counterpartBic, this.counterpartBlz, this.labelIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubTransactionParams {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    counterpart: ").append(this.toIndentedString(this.counterpart)).append("\n");
        sb.append("    counterpartAccountNumber: ").append(this.toIndentedString(this.counterpartAccountNumber)).append("\n");
        sb.append("    counterpartIban: ").append(this.toIndentedString(this.counterpartIban)).append("\n");
        sb.append("    counterpartBic: ").append(this.toIndentedString(this.counterpartBic)).append("\n");
        sb.append("    counterpartBlz: ").append(this.toIndentedString(this.counterpartBlz)).append("\n");
        sb.append("    labelIds: ").append(this.toIndentedString(this.labelIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

